/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.ydb.metrics;

import io.prometheus.client.Collector;
import io.prometheus.client.GaugeMetricFamily;
import io.prometheus.client.SimpleCollector;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GaugeSupplierCollector
extends SimpleCollector<Child>
implements Collector.Describable {
    private static final Logger log = LoggerFactory.getLogger(GaugeSupplierCollector.class);

    private GaugeSupplierCollector(Builder builder) {
        super((SimpleCollector.Builder)builder);
    }

    public static Builder build() {
        return new Builder();
    }

    public List<Collector.MetricFamilySamples> collect() {
        ArrayList samples = new ArrayList();
        this.children.forEach((labelValues, child) -> {
            try {
                samples.add(new Collector.MetricFamilySamples.Sample(this.fullname, this.labelNames, labelValues, child.getValue()));
            }
            catch (Exception e) {
                log.error("Could not add child sample", (Throwable)e);
            }
        });
        return this.familySamplesList(Collector.Type.GAUGE, samples);
    }

    public List<Collector.MetricFamilySamples> describe() {
        return List.of(new GaugeMetricFamily(this.fullname, this.help, this.labelNames));
    }

    protected Child newChild() {
        return new Child();
    }

    public void supplier(Supplier<Number> supplier) {
        ((Child)this.noLabelsChild).supplier(supplier);
    }

    public static class Builder
    extends SimpleCollector.Builder<Builder, GaugeSupplierCollector> {
        public GaugeSupplierCollector create() {
            return new GaugeSupplierCollector(this);
        }
    }

    public class Child {
        private Supplier<? extends Number> supplier = () -> 0.0;

        public GaugeSupplierCollector supplier(Supplier<? extends Number> supplier) {
            this.supplier = supplier;
            return GaugeSupplierCollector.this;
        }

        public double getValue() {
            return this.supplier.get().doubleValue();
        }
    }
}

