/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.ydb;

import com.google.common.net.HostAndPort;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.Arrays;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;

public final class YdbConfig {
    private static final Duration SESSION_KEEP_ALIVE_TIME_DEFAULT = Duration.ofMinutes(5L);
    private static final Duration SESSION_MAX_IDLE_TIME_DEFAULT = Duration.ofMinutes(5L);
    private static final Duration TCP_KEEP_ALIVE_TIME_DEFAULT = Duration.ofSeconds(5L);
    private static final Duration TCP_KEEP_ALIVE_TIMEOUT_DEFAULT = Duration.ofSeconds(1L);
    private static final Duration SESSION_CREATE_TIMEOUT_DEFAULT = Duration.ofSeconds(1L);
    private static final int SESSION_POOL_SIZE_DEFAULT = 100;
    private static final int SESSION_CREATE_RETRY_COUNT_DEFAULT = 3;
    @NonNull
    private final String tablespace;
    @NonNull
    private final String database;
    private final String discoveryEndpoint;
    private final HostAndPort hostAndPort;
    private final Duration sessionCreationTimeout;
    private final Integer sessionCreationMaxRetries;
    private final Duration sessionKeepAliveTime;
    private final Duration sessionMaxIdleTime;
    private final Integer sessionPoolMin;
    private final Integer sessionPoolMax;
    private final Duration tcpKeepaliveTime;
    private final Duration tcpKeepaliveTimeout;
    private final boolean useTLS;
    private final boolean useTrustStore;
    private final byte[] rootCA;
    private final Boolean useSingleChannelTransport;

    public static YdbConfig createForTesting(String host, int port, String tablespace, String database) {
        return new YdbConfig(tablespace, database, null, HostAndPort.fromParts((String)host, (int)port), SESSION_CREATE_TIMEOUT_DEFAULT, 3, SESSION_KEEP_ALIVE_TIME_DEFAULT, SESSION_MAX_IDLE_TIME_DEFAULT, 100, 100, TCP_KEEP_ALIVE_TIME_DEFAULT, TCP_KEEP_ALIVE_TIMEOUT_DEFAULT, false, false, null, true);
    }

    public Duration getSessionCreationTimeout() {
        return Optional.ofNullable(this.sessionCreationTimeout).orElse(SESSION_CREATE_TIMEOUT_DEFAULT);
    }

    public Integer getSessionCreationMaxRetries() {
        return Optional.ofNullable(this.sessionCreationMaxRetries).orElse(3);
    }

    public Duration getSessionKeepAliveTime() {
        return Optional.ofNullable(this.sessionKeepAliveTime).orElse(SESSION_KEEP_ALIVE_TIME_DEFAULT);
    }

    public Duration getSessionMaxIdleTime() {
        return Optional.ofNullable(this.sessionMaxIdleTime).orElse(SESSION_MAX_IDLE_TIME_DEFAULT);
    }

    public Integer getSessionPoolMin() {
        return Optional.ofNullable(this.sessionPoolMin).orElse(100);
    }

    public Integer getSessionPoolMax() {
        return Optional.ofNullable(this.sessionPoolMax).orElse(100);
    }

    public Duration getTcpKeepaliveTime() {
        return Optional.ofNullable(this.tcpKeepaliveTime).orElse(TCP_KEEP_ALIVE_TIME_DEFAULT);
    }

    public Duration getTcpKeepaliveTimeout() {
        return Optional.ofNullable(this.tcpKeepaliveTimeout).orElse(TCP_KEEP_ALIVE_TIMEOUT_DEFAULT);
    }

    public boolean isUseSingleChannelTransport() {
        return Optional.ofNullable(this.useSingleChannelTransport).orElse(false);
    }

    @ConstructorProperties(value={"tablespace", "database", "discoveryEndpoint", "hostAndPort", "sessionCreationTimeout", "sessionCreationMaxRetries", "sessionKeepAliveTime", "sessionMaxIdleTime", "sessionPoolMin", "sessionPoolMax", "tcpKeepaliveTime", "tcpKeepaliveTimeout", "useTLS", "useTrustStore", "rootCA", "useSingleChannelTransport"})
    @Generated
    YdbConfig(@NonNull String tablespace, @NonNull String database, String discoveryEndpoint, HostAndPort hostAndPort, Duration sessionCreationTimeout, Integer sessionCreationMaxRetries, Duration sessionKeepAliveTime, Duration sessionMaxIdleTime, Integer sessionPoolMin, Integer sessionPoolMax, Duration tcpKeepaliveTime, Duration tcpKeepaliveTimeout, boolean useTLS, boolean useTrustStore, byte[] rootCA, Boolean useSingleChannelTransport) {
        if (tablespace == null) {
            throw new NullPointerException("tablespace is marked non-null but is null");
        }
        if (database == null) {
            throw new NullPointerException("database is marked non-null but is null");
        }
        this.tablespace = tablespace;
        this.database = database;
        this.discoveryEndpoint = discoveryEndpoint;
        this.hostAndPort = hostAndPort;
        this.sessionCreationTimeout = sessionCreationTimeout;
        this.sessionCreationMaxRetries = sessionCreationMaxRetries;
        this.sessionKeepAliveTime = sessionKeepAliveTime;
        this.sessionMaxIdleTime = sessionMaxIdleTime;
        this.sessionPoolMin = sessionPoolMin;
        this.sessionPoolMax = sessionPoolMax;
        this.tcpKeepaliveTime = tcpKeepaliveTime;
        this.tcpKeepaliveTimeout = tcpKeepaliveTimeout;
        this.useTLS = useTLS;
        this.useTrustStore = useTrustStore;
        this.rootCA = rootCA;
        this.useSingleChannelTransport = useSingleChannelTransport;
    }

    @Generated
    public static YdbConfigBuilder builder() {
        return new YdbConfigBuilder();
    }

    @NonNull
    @Generated
    public String getTablespace() {
        return this.tablespace;
    }

    @NonNull
    @Generated
    public String getDatabase() {
        return this.database;
    }

    @Generated
    public String getDiscoveryEndpoint() {
        return this.discoveryEndpoint;
    }

    @Generated
    public HostAndPort getHostAndPort() {
        return this.hostAndPort;
    }

    @Generated
    public boolean isUseTLS() {
        return this.useTLS;
    }

    @Generated
    public boolean isUseTrustStore() {
        return this.useTrustStore;
    }

    @Generated
    public byte[] getRootCA() {
        return this.rootCA;
    }

    @Generated
    public Boolean getUseSingleChannelTransport() {
        return this.useSingleChannelTransport;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof YdbConfig)) {
            return false;
        }
        YdbConfig other = (YdbConfig)o;
        if (this.isUseTLS() != other.isUseTLS()) {
            return false;
        }
        if (this.isUseTrustStore() != other.isUseTrustStore()) {
            return false;
        }
        Integer this$sessionCreationMaxRetries = this.getSessionCreationMaxRetries();
        Integer other$sessionCreationMaxRetries = other.getSessionCreationMaxRetries();
        if (this$sessionCreationMaxRetries == null ? other$sessionCreationMaxRetries != null : !((Object)this$sessionCreationMaxRetries).equals(other$sessionCreationMaxRetries)) {
            return false;
        }
        Integer this$sessionPoolMin = this.getSessionPoolMin();
        Integer other$sessionPoolMin = other.getSessionPoolMin();
        if (this$sessionPoolMin == null ? other$sessionPoolMin != null : !((Object)this$sessionPoolMin).equals(other$sessionPoolMin)) {
            return false;
        }
        Integer this$sessionPoolMax = this.getSessionPoolMax();
        Integer other$sessionPoolMax = other.getSessionPoolMax();
        if (this$sessionPoolMax == null ? other$sessionPoolMax != null : !((Object)this$sessionPoolMax).equals(other$sessionPoolMax)) {
            return false;
        }
        Boolean this$useSingleChannelTransport = this.getUseSingleChannelTransport();
        Boolean other$useSingleChannelTransport = other.getUseSingleChannelTransport();
        if (this$useSingleChannelTransport == null ? other$useSingleChannelTransport != null : !((Object)this$useSingleChannelTransport).equals(other$useSingleChannelTransport)) {
            return false;
        }
        String this$tablespace = this.getTablespace();
        String other$tablespace = other.getTablespace();
        if (this$tablespace == null ? other$tablespace != null : !this$tablespace.equals(other$tablespace)) {
            return false;
        }
        String this$database = this.getDatabase();
        String other$database = other.getDatabase();
        if (this$database == null ? other$database != null : !this$database.equals(other$database)) {
            return false;
        }
        String this$discoveryEndpoint = this.getDiscoveryEndpoint();
        String other$discoveryEndpoint = other.getDiscoveryEndpoint();
        if (this$discoveryEndpoint == null ? other$discoveryEndpoint != null : !this$discoveryEndpoint.equals(other$discoveryEndpoint)) {
            return false;
        }
        HostAndPort this$hostAndPort = this.getHostAndPort();
        HostAndPort other$hostAndPort = other.getHostAndPort();
        if (this$hostAndPort == null ? other$hostAndPort != null : !this$hostAndPort.equals(other$hostAndPort)) {
            return false;
        }
        Duration this$sessionCreationTimeout = this.getSessionCreationTimeout();
        Duration other$sessionCreationTimeout = other.getSessionCreationTimeout();
        if (this$sessionCreationTimeout == null ? other$sessionCreationTimeout != null : !((Object)this$sessionCreationTimeout).equals(other$sessionCreationTimeout)) {
            return false;
        }
        Duration this$sessionKeepAliveTime = this.getSessionKeepAliveTime();
        Duration other$sessionKeepAliveTime = other.getSessionKeepAliveTime();
        if (this$sessionKeepAliveTime == null ? other$sessionKeepAliveTime != null : !((Object)this$sessionKeepAliveTime).equals(other$sessionKeepAliveTime)) {
            return false;
        }
        Duration this$sessionMaxIdleTime = this.getSessionMaxIdleTime();
        Duration other$sessionMaxIdleTime = other.getSessionMaxIdleTime();
        if (this$sessionMaxIdleTime == null ? other$sessionMaxIdleTime != null : !((Object)this$sessionMaxIdleTime).equals(other$sessionMaxIdleTime)) {
            return false;
        }
        Duration this$tcpKeepaliveTime = this.getTcpKeepaliveTime();
        Duration other$tcpKeepaliveTime = other.getTcpKeepaliveTime();
        if (this$tcpKeepaliveTime == null ? other$tcpKeepaliveTime != null : !((Object)this$tcpKeepaliveTime).equals(other$tcpKeepaliveTime)) {
            return false;
        }
        Duration this$tcpKeepaliveTimeout = this.getTcpKeepaliveTimeout();
        Duration other$tcpKeepaliveTimeout = other.getTcpKeepaliveTimeout();
        if (this$tcpKeepaliveTimeout == null ? other$tcpKeepaliveTimeout != null : !((Object)this$tcpKeepaliveTimeout).equals(other$tcpKeepaliveTimeout)) {
            return false;
        }
        return Arrays.equals(this.getRootCA(), other.getRootCA());
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isUseTLS() ? 79 : 97);
        result = result * 59 + (this.isUseTrustStore() ? 79 : 97);
        Integer $sessionCreationMaxRetries = this.getSessionCreationMaxRetries();
        result = result * 59 + ($sessionCreationMaxRetries == null ? 43 : ((Object)$sessionCreationMaxRetries).hashCode());
        Integer $sessionPoolMin = this.getSessionPoolMin();
        result = result * 59 + ($sessionPoolMin == null ? 43 : ((Object)$sessionPoolMin).hashCode());
        Integer $sessionPoolMax = this.getSessionPoolMax();
        result = result * 59 + ($sessionPoolMax == null ? 43 : ((Object)$sessionPoolMax).hashCode());
        Boolean $useSingleChannelTransport = this.getUseSingleChannelTransport();
        result = result * 59 + ($useSingleChannelTransport == null ? 43 : ((Object)$useSingleChannelTransport).hashCode());
        String $tablespace = this.getTablespace();
        result = result * 59 + ($tablespace == null ? 43 : $tablespace.hashCode());
        String $database = this.getDatabase();
        result = result * 59 + ($database == null ? 43 : $database.hashCode());
        String $discoveryEndpoint = this.getDiscoveryEndpoint();
        result = result * 59 + ($discoveryEndpoint == null ? 43 : $discoveryEndpoint.hashCode());
        HostAndPort $hostAndPort = this.getHostAndPort();
        result = result * 59 + ($hostAndPort == null ? 43 : $hostAndPort.hashCode());
        Duration $sessionCreationTimeout = this.getSessionCreationTimeout();
        result = result * 59 + ($sessionCreationTimeout == null ? 43 : ((Object)$sessionCreationTimeout).hashCode());
        Duration $sessionKeepAliveTime = this.getSessionKeepAliveTime();
        result = result * 59 + ($sessionKeepAliveTime == null ? 43 : ((Object)$sessionKeepAliveTime).hashCode());
        Duration $sessionMaxIdleTime = this.getSessionMaxIdleTime();
        result = result * 59 + ($sessionMaxIdleTime == null ? 43 : ((Object)$sessionMaxIdleTime).hashCode());
        Duration $tcpKeepaliveTime = this.getTcpKeepaliveTime();
        result = result * 59 + ($tcpKeepaliveTime == null ? 43 : ((Object)$tcpKeepaliveTime).hashCode());
        Duration $tcpKeepaliveTimeout = this.getTcpKeepaliveTimeout();
        result = result * 59 + ($tcpKeepaliveTimeout == null ? 43 : ((Object)$tcpKeepaliveTimeout).hashCode());
        result = result * 59 + Arrays.hashCode(this.getRootCA());
        return result;
    }

    @Generated
    public String toString() {
        return "YdbConfig(tablespace=" + this.getTablespace() + ", database=" + this.getDatabase() + ", discoveryEndpoint=" + this.getDiscoveryEndpoint() + ", hostAndPort=" + this.getHostAndPort() + ", sessionCreationTimeout=" + this.getSessionCreationTimeout() + ", sessionCreationMaxRetries=" + this.getSessionCreationMaxRetries() + ", sessionKeepAliveTime=" + this.getSessionKeepAliveTime() + ", sessionMaxIdleTime=" + this.getSessionMaxIdleTime() + ", sessionPoolMin=" + this.getSessionPoolMin() + ", sessionPoolMax=" + this.getSessionPoolMax() + ", tcpKeepaliveTime=" + this.getTcpKeepaliveTime() + ", tcpKeepaliveTimeout=" + this.getTcpKeepaliveTimeout() + ", useTLS=" + this.isUseTLS() + ", useTrustStore=" + this.isUseTrustStore() + ", rootCA=" + Arrays.toString(this.getRootCA()) + ", useSingleChannelTransport=" + this.getUseSingleChannelTransport() + ")";
    }

    @Generated
    public YdbConfig withTablespace(@NonNull String tablespace) {
        if (tablespace == null) {
            throw new NullPointerException("tablespace is marked non-null but is null");
        }
        return this.tablespace == tablespace ? this : new YdbConfig(tablespace, this.database, this.discoveryEndpoint, this.hostAndPort, this.sessionCreationTimeout, this.sessionCreationMaxRetries, this.sessionKeepAliveTime, this.sessionMaxIdleTime, this.sessionPoolMin, this.sessionPoolMax, this.tcpKeepaliveTime, this.tcpKeepaliveTimeout, this.useTLS, this.useTrustStore, this.rootCA, this.useSingleChannelTransport);
    }

    @Generated
    public YdbConfig withDatabase(@NonNull String database) {
        if (database == null) {
            throw new NullPointerException("database is marked non-null but is null");
        }
        return this.database == database ? this : new YdbConfig(this.tablespace, database, this.discoveryEndpoint, this.hostAndPort, this.sessionCreationTimeout, this.sessionCreationMaxRetries, this.sessionKeepAliveTime, this.sessionMaxIdleTime, this.sessionPoolMin, this.sessionPoolMax, this.tcpKeepaliveTime, this.tcpKeepaliveTimeout, this.useTLS, this.useTrustStore, this.rootCA, this.useSingleChannelTransport);
    }

    @Generated
    public YdbConfig withDiscoveryEndpoint(String discoveryEndpoint) {
        return this.discoveryEndpoint == discoveryEndpoint ? this : new YdbConfig(this.tablespace, this.database, discoveryEndpoint, this.hostAndPort, this.sessionCreationTimeout, this.sessionCreationMaxRetries, this.sessionKeepAliveTime, this.sessionMaxIdleTime, this.sessionPoolMin, this.sessionPoolMax, this.tcpKeepaliveTime, this.tcpKeepaliveTimeout, this.useTLS, this.useTrustStore, this.rootCA, this.useSingleChannelTransport);
    }

    @Generated
    public YdbConfig withHostAndPort(HostAndPort hostAndPort) {
        return this.hostAndPort == hostAndPort ? this : new YdbConfig(this.tablespace, this.database, this.discoveryEndpoint, hostAndPort, this.sessionCreationTimeout, this.sessionCreationMaxRetries, this.sessionKeepAliveTime, this.sessionMaxIdleTime, this.sessionPoolMin, this.sessionPoolMax, this.tcpKeepaliveTime, this.tcpKeepaliveTimeout, this.useTLS, this.useTrustStore, this.rootCA, this.useSingleChannelTransport);
    }

    @Generated
    public YdbConfig withSessionCreationTimeout(Duration sessionCreationTimeout) {
        return this.sessionCreationTimeout == sessionCreationTimeout ? this : new YdbConfig(this.tablespace, this.database, this.discoveryEndpoint, this.hostAndPort, sessionCreationTimeout, this.sessionCreationMaxRetries, this.sessionKeepAliveTime, this.sessionMaxIdleTime, this.sessionPoolMin, this.sessionPoolMax, this.tcpKeepaliveTime, this.tcpKeepaliveTimeout, this.useTLS, this.useTrustStore, this.rootCA, this.useSingleChannelTransport);
    }

    @Generated
    public YdbConfig withSessionCreationMaxRetries(Integer sessionCreationMaxRetries) {
        return this.sessionCreationMaxRetries == sessionCreationMaxRetries ? this : new YdbConfig(this.tablespace, this.database, this.discoveryEndpoint, this.hostAndPort, this.sessionCreationTimeout, sessionCreationMaxRetries, this.sessionKeepAliveTime, this.sessionMaxIdleTime, this.sessionPoolMin, this.sessionPoolMax, this.tcpKeepaliveTime, this.tcpKeepaliveTimeout, this.useTLS, this.useTrustStore, this.rootCA, this.useSingleChannelTransport);
    }

    @Generated
    public YdbConfig withSessionKeepAliveTime(Duration sessionKeepAliveTime) {
        return this.sessionKeepAliveTime == sessionKeepAliveTime ? this : new YdbConfig(this.tablespace, this.database, this.discoveryEndpoint, this.hostAndPort, this.sessionCreationTimeout, this.sessionCreationMaxRetries, sessionKeepAliveTime, this.sessionMaxIdleTime, this.sessionPoolMin, this.sessionPoolMax, this.tcpKeepaliveTime, this.tcpKeepaliveTimeout, this.useTLS, this.useTrustStore, this.rootCA, this.useSingleChannelTransport);
    }

    @Generated
    public YdbConfig withSessionMaxIdleTime(Duration sessionMaxIdleTime) {
        return this.sessionMaxIdleTime == sessionMaxIdleTime ? this : new YdbConfig(this.tablespace, this.database, this.discoveryEndpoint, this.hostAndPort, this.sessionCreationTimeout, this.sessionCreationMaxRetries, this.sessionKeepAliveTime, sessionMaxIdleTime, this.sessionPoolMin, this.sessionPoolMax, this.tcpKeepaliveTime, this.tcpKeepaliveTimeout, this.useTLS, this.useTrustStore, this.rootCA, this.useSingleChannelTransport);
    }

    @Generated
    public YdbConfig withSessionPoolMin(Integer sessionPoolMin) {
        return this.sessionPoolMin == sessionPoolMin ? this : new YdbConfig(this.tablespace, this.database, this.discoveryEndpoint, this.hostAndPort, this.sessionCreationTimeout, this.sessionCreationMaxRetries, this.sessionKeepAliveTime, this.sessionMaxIdleTime, sessionPoolMin, this.sessionPoolMax, this.tcpKeepaliveTime, this.tcpKeepaliveTimeout, this.useTLS, this.useTrustStore, this.rootCA, this.useSingleChannelTransport);
    }

    @Generated
    public YdbConfig withSessionPoolMax(Integer sessionPoolMax) {
        return this.sessionPoolMax == sessionPoolMax ? this : new YdbConfig(this.tablespace, this.database, this.discoveryEndpoint, this.hostAndPort, this.sessionCreationTimeout, this.sessionCreationMaxRetries, this.sessionKeepAliveTime, this.sessionMaxIdleTime, this.sessionPoolMin, sessionPoolMax, this.tcpKeepaliveTime, this.tcpKeepaliveTimeout, this.useTLS, this.useTrustStore, this.rootCA, this.useSingleChannelTransport);
    }

    @Generated
    public YdbConfig withTcpKeepaliveTime(Duration tcpKeepaliveTime) {
        return this.tcpKeepaliveTime == tcpKeepaliveTime ? this : new YdbConfig(this.tablespace, this.database, this.discoveryEndpoint, this.hostAndPort, this.sessionCreationTimeout, this.sessionCreationMaxRetries, this.sessionKeepAliveTime, this.sessionMaxIdleTime, this.sessionPoolMin, this.sessionPoolMax, tcpKeepaliveTime, this.tcpKeepaliveTimeout, this.useTLS, this.useTrustStore, this.rootCA, this.useSingleChannelTransport);
    }

    @Generated
    public YdbConfig withTcpKeepaliveTimeout(Duration tcpKeepaliveTimeout) {
        return this.tcpKeepaliveTimeout == tcpKeepaliveTimeout ? this : new YdbConfig(this.tablespace, this.database, this.discoveryEndpoint, this.hostAndPort, this.sessionCreationTimeout, this.sessionCreationMaxRetries, this.sessionKeepAliveTime, this.sessionMaxIdleTime, this.sessionPoolMin, this.sessionPoolMax, this.tcpKeepaliveTime, tcpKeepaliveTimeout, this.useTLS, this.useTrustStore, this.rootCA, this.useSingleChannelTransport);
    }

    @Generated
    public YdbConfig withUseTLS(boolean useTLS) {
        return this.useTLS == useTLS ? this : new YdbConfig(this.tablespace, this.database, this.discoveryEndpoint, this.hostAndPort, this.sessionCreationTimeout, this.sessionCreationMaxRetries, this.sessionKeepAliveTime, this.sessionMaxIdleTime, this.sessionPoolMin, this.sessionPoolMax, this.tcpKeepaliveTime, this.tcpKeepaliveTimeout, useTLS, this.useTrustStore, this.rootCA, this.useSingleChannelTransport);
    }

    @Generated
    public YdbConfig withUseTrustStore(boolean useTrustStore) {
        return this.useTrustStore == useTrustStore ? this : new YdbConfig(this.tablespace, this.database, this.discoveryEndpoint, this.hostAndPort, this.sessionCreationTimeout, this.sessionCreationMaxRetries, this.sessionKeepAliveTime, this.sessionMaxIdleTime, this.sessionPoolMin, this.sessionPoolMax, this.tcpKeepaliveTime, this.tcpKeepaliveTimeout, this.useTLS, useTrustStore, this.rootCA, this.useSingleChannelTransport);
    }

    @Generated
    public YdbConfig withRootCA(byte[] rootCA) {
        return this.rootCA == rootCA ? this : new YdbConfig(this.tablespace, this.database, this.discoveryEndpoint, this.hostAndPort, this.sessionCreationTimeout, this.sessionCreationMaxRetries, this.sessionKeepAliveTime, this.sessionMaxIdleTime, this.sessionPoolMin, this.sessionPoolMax, this.tcpKeepaliveTime, this.tcpKeepaliveTimeout, this.useTLS, this.useTrustStore, rootCA, this.useSingleChannelTransport);
    }

    @Generated
    public YdbConfig withUseSingleChannelTransport(Boolean useSingleChannelTransport) {
        return this.useSingleChannelTransport == useSingleChannelTransport ? this : new YdbConfig(this.tablespace, this.database, this.discoveryEndpoint, this.hostAndPort, this.sessionCreationTimeout, this.sessionCreationMaxRetries, this.sessionKeepAliveTime, this.sessionMaxIdleTime, this.sessionPoolMin, this.sessionPoolMax, this.tcpKeepaliveTime, this.tcpKeepaliveTimeout, this.useTLS, this.useTrustStore, this.rootCA, useSingleChannelTransport);
    }

    @Generated
    public static class YdbConfigBuilder {
        @Generated
        private String tablespace;
        @Generated
        private String database;
        @Generated
        private String discoveryEndpoint;
        @Generated
        private HostAndPort hostAndPort;
        @Generated
        private Duration sessionCreationTimeout;
        @Generated
        private Integer sessionCreationMaxRetries;
        @Generated
        private Duration sessionKeepAliveTime;
        @Generated
        private Duration sessionMaxIdleTime;
        @Generated
        private Integer sessionPoolMin;
        @Generated
        private Integer sessionPoolMax;
        @Generated
        private Duration tcpKeepaliveTime;
        @Generated
        private Duration tcpKeepaliveTimeout;
        @Generated
        private boolean useTLS;
        @Generated
        private boolean useTrustStore;
        @Generated
        private byte[] rootCA;
        @Generated
        private Boolean useSingleChannelTransport;

        @Generated
        YdbConfigBuilder() {
        }

        @Generated
        public YdbConfigBuilder tablespace(@NonNull String tablespace) {
            if (tablespace == null) {
                throw new NullPointerException("tablespace is marked non-null but is null");
            }
            this.tablespace = tablespace;
            return this;
        }

        @Generated
        public YdbConfigBuilder database(@NonNull String database) {
            if (database == null) {
                throw new NullPointerException("database is marked non-null but is null");
            }
            this.database = database;
            return this;
        }

        @Generated
        public YdbConfigBuilder discoveryEndpoint(String discoveryEndpoint) {
            this.discoveryEndpoint = discoveryEndpoint;
            return this;
        }

        @Generated
        public YdbConfigBuilder hostAndPort(HostAndPort hostAndPort) {
            this.hostAndPort = hostAndPort;
            return this;
        }

        @Generated
        public YdbConfigBuilder sessionCreationTimeout(Duration sessionCreationTimeout) {
            this.sessionCreationTimeout = sessionCreationTimeout;
            return this;
        }

        @Generated
        public YdbConfigBuilder sessionCreationMaxRetries(Integer sessionCreationMaxRetries) {
            this.sessionCreationMaxRetries = sessionCreationMaxRetries;
            return this;
        }

        @Generated
        public YdbConfigBuilder sessionKeepAliveTime(Duration sessionKeepAliveTime) {
            this.sessionKeepAliveTime = sessionKeepAliveTime;
            return this;
        }

        @Generated
        public YdbConfigBuilder sessionMaxIdleTime(Duration sessionMaxIdleTime) {
            this.sessionMaxIdleTime = sessionMaxIdleTime;
            return this;
        }

        @Generated
        public YdbConfigBuilder sessionPoolMin(Integer sessionPoolMin) {
            this.sessionPoolMin = sessionPoolMin;
            return this;
        }

        @Generated
        public YdbConfigBuilder sessionPoolMax(Integer sessionPoolMax) {
            this.sessionPoolMax = sessionPoolMax;
            return this;
        }

        @Generated
        public YdbConfigBuilder tcpKeepaliveTime(Duration tcpKeepaliveTime) {
            this.tcpKeepaliveTime = tcpKeepaliveTime;
            return this;
        }

        @Generated
        public YdbConfigBuilder tcpKeepaliveTimeout(Duration tcpKeepaliveTimeout) {
            this.tcpKeepaliveTimeout = tcpKeepaliveTimeout;
            return this;
        }

        @Generated
        public YdbConfigBuilder useTLS(boolean useTLS) {
            this.useTLS = useTLS;
            return this;
        }

        @Generated
        public YdbConfigBuilder useTrustStore(boolean useTrustStore) {
            this.useTrustStore = useTrustStore;
            return this;
        }

        @Generated
        public YdbConfigBuilder rootCA(byte[] rootCA) {
            this.rootCA = rootCA;
            return this;
        }

        @Generated
        public YdbConfigBuilder useSingleChannelTransport(Boolean useSingleChannelTransport) {
            this.useSingleChannelTransport = useSingleChannelTransport;
            return this;
        }

        @Generated
        public YdbConfig build() {
            return new YdbConfig(this.tablespace, this.database, this.discoveryEndpoint, this.hostAndPort, this.sessionCreationTimeout, this.sessionCreationMaxRetries, this.sessionKeepAliveTime, this.sessionMaxIdleTime, this.sessionPoolMin, this.sessionPoolMax, this.tcpKeepaliveTime, this.tcpKeepaliveTimeout, this.useTLS, this.useTrustStore, this.rootCA, this.useSingleChannelTransport);
        }

        @Generated
        public String toString() {
            return "YdbConfig.YdbConfigBuilder(tablespace=" + this.tablespace + ", database=" + this.database + ", discoveryEndpoint=" + this.discoveryEndpoint + ", hostAndPort=" + this.hostAndPort + ", sessionCreationTimeout=" + this.sessionCreationTimeout + ", sessionCreationMaxRetries=" + this.sessionCreationMaxRetries + ", sessionKeepAliveTime=" + this.sessionKeepAliveTime + ", sessionMaxIdleTime=" + this.sessionMaxIdleTime + ", sessionPoolMin=" + this.sessionPoolMin + ", sessionPoolMax=" + this.sessionPoolMax + ", tcpKeepaliveTime=" + this.tcpKeepaliveTime + ", tcpKeepaliveTimeout=" + this.tcpKeepaliveTimeout + ", useTLS=" + this.useTLS + ", useTrustStore=" + this.useTrustStore + ", rootCA=" + Arrays.toString(this.rootCA) + ", useSingleChannelTransport=" + this.useSingleChannelTransport + ")";
        }
    }
}

