/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.ydb.client;

import java.beans.ConstructorProperties;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import lombok.Generated;
import tech.ydb.table.settings.AutoPartitioningPolicy;
import tech.ydb.table.settings.PartitioningPolicy;
import tech.ydb.table.settings.PartitioningSettings;
import tech.ydb.table.values.OptionalValue;
import tech.ydb.table.values.PrimitiveValue;
import tech.ydb.table.values.TupleValue;
import tech.ydb.table.values.Value;

public final class YdbTableHint {
    private final PartitioningPolicy partitioningPolicy;
    private final PartitioningSettings partitioningSettings;
    private final TablePreset tablePreset;

    public static YdbTableHint int64Range(int start, int end) {
        return new YdbTableHint(new PartitioningPolicy().setAutoPartitioning(AutoPartitioningPolicy.DISABLED).setExplicitPartitioningPoints(LongStream.range(start, end).mapToObj(part -> TupleValue.of((Value)OptionalValue.of((Value)PrimitiveValue.newInt64((long)part)))).collect(Collectors.toList())), null, null);
    }

    public static YdbTableHint uniform(int partitions) {
        return new YdbTableHint(new PartitioningPolicy().setUniformPartitions((long)partitions), null, null);
    }

    public static YdbTableHint autoSplitByLoad(int exactPartitionsCount) {
        return YdbTableHint.autoSplitByLoad(exactPartitionsCount, exactPartitionsCount);
    }

    public static YdbTableHint autoSplitByLoad(int minPartitionsCount, int maxPartitionsCount) {
        return new YdbTableHint(new PartitioningPolicy().setAutoPartitioning(AutoPartitioningPolicy.AUTO_SPLIT_MERGE), new PartitioningSettings().setPartitioningByLoad(true).setMinPartitionsCount((long)minPartitionsCount).setMaxPartitionsCount((long)maxPartitionsCount), null);
    }

    public static YdbTableHint tablePreset(TablePreset tablePreset) {
        return new YdbTableHint(null, null, tablePreset);
    }

    @ConstructorProperties(value={"partitioningPolicy", "partitioningSettings", "tablePreset"})
    @Generated
    public YdbTableHint(PartitioningPolicy partitioningPolicy, PartitioningSettings partitioningSettings, TablePreset tablePreset) {
        this.partitioningPolicy = partitioningPolicy;
        this.partitioningSettings = partitioningSettings;
        this.tablePreset = tablePreset;
    }

    @Generated
    public PartitioningPolicy getPartitioningPolicy() {
        return this.partitioningPolicy;
    }

    @Generated
    public PartitioningSettings getPartitioningSettings() {
        return this.partitioningSettings;
    }

    @Generated
    public TablePreset getTablePreset() {
        return this.tablePreset;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof YdbTableHint)) {
            return false;
        }
        YdbTableHint other = (YdbTableHint)o;
        PartitioningPolicy this$partitioningPolicy = this.getPartitioningPolicy();
        PartitioningPolicy other$partitioningPolicy = other.getPartitioningPolicy();
        if (this$partitioningPolicy == null ? other$partitioningPolicy != null : !this$partitioningPolicy.equals(other$partitioningPolicy)) {
            return false;
        }
        PartitioningSettings this$partitioningSettings = this.getPartitioningSettings();
        PartitioningSettings other$partitioningSettings = other.getPartitioningSettings();
        if (this$partitioningSettings == null ? other$partitioningSettings != null : !this$partitioningSettings.equals(other$partitioningSettings)) {
            return false;
        }
        TablePreset this$tablePreset = this.getTablePreset();
        TablePreset other$tablePreset = other.getTablePreset();
        return !(this$tablePreset == null ? other$tablePreset != null : !((Object)((Object)this$tablePreset)).equals((Object)other$tablePreset));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PartitioningPolicy $partitioningPolicy = this.getPartitioningPolicy();
        result = result * 59 + ($partitioningPolicy == null ? 43 : $partitioningPolicy.hashCode());
        PartitioningSettings $partitioningSettings = this.getPartitioningSettings();
        result = result * 59 + ($partitioningSettings == null ? 43 : $partitioningSettings.hashCode());
        TablePreset $tablePreset = this.getTablePreset();
        result = result * 59 + ($tablePreset == null ? 43 : ((Object)((Object)$tablePreset)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "YdbTableHint(partitioningPolicy=" + this.getPartitioningPolicy() + ", partitioningSettings=" + this.getPartitioningSettings() + ", tablePreset=" + this.getTablePreset() + ")";
    }

    public static enum TablePreset {
        DEFAULT("default"),
        LOG_LZ4("log_lz4");

        private String tablePresetName;

        private TablePreset(String tablePresetName) {
            this.tablePresetName = tablePresetName;
        }

        public String getTablePresetName() {
            return this.tablePresetName;
        }
    }
}

