/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.ydb.bulk;

import com.google.protobuf.NullValue;
import java.util.HashMap;
import java.util.Map;
import tech.ydb.proto.ValueProtos;
import tech.ydb.yoj.databind.schema.Schema;
import tech.ydb.yoj.repository.db.Entity;
import tech.ydb.yoj.repository.db.EntitySchema;
import tech.ydb.yoj.repository.ydb.bulk.BulkMapper;
import tech.ydb.yoj.repository.ydb.yql.YqlPrimitiveType;
import tech.ydb.yoj.repository.ydb.yql.YqlType;

public final class BulkMapperImpl<E extends Entity<E>>
implements BulkMapper<E> {
    private final EntitySchema<E> srcSchema;

    public BulkMapperImpl(EntitySchema<E> srcSchema) {
        this.srcSchema = srcSchema;
    }

    @Override
    public String getTableName(String tableSpace) {
        return tableSpace + this.srcSchema.getName();
    }

    @Override
    public Map<String, ValueProtos.TypedValue> map(E entity) {
        Map idComponents = this.srcSchema.flatten(entity);
        HashMap<String, ValueProtos.TypedValue> result = new HashMap<String, ValueProtos.TypedValue>();
        for (Schema.JavaField idField : this.srcSchema.flattenFields()) {
            Object idFieldValue = idComponents.get(idField.getName());
            result.put(idField.getName(), this.toTypedValue(new Schema.JavaFieldValue(idField, idFieldValue), true));
        }
        return result;
    }

    protected ValueProtos.TypedValue toTypedValue(Schema.JavaFieldValue value, boolean optional) {
        YqlPrimitiveType type = YqlType.of(value.getField());
        return ValueProtos.TypedValue.newBuilder().setType(this.getYqlType(type, optional)).setValue(this.getYqlValue(type, value.getValue())).build();
    }

    protected ValueProtos.Type.Builder getYqlType(YqlType yqlType, boolean optional) {
        ValueProtos.Type.Builder ttype = yqlType.getYqlTypeBuilder();
        return !optional ? ttype : ValueProtos.Type.newBuilder().setOptionalType(ValueProtos.OptionalType.newBuilder().setItem(ttype));
    }

    protected ValueProtos.Value.Builder getYqlValue(YqlType type, Object value) {
        return value == null ? ValueProtos.Value.newBuilder().setNullFlagValue(NullValue.NULL_VALUE) : type.toYql(value);
    }
}

