/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.ydb.client;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import tech.ydb.common.transaction.TxMode;
import tech.ydb.core.Result;
import tech.ydb.core.Status;
import tech.ydb.core.grpc.GrpcReadStream;
import tech.ydb.table.Session;
import tech.ydb.table.description.TableDescription;
import tech.ydb.table.query.DataQuery;
import tech.ydb.table.query.DataQueryResult;
import tech.ydb.table.query.ExplainDataQueryResult;
import tech.ydb.table.query.Params;
import tech.ydb.table.query.ReadRowsResult;
import tech.ydb.table.query.ReadTablePart;
import tech.ydb.table.result.ResultSetReader;
import tech.ydb.table.settings.AlterTableSettings;
import tech.ydb.table.settings.BeginTxSettings;
import tech.ydb.table.settings.BulkUpsertSettings;
import tech.ydb.table.settings.CommitTxSettings;
import tech.ydb.table.settings.CopyTableSettings;
import tech.ydb.table.settings.CopyTablesSettings;
import tech.ydb.table.settings.CreateTableSettings;
import tech.ydb.table.settings.DescribeTableSettings;
import tech.ydb.table.settings.DropTableSettings;
import tech.ydb.table.settings.ExecuteDataQuerySettings;
import tech.ydb.table.settings.ExecuteScanQuerySettings;
import tech.ydb.table.settings.ExecuteSchemeQuerySettings;
import tech.ydb.table.settings.ExplainDataQuerySettings;
import tech.ydb.table.settings.KeepAliveSessionSettings;
import tech.ydb.table.settings.PrepareDataQuerySettings;
import tech.ydb.table.settings.ReadRowsSettings;
import tech.ydb.table.settings.ReadTableSettings;
import tech.ydb.table.settings.RenameTablesSettings;
import tech.ydb.table.settings.RollbackTxSettings;
import tech.ydb.table.transaction.TableTransaction;
import tech.ydb.table.transaction.Transaction;
import tech.ydb.table.transaction.TxControl;
import tech.ydb.table.values.ListValue;
import tech.ydb.yoj.repository.ydb.client.QueryInterceptor;

public final class QueryInterceptingSession
implements Session {
    private final Session delegate;
    private final QueryInterceptor interceptor;

    private QueryInterceptingSession(Session delegate, QueryInterceptor interceptor) {
        this.delegate = delegate;
        this.interceptor = interceptor;
    }

    public static Function<Session, Session> makeWrapper(QueryInterceptor interceptor) {
        return s -> new QueryInterceptingSession((Session)s, interceptor);
    }

    public String getId() {
        return this.delegate.getId();
    }

    public CompletableFuture<Status> createTable(String path, TableDescription tableDescriptions, CreateTableSettings settings) {
        return this.delegate.createTable(path, tableDescriptions, settings);
    }

    public CompletableFuture<Status> dropTable(String path, DropTableSettings settings) {
        return this.delegate.dropTable(path, settings);
    }

    public CompletableFuture<Status> alterTable(String path, AlterTableSettings settings) {
        return this.delegate.alterTable(path, settings);
    }

    public CompletableFuture<Status> copyTable(String src, String dst, CopyTableSettings settings) {
        return this.delegate.copyTable(src, dst, settings);
    }

    public CompletableFuture<Status> copyTables(CopyTablesSettings copyTablesSettings) {
        return this.delegate.copyTables(copyTablesSettings);
    }

    public CompletableFuture<Result<TableDescription>> describeTable(String path, DescribeTableSettings settings) {
        return this.delegate.describeTable(path, settings);
    }

    public CompletableFuture<Result<DataQueryResult>> executeDataQuery(String query, TxControl txControl, Params params, ExecuteDataQuerySettings settings) {
        this.interceptor.beforeExecute(QueryType.DATA_QUERY, this.delegate, query);
        return this.delegate.executeDataQuery(query, txControl, params, settings);
    }

    public CompletableFuture<Result<DataQuery>> prepareDataQuery(String query, PrepareDataQuerySettings settings) {
        return this.delegate.prepareDataQuery(query, settings);
    }

    public CompletableFuture<Status> executeSchemeQuery(String query, ExecuteSchemeQuerySettings settings) {
        return this.delegate.executeSchemeQuery(query, settings);
    }

    public CompletableFuture<Result<ExplainDataQueryResult>> explainDataQuery(String query, ExplainDataQuerySettings settings) {
        return this.delegate.explainDataQuery(query, settings);
    }

    public CompletableFuture<Result<Transaction>> beginTransaction(Transaction.Mode transactionMode, BeginTxSettings settings) {
        return this.delegate.beginTransaction(transactionMode, settings);
    }

    public CompletableFuture<Status> commitTransaction(String txId, CommitTxSettings settings) {
        return this.delegate.commitTransaction(txId, settings);
    }

    public CompletableFuture<Status> rollbackTransaction(String txId, RollbackTxSettings settings) {
        return this.delegate.rollbackTransaction(txId, settings);
    }

    public GrpcReadStream<ReadTablePart> executeReadTable(String s, ReadTableSettings readTableSettings) {
        return this.delegate.executeReadTable(s, readTableSettings);
    }

    public GrpcReadStream<ResultSetReader> executeScanQuery(String s, Params params, ExecuteScanQuerySettings executeScanQuerySettings) {
        return this.delegate.executeScanQuery(s, params, executeScanQuerySettings);
    }

    public CompletableFuture<Status> readTable(String tablePath, ReadTableSettings settings, Consumer<ResultSetReader> fn) {
        return this.delegate.readTable(tablePath, settings, fn);
    }

    public CompletableFuture<Status> executeScanQuery(String query, Params params, ExecuteScanQuerySettings settings, Consumer<ResultSetReader> fn) {
        this.interceptor.beforeExecute(QueryType.SCAN_QUERY, this.delegate, query);
        return this.delegate.executeScanQuery(query, params, settings, fn);
    }

    public CompletableFuture<Result<Session.State>> keepAlive(KeepAliveSessionSettings settings) {
        return this.delegate.keepAlive(settings);
    }

    public CompletableFuture<Status> executeBulkUpsert(String tablePath, ListValue rows, BulkUpsertSettings settings) {
        return this.delegate.executeBulkUpsert(tablePath, rows, settings);
    }

    public void close() {
        this.delegate.close();
    }

    public CompletableFuture<Status> renameTables(RenameTablesSettings renameTablesSettings) {
        return this.delegate.renameTables(renameTablesSettings);
    }

    public CompletableFuture<Result<ReadRowsResult>> readRows(String s, ReadRowsSettings readRowsSettings) {
        return this.delegate.readRows(s, readRowsSettings);
    }

    public TableTransaction createNewTransaction(TxMode txMode) {
        return this.delegate.createNewTransaction(txMode);
    }

    public CompletableFuture<Result<TableTransaction>> beginTransaction(TxMode txMode, BeginTxSettings beginTxSettings) {
        return this.delegate.beginTransaction(txMode, beginTxSettings);
    }

    public static enum QueryType {
        DATA_QUERY,
        SCAN_QUERY;

    }
}

