/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.ydb.client;

import com.google.common.base.Strings;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ydb.core.Result;
import tech.ydb.core.Status;
import tech.ydb.core.StatusCode;
import tech.ydb.core.grpc.GrpcTransport;
import tech.ydb.proto.ValueProtos;
import tech.ydb.proto.scheme.SchemeOperationProtos;
import tech.ydb.scheme.SchemeClient;
import tech.ydb.scheme.description.ListDirectoryResult;
import tech.ydb.table.Session;
import tech.ydb.table.description.TableDescription;
import tech.ydb.table.description.TableIndex;
import tech.ydb.table.description.TableTtl;
import tech.ydb.table.settings.AlterTableSettings;
import tech.ydb.table.settings.Changefeed;
import tech.ydb.table.settings.CreateTableSettings;
import tech.ydb.table.settings.PartitioningPolicy;
import tech.ydb.table.settings.PartitioningSettings;
import tech.ydb.table.settings.TtlSettings;
import tech.ydb.table.values.OptionalType;
import tech.ydb.table.values.Type;
import tech.ydb.yoj.databind.schema.Schema;
import tech.ydb.yoj.repository.db.exception.CreateTableException;
import tech.ydb.yoj.repository.db.exception.DropTableException;
import tech.ydb.yoj.repository.ydb.client.SessionManager;
import tech.ydb.yoj.repository.ydb.client.YdbConverter;
import tech.ydb.yoj.repository.ydb.client.YdbIssue;
import tech.ydb.yoj.repository.ydb.client.YdbPaths;
import tech.ydb.yoj.repository.ydb.client.YdbTableHint;
import tech.ydb.yoj.repository.ydb.exception.SnapshotCreateException;
import tech.ydb.yoj.repository.ydb.exception.YdbRepositoryException;
import tech.ydb.yoj.repository.ydb.exception.YdbSchemaPathNotFoundException;
import tech.ydb.yoj.repository.ydb.yql.YqlPrimitiveType;
import tech.ydb.yoj.repository.ydb.yql.YqlType;

public class YdbSchemaOperations {
    private static final Logger log = LoggerFactory.getLogger(YdbSchemaOperations.class);
    private final SessionManager sessionManager;
    private final SchemeClient schemeClient;
    private String tablespace;

    public YdbSchemaOperations(String tablespace, @NonNull SessionManager sessionManager, GrpcTransport transport) {
        if (sessionManager == null) {
            throw new NullPointerException("sessionManager is marked non-null but is null");
        }
        this.tablespace = YdbPaths.canonicalTablespace(tablespace);
        this.sessionManager = sessionManager;
        this.schemeClient = SchemeClient.newClient((GrpcTransport)transport).build();
    }

    public void setTablespace(String tablespace) {
        this.tablespace = YdbPaths.canonicalTablespace(tablespace);
    }

    public void createTablespace() {
        this.mkdirs(YdbPaths.canonicalRootDir(this.tablespace));
    }

    public boolean tablespaceExists() {
        return this.hasPath(YdbPaths.canonicalRootDir(this.tablespace));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTable(String name, List<Schema.JavaField> columns, List<Schema.JavaField> primaryKeys, YdbTableHint hint, List<Schema.Index> globalIndexes, Schema.TtlModifier ttlModifier, List<Schema.Changefeed> changefeeds) {
        TableDescription.Builder builder = TableDescription.newBuilder();
        columns.forEach(c -> {
            ValueProtos.Type.PrimitiveTypeId yqlType = YqlPrimitiveType.of(c).getYqlType();
            int yqlTypeNumber = yqlType.getNumber();
            ValueProtos.Type.PrimitiveTypeId primitiveTypeId = Stream.of(ValueProtos.Type.PrimitiveTypeId.values()).filter(id -> id.getNumber() == yqlTypeNumber).findFirst().orElseThrow(() -> new CreateTableException(String.format("Can't create table '%s'%nCan't find yql primitive type '%s' in YDB SDK", name, yqlType)));
            ValueProtos.Type typeProto = ValueProtos.Type.newBuilder().setTypeId(yqlType).build();
            builder.addNullableColumn(c.getName(), (Type)YdbConverter.convertProtoPrimitiveTypeToSDK(typeProto));
        });
        List primaryKeysNames = primaryKeys.stream().map(Schema.JavaField::getName).collect(Collectors.toList());
        builder.setPrimaryKeys(primaryKeysNames);
        globalIndexes.forEach(index -> {
            if (index.isUnique()) {
                builder.addGlobalUniqueIndex(index.getIndexName(), index.getFieldNames());
            } else {
                builder.addGlobalIndex(index.getIndexName(), index.getFieldNames());
            }
        });
        Session session = this.sessionManager.getSession();
        try {
            Status status;
            String tableDirectory = YdbPaths.tableDirectory(this.tablespace + name);
            if (!Strings.isNullOrEmpty((String)tableDirectory)) {
                this.mkdirs(tableDirectory);
            }
            CreateTableSettings tableSettings = new CreateTableSettings();
            if (hint != null) {
                PartitioningSettings partitioningSettings;
                YdbTableHint.TablePreset tablePreset;
                PartitioningPolicy partitioningPolicy = hint.getPartitioningPolicy();
                if (partitioningPolicy != null) {
                    tableSettings.setPartitioningPolicy(partitioningPolicy);
                }
                if ((tablePreset = hint.getTablePreset()) != null) {
                    tableSettings.setPresetName(tablePreset.getTablePresetName());
                }
                if ((partitioningSettings = hint.getPartitioningSettings()) != null) {
                    builder.setPartitioningSettings(partitioningSettings);
                }
            }
            if (ttlModifier != null) {
                TtlSettings ttlSettings = new TtlSettings(ttlModifier.getFieldName(), ttlModifier.getInterval());
                tableSettings.setTtlSettings(ttlSettings);
            }
            if ((status = (Status)session.createTable(this.tablespace + name, builder.build(), tableSettings).join()).getCode() != StatusCode.SUCCESS) {
                throw new CreateTableException(String.format("Can't create table %s: %s", name, status));
            }
            if (!changefeeds.isEmpty()) {
                for (Schema.Changefeed changefeed : changefeeds) {
                    AlterTableSettings alterTableSettings = new AlterTableSettings();
                    Changefeed newChangefeed = Changefeed.newBuilder((String)changefeed.getName()).withMode(Changefeed.Mode.valueOf((String)changefeed.getMode().name())).withFormat(Changefeed.Format.valueOf((String)changefeed.getFormat().name())).withVirtualTimestamps(changefeed.isVirtualTimestamps()).withRetentionPeriod(changefeed.getRetentionPeriod()).withInitialScan(changefeed.isInitialScan()).build();
                    alterTableSettings.addChangefeed(newChangefeed);
                    status = (Status)session.alterTable(this.tablespace + name, alterTableSettings).join();
                    if (status.getCode() == StatusCode.SUCCESS) continue;
                    throw new CreateTableException(String.format("Can't alter table %s: %s", name, status));
                }
            }
        }
        finally {
            this.sessionManager.release(session);
        }
    }

    public Table describeTable(String name, List<Schema.JavaField> columns, List<Schema.JavaField> primaryKeys, List<Schema.Index> indexes, Schema.TtlModifier ttlModifier) {
        Set primaryKeysNames = primaryKeys.stream().map(Schema.JavaField::getName).collect(Collectors.toSet());
        List<Column> ydbColumns = columns.stream().map(c -> {
            String columnName = c.getName();
            String simpleType = YqlType.of(c).getYqlType().name();
            boolean isPrimaryKey = primaryKeysNames.contains(columnName);
            return new Column(columnName, simpleType, isPrimaryKey);
        }).toList();
        List<Index> ydbIndexes = indexes.stream().map(i -> new Index(i.getIndexName(), i.getFieldNames(), i.isUnique())).toList();
        TtlModifier tableTtl = ttlModifier == null ? null : new TtlModifier(ttlModifier.getFieldName(), ttlModifier.getInterval());
        return new Table(this.tablespace + name, ydbColumns, ydbIndexes, tableTtl);
    }

    public boolean hasTable(String name) {
        return this.hasPath(this.tablespace + name);
    }

    public void dropTable(String name) {
        this.dropTablePath(this.tablespace + name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropTablePath(String table) {
        Session session = this.sessionManager.getSession();
        try {
            Status status = (Status)session.dropTable(table).join();
            if (!status.isSuccess()) {
                log.error("Table " + table + " not deleted");
                throw new DropTableException(String.format("Can't drop table %s: %s", table, status));
            }
        }
        finally {
            this.sessionManager.release(session);
        }
    }

    public List<String> getTableNames() {
        return this.getTableNames(false);
    }

    public List<String> getTableNames(boolean recursive) {
        return this.tableStream(recursive).map(DirectoryEntity::getName).collect(Collectors.toList());
    }

    public List<String> getDirectoryNames() {
        return this.listDirectory(this.tablespace).stream().filter(e -> e.getType() == SchemeOperationProtos.Entry.Type.DIRECTORY).map(DirectoryEntity::getName).collect(Collectors.toList());
    }

    public List<Table> getTables() {
        return this.getTables(false);
    }

    public List<Table> getTables(boolean recursive) {
        return this.getTables(this.tablespace, recursive);
    }

    public List<Table> getTables(String basePath) {
        return this.getTables(basePath, false);
    }

    public List<Table> getTables(String basePath, boolean recursive) {
        String canonicalBasePath = YdbPaths.canonicalTablespace(basePath);
        return this.tableStream(canonicalBasePath, recursive).map(e -> this.describeTableInternal(canonicalBasePath + e.getName())).collect(Collectors.toList());
    }

    private Stream<DirectoryEntity> tableStream(boolean recursive) {
        return this.tableStream(this.tablespace, recursive);
    }

    private Stream<DirectoryEntity> tableStream(String canonicalPath, boolean recursive) {
        return this.tables(canonicalPath, "", recursive).stream();
    }

    private List<DirectoryEntity> tables(String canonicalPath, String subDir, boolean recursive) {
        String tableDir = YdbPaths.join(canonicalPath, subDir);
        ArrayList<DirectoryEntity> result = new ArrayList<DirectoryEntity>();
        for (DirectoryEntity entity : this.listDirectory(tableDir)) {
            if (recursive && entity.getType() == SchemeOperationProtos.Entry.Type.DIRECTORY) {
                result.addAll(this.tables(canonicalPath, YdbPaths.join(subDir, entity.getName()), true));
                continue;
            }
            if (entity.getType() != SchemeOperationProtos.Entry.Type.TABLE) continue;
            result.add(entity.withName(YdbPaths.join(subDir, entity.getName())));
        }
        return result;
    }

    public Table describeTable(String tableName) {
        return this.describeTableInternal(this.tablespace + tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private Table describeTableInternal(String path) {
        Result result;
        Session session = this.sessionManager.getSession();
        try {
            result = (Result)session.describeTable(path).join();
        }
        finally {
            this.sessionManager.release(session);
        }
        if (StatusCode.SCHEME_ERROR == result.getStatus().getCode() && YdbIssue.DEFAULT_ERROR.isContainedIn(result.getStatus().getIssues())) {
            throw new YdbSchemaPathNotFoundException(result.toString());
        }
        if (!result.isSuccess()) {
            throw new YdbRepositoryException("Can't describe table '" + path + "': " + result);
        }
        TableDescription table = (TableDescription)result.getValue();
        return new Table(path, table.getColumns().stream().map(c -> {
            String columnName = c.getName();
            String simpleType = ((OptionalType)c.getType()).getItemType().toPb().getTypeId().name();
            boolean isPrimaryKey = table.getPrimaryKeys().contains(columnName);
            return new Column(columnName, simpleType, isPrimaryKey);
        }).toList(), table.getIndexes().stream().map(i -> new Index(i.getName(), i.getColumns(), i.getType() == TableIndex.Type.GLOBAL_UNIQUE)).toList(), table.getTableTtl() == null || table.getTableTtl().getTtlMode() == TableTtl.TtlMode.NOT_SET ? null : new TtlModifier(table.getTableTtl().getDateTimeColumn(), table.getTableTtl().getExpireAfterSeconds()));
    }

    public void removeTablespace() {
        this.removeTablespace(this.tablespace);
    }

    public void removeDirectoryRecursive(String directory) {
        this.removeTablespace(this.tablespace + directory + "/");
    }

    private void removeTablespace(String tablespace) {
        this.listDirectory(tablespace).forEach(e -> {
            switch (e.getType()) {
                case DIRECTORY: {
                    this.removeTablespace(tablespace + e.getName() + "/");
                    break;
                }
                case TABLE: {
                    try {
                        this.dropTablePath(tablespace + e.getName());
                        break;
                    }
                    catch (Exception ex) {
                        log.error("Can't remove table " + e.getName(), (Throwable)ex);
                    }
                }
            }
        });
        Status res = (Status)this.schemeClient.removeDirectory(tablespace.substring(0, tablespace.length() - 1)).join();
        log.trace(res.toString());
        if (!res.isSuccess()) {
            log.error("Can't remove directory " + tablespace);
        }
    }

    public void snapshot(String snapshotPath) throws SnapshotCreateException {
        this.mkdirs(YdbPaths.canonicalRootDir(snapshotPath));
        this.getTableNames().forEach(tableName -> this.copyTable(this.tablespace + tableName, snapshotPath + tableName));
        this.getDirectoryNames().stream().filter(name -> !name.startsWith(".")).filter(name -> !this.isSnapshotDirectory((String)name)).forEach(dirName -> {
            String curTablespace = this.tablespace;
            this.setTablespace(this.tablespace + dirName + "/");
            this.snapshot(snapshotPath + dirName + "/");
            this.setTablespace(curTablespace);
        });
    }

    public boolean isSnapshotDirectory(String name) {
        return name.startsWith(".snapshot-");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyTable(String source, String destination) {
        Session session = this.sessionManager.getSession();
        try {
            Status status = (Status)session.copyTable(source, destination).join();
            if (!status.isSuccess()) {
                throw new SnapshotCreateException(String.format("Error while copying from %s to %s: %s", source, destination, status));
            }
        }
        finally {
            this.sessionManager.release(session);
        }
    }

    private List<DirectoryEntity> listDirectory(String directory) {
        ListDirectoryResult result = (ListDirectoryResult)((Result)this.schemeClient.listDirectory(directory).join()).getValue();
        ArrayList errors = new ArrayList();
        List<DirectoryEntity> tables = result.getChildren().stream().filter(entry -> switch (entry.getType()) {
            case SchemeOperationProtos.Entry.Type.DIRECTORY, SchemeOperationProtos.Entry.Type.TABLE -> true;
            case SchemeOperationProtos.Entry.Type.COLUMN_STORE -> false;
            default -> {
                errors.add(String.format("Unexpected entry type (%s:%s) in directory %s", entry.getType(), entry.getName(), directory));
                yield false;
            }
        }).map(tEntry -> new DirectoryEntity(tEntry.getType(), tEntry.getName())).collect(Collectors.toList());
        if (!errors.isEmpty()) {
            throw new IllegalStateException(String.join((CharSequence)String.format("%n", new Object[0]), errors));
        }
        return tables;
    }

    protected void mkdirs(String dir) {
        Status status;
        if (!(dir.isEmpty() || this.hasPath(dir) || (status = (Status)this.schemeClient.makeDirectories(dir).join()).isSuccess())) {
            throw new IllegalStateException(String.format("Unable to create dir %s: %s", dir, status));
        }
    }

    protected boolean hasPath(String path) {
        return ((Result)this.schemeClient.describePath(path).join()).isSuccess();
    }

    @Generated
    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    @Generated
    public SchemeClient getSchemeClient() {
        return this.schemeClient;
    }

    @Generated
    public String getTablespace() {
        return this.tablespace;
    }

    public static final class TtlModifier {
        private final String dateTimeColumnName;
        private final Integer expireAfterSeconds;

        @Generated
        public String getDateTimeColumnName() {
            return this.dateTimeColumnName;
        }

        @Generated
        public Integer getExpireAfterSeconds() {
            return this.expireAfterSeconds;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TtlModifier)) {
                return false;
            }
            TtlModifier other = (TtlModifier)o;
            Integer this$expireAfterSeconds = this.getExpireAfterSeconds();
            Integer other$expireAfterSeconds = other.getExpireAfterSeconds();
            if (this$expireAfterSeconds == null ? other$expireAfterSeconds != null : !((Object)this$expireAfterSeconds).equals(other$expireAfterSeconds)) {
                return false;
            }
            String this$dateTimeColumnName = this.getDateTimeColumnName();
            String other$dateTimeColumnName = other.getDateTimeColumnName();
            return !(this$dateTimeColumnName == null ? other$dateTimeColumnName != null : !this$dateTimeColumnName.equals(other$dateTimeColumnName));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $expireAfterSeconds = this.getExpireAfterSeconds();
            result = result * 59 + ($expireAfterSeconds == null ? 43 : ((Object)$expireAfterSeconds).hashCode());
            String $dateTimeColumnName = this.getDateTimeColumnName();
            result = result * 59 + ($dateTimeColumnName == null ? 43 : $dateTimeColumnName.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "YdbSchemaOperations.TtlModifier(dateTimeColumnName=" + this.getDateTimeColumnName() + ", expireAfterSeconds=" + this.getExpireAfterSeconds() + ")";
        }

        @ConstructorProperties(value={"dateTimeColumnName", "expireAfterSeconds"})
        @Generated
        private TtlModifier(String dateTimeColumnName, Integer expireAfterSeconds) {
            this.dateTimeColumnName = dateTimeColumnName;
            this.expireAfterSeconds = expireAfterSeconds;
        }
    }

    public static final class Table {
        private final String name;
        private final List<Column> columns;
        private final List<Index> indexes;
        private final TtlModifier ttlModifier;

        @ConstructorProperties(value={"name", "columns", "indexes", "ttlModifier"})
        private Table(String name, List<Column> columns, List<Index> indexes, TtlModifier ttlModifier) {
            this.name = name;
            this.columns = columns;
            this.indexes = indexes;
            this.ttlModifier = ttlModifier;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public List<Column> getColumns() {
            return this.columns;
        }

        @Generated
        public List<Index> getIndexes() {
            return this.indexes;
        }

        @Generated
        public TtlModifier getTtlModifier() {
            return this.ttlModifier;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Table)) {
                return false;
            }
            Table other = (Table)o;
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            List<Column> this$columns = this.getColumns();
            List<Column> other$columns = other.getColumns();
            if (this$columns == null ? other$columns != null : !((Object)this$columns).equals(other$columns)) {
                return false;
            }
            List<Index> this$indexes = this.getIndexes();
            List<Index> other$indexes = other.getIndexes();
            if (this$indexes == null ? other$indexes != null : !((Object)this$indexes).equals(other$indexes)) {
                return false;
            }
            TtlModifier this$ttlModifier = this.getTtlModifier();
            TtlModifier other$ttlModifier = other.getTtlModifier();
            return !(this$ttlModifier == null ? other$ttlModifier != null : !((Object)this$ttlModifier).equals(other$ttlModifier));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            List<Column> $columns = this.getColumns();
            result = result * 59 + ($columns == null ? 43 : ((Object)$columns).hashCode());
            List<Index> $indexes = this.getIndexes();
            result = result * 59 + ($indexes == null ? 43 : ((Object)$indexes).hashCode());
            TtlModifier $ttlModifier = this.getTtlModifier();
            result = result * 59 + ($ttlModifier == null ? 43 : ((Object)$ttlModifier).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "YdbSchemaOperations.Table(name=" + this.getName() + ", columns=" + this.getColumns() + ", indexes=" + this.getIndexes() + ", ttlModifier=" + this.getTtlModifier() + ")";
        }
    }

    private static final class DirectoryEntity {
        private final SchemeOperationProtos.Entry.Type type;
        private final String name;

        @ConstructorProperties(value={"type", "name"})
        @Generated
        public DirectoryEntity(SchemeOperationProtos.Entry.Type type, String name) {
            this.type = type;
            this.name = name;
        }

        @Generated
        public SchemeOperationProtos.Entry.Type getType() {
            return this.type;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DirectoryEntity)) {
                return false;
            }
            DirectoryEntity other = (DirectoryEntity)o;
            SchemeOperationProtos.Entry.Type this$type = this.getType();
            SchemeOperationProtos.Entry.Type other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            SchemeOperationProtos.Entry.Type $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "YdbSchemaOperations.DirectoryEntity(type=" + this.getType() + ", name=" + this.getName() + ")";
        }

        @Generated
        public DirectoryEntity withName(String name) {
            return this.name == name ? this : new DirectoryEntity(this.type, name);
        }
    }

    public static final class Index {
        private final String name;
        private final List<String> columns;
        private final boolean unique;

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public List<String> getColumns() {
            return this.columns;
        }

        @Generated
        public boolean isUnique() {
            return this.unique;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Index)) {
                return false;
            }
            Index other = (Index)o;
            if (this.isUnique() != other.isUnique()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            List<String> this$columns = this.getColumns();
            List<String> other$columns = other.getColumns();
            return !(this$columns == null ? other$columns != null : !((Object)this$columns).equals(other$columns));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isUnique() ? 79 : 97);
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            List<String> $columns = this.getColumns();
            result = result * 59 + ($columns == null ? 43 : ((Object)$columns).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "YdbSchemaOperations.Index(name=" + this.getName() + ", columns=" + this.getColumns() + ", unique=" + this.isUnique() + ")";
        }

        @ConstructorProperties(value={"name", "columns", "unique"})
        @Generated
        private Index(String name, List<String> columns, boolean unique) {
            this.name = name;
            this.columns = columns;
            this.unique = unique;
        }
    }

    public static final class Column {
        private final String name;
        private final String type;
        private final boolean primary;

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public boolean isPrimary() {
            return this.primary;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Column)) {
                return false;
            }
            Column other = (Column)o;
            if (this.isPrimary() != other.isPrimary()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isPrimary() ? 79 : 97);
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "YdbSchemaOperations.Column(name=" + this.getName() + ", type=" + this.getType() + ", primary=" + this.isPrimary() + ")";
        }

        @ConstructorProperties(value={"name", "type", "primary"})
        @Generated
        private Column(String name, String type, boolean primary) {
            this.name = name;
            this.type = type;
            this.primary = primary;
        }
    }
}

