/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.ydb.merge;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tech.ydb.yoj.repository.db.cache.RepositoryCache;
import tech.ydb.yoj.repository.ydb.YdbRepository;
import tech.ydb.yoj.repository.ydb.merge.ByEntityYqlQueriesMerger;
import tech.ydb.yoj.repository.ydb.merge.YqlQueriesMerger;
import tech.ydb.yoj.repository.ydb.statement.YqlStatement;

public class QueriesMerger {
    private final Supplier<YqlQueriesMerger> factory;

    private QueriesMerger(Supplier<YqlQueriesMerger> factory) {
        this.factory = factory;
    }

    public List<YdbRepository.Query<?>> merge(YdbRepository.Query<?> first, YdbRepository.Query<?> ... others) {
        return this.merge(Stream.concat(Stream.of(first), Stream.of(others)).collect(Collectors.toList()));
    }

    public List<YdbRepository.Query<?>> merge(List<YdbRepository.Query<?>> pendingWrites) {
        ArrayList res = new ArrayList();
        YqlQueriesMerger currentMerger = this.factory.get();
        for (YdbRepository.Query<?> query : pendingWrites) {
            if (query.getStatement() instanceof YqlStatement) {
                currentMerger.onNext(query);
                continue;
            }
            res.addAll(currentMerger.getQueries());
            res.add(query);
            currentMerger = this.factory.get();
        }
        res.addAll(currentMerger.getQueries());
        return res;
    }

    public static QueriesMerger create(RepositoryCache cache) {
        return new QueriesMerger(() -> new ByEntityYqlQueriesMerger(cache));
    }
}

