/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.ydb.yql;

import com.google.common.base.Preconditions;
import com.google.protobuf.NullValue;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import tech.ydb.proto.ValueProtos;
import tech.ydb.yoj.databind.schema.Schema;
import tech.ydb.yoj.repository.db.exception.ConversionException;
import tech.ydb.yoj.repository.ydb.yql.YqlType;

public final class YqlCompositeType {
    public static final YqlVoid VOID = new YqlVoid();

    public static YqlList list(YqlType itemType) {
        return new YqlList(itemType);
    }

    public static YqlDict dictSet(YqlType keyType) {
        return new YqlDict(new Field(keyType, Function.identity()), new Field(VOID, ign -> null), value -> {
            if (!(value instanceof Iterable)) {
                throw new ConversionException("Converting to YQL set (Dict<X, Void>) parameter expected to be iterable, got: " + value.getClass());
            }
            return (Iterable)value;
        });
    }

    public static YqlTuple tuple(Schema.JavaField complexField) {
        return new YqlTuple(complexField.flatten().map(jf -> new Field(YqlType.of(jf), rootFieldValue -> {
            LinkedHashMap cfValues = new LinkedHashMap();
            complexField.collectValueTo(rootFieldValue, cfValues);
            return cfValues.get(jf.getName());
        })).collect(Collectors.toList()));
    }

    @Generated
    private YqlCompositeType() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static class YqlList
    implements YqlType {
        private final YqlType itemType;

        @Override
        public ValueProtos.Type.Builder getYqlTypeBuilder() {
            return ValueProtos.Type.newBuilder().setListType(ValueProtos.ListType.newBuilder().setItem(this.itemType.getYqlTypeBuilder()));
        }

        @Override
        public String getYqlTypeName() {
            return String.format("List<%s>", this.itemType.getYqlTypeName());
        }

        @Override
        public ValueProtos.Value.Builder toYql(Object value) {
            if (!(value instanceof Iterable)) {
                throw new ConversionException(String.format("Could not convert Java value of type \"%s\" to YDB value of type \"%s\": List expected", value.getClass(), this.getYqlTypeName()));
            }
            ValueProtos.Value.Builder builder = ValueProtos.Value.newBuilder();
            Iterable values = (Iterable)value;
            int i = 0;
            for (Object item : values) {
                try {
                    builder.addItems(this.itemType.toYql(item));
                }
                catch (Exception e) {
                    throw new ConversionException(String.format("Converting item %d of %s to YDB: %s", i, this.getYqlTypeName(), e.getMessage()), (Throwable)e);
                }
                ++i;
            }
            return builder;
        }

        @Override
        public Object fromYql(ValueProtos.Value value) {
            ArrayList<Object> result = new ArrayList<Object>(value.getItemsCount());
            for (int i = 0; i < value.getItemsCount(); ++i) {
                try {
                    result.add(this.itemType.fromYql(value.getItems(i)));
                    continue;
                }
                catch (Exception e) {
                    throw new ConversionException(String.format("Converting item %d of %s from YDB: %s", i, this.getYqlTypeName(), e.getMessage()), (Throwable)e);
                }
            }
            return result;
        }

        @ConstructorProperties(value={"itemType"})
        @Generated
        private YqlList(YqlType itemType) {
            this.itemType = itemType;
        }
    }

    public static class YqlDict
    implements YqlType {
        private final Field keyField;
        private final Field valueField;
        private final Function<Object, Iterable<Object>> entrySetGetter;

        @Override
        public ValueProtos.Type.Builder getYqlTypeBuilder() {
            return ValueProtos.Type.newBuilder().setDictType(ValueProtos.DictType.newBuilder().setKey(this.keyField.type.getYqlTypeBuilder()).setPayload(this.valueField.type.getYqlTypeBuilder()).build());
        }

        @Override
        public String getYqlTypeName() {
            return String.format("Dict<%s,%s>", this.keyField.type.getYqlTypeName(), this.valueField.type.getYqlTypeName());
        }

        @Override
        public ValueProtos.Value.Builder toYql(Object value) {
            ValueProtos.Value.Builder builder = ValueProtos.Value.newBuilder();
            Iterable<Object> entrySet = this.entrySetGetter.apply(value);
            for (Object entry : entrySet) {
                ValueProtos.Value.Builder yqlValue;
                ValueProtos.Value.Builder yqlKey;
                try {
                    yqlKey = this.keyField.type.toYql(this.keyField.getter.apply(entry));
                }
                catch (Exception e) {
                    throw new ConversionException(String.format("Converting key of %s to YDB: %s", this.getYqlTypeName(), e.getMessage()), (Throwable)e);
                }
                try {
                    yqlValue = this.valueField.type.toYql(this.valueField.getter.apply(entry));
                }
                catch (Exception e) {
                    throw new ConversionException(String.format("Converting value of %s to YDB: %s", this.getYqlTypeName(), e.getMessage()), (Throwable)e);
                }
                builder.addPairs(ValueProtos.ValuePair.newBuilder().setKey(yqlKey).setPayload(yqlValue).build());
            }
            return builder;
        }

        @Override
        public Object fromYql(ValueProtos.Value value) {
            throw new UnsupportedOperationException("Dict reading from YQL is not supported");
        }

        @ConstructorProperties(value={"keyField", "valueField", "entrySetGetter"})
        @Generated
        private YqlDict(Field keyField, Field valueField, Function<Object, Iterable<Object>> entrySetGetter) {
            this.keyField = keyField;
            this.valueField = valueField;
            this.entrySetGetter = entrySetGetter;
        }
    }

    private static final class Field {
        private final YqlType type;
        private final Function<Object, Object> getter;

        @ConstructorProperties(value={"type", "getter"})
        @Generated
        public Field(YqlType type, Function<Object, Object> getter) {
            this.type = type;
            this.getter = getter;
        }

        @Generated
        public YqlType getType() {
            return this.type;
        }

        @Generated
        public Function<Object, Object> getGetter() {
            return this.getter;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Field)) {
                return false;
            }
            Field other = (Field)o;
            YqlType this$type = this.getType();
            YqlType other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            Function<Object, Object> this$getter = this.getGetter();
            Function<Object, Object> other$getter = other.getGetter();
            return !(this$getter == null ? other$getter != null : !this$getter.equals(other$getter));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            YqlType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            Function<Object, Object> $getter = this.getGetter();
            result = result * 59 + ($getter == null ? 43 : $getter.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "YqlCompositeType.Field(type=" + this.getType() + ", getter=" + this.getGetter() + ")";
        }
    }

    public static class YqlVoid
    implements YqlType {
        @Override
        public ValueProtos.Type.Builder getYqlTypeBuilder() {
            return ValueProtos.Type.newBuilder().setVoidType(NullValue.NULL_VALUE);
        }

        @Override
        public String getYqlTypeName() {
            return "Void";
        }

        @Override
        public ValueProtos.Value.Builder toYql(Object value) {
            return ValueProtos.Value.newBuilder().setNullFlagValue(NullValue.NULL_VALUE);
        }

        @Override
        public Object fromYql(ValueProtos.Value value) {
            return null;
        }

        @Generated
        private YqlVoid() {
        }
    }

    public static class YqlTuple
    implements YqlType {
        private final List<Field> items;

        private YqlTuple(List<Field> items) {
            Preconditions.checkArgument((items.size() >= 2 ? 1 : 0) != 0, (Object)"Tuple must contain at least 2 components");
            this.items = items;
        }

        @Override
        public String getYqlTypeName() {
            return String.format("Tuple<%s>", this.items.stream().map(f -> f.type.getYqlTypeName()).collect(Collectors.joining(",")));
        }

        @Override
        public ValueProtos.Type.Builder getYqlTypeBuilder() {
            return ValueProtos.Type.newBuilder().setTupleType(ValueProtos.TupleType.newBuilder().addAllElements((Iterable)this.items.stream().map(f -> f.type.getYqlTypeBuilder().build()).collect(Collectors.toList())).build());
        }

        @Override
        public ValueProtos.Value.Builder toYql(Object value) {
            ValueProtos.Value.Builder builder = ValueProtos.Value.newBuilder();
            for (int i = 0; i < this.items.size(); ++i) {
                Field field = this.items.get(i);
                YqlType itemType = field.type;
                Object itemValue = field.getter.apply(value);
                try {
                    builder.addItems(itemType.toYql(itemValue));
                    continue;
                }
                catch (Exception e) {
                    throw new ConversionException(String.format("Converting item %d of %s to YDB: %s", i, this.getYqlTypeName(), e.getMessage()), (Throwable)e);
                }
            }
            return builder;
        }

        @Override
        public Object fromYql(ValueProtos.Value value) {
            throw new UnsupportedOperationException("Tuple reading from YQL not supported");
        }
    }
}

