/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.ydb;

import com.google.common.base.Strings;
import com.google.common.net.HostAndPort;
import io.grpc.ClientInterceptor;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ydb.auth.AuthProvider;
import tech.ydb.auth.AuthRpcProvider;
import tech.ydb.auth.NopAuthProvider;
import tech.ydb.core.grpc.GrpcTransport;
import tech.ydb.core.grpc.GrpcTransportBuilder;
import tech.ydb.core.impl.SingleChannelTransport;
import tech.ydb.yoj.repository.db.Entity;
import tech.ydb.yoj.repository.db.EntitySchema;
import tech.ydb.yoj.repository.db.Repository;
import tech.ydb.yoj.repository.db.RepositoryTransaction;
import tech.ydb.yoj.repository.db.SchemaOperations;
import tech.ydb.yoj.repository.db.TxOptions;
import tech.ydb.yoj.repository.ydb.LazyGrpcTransport;
import tech.ydb.yoj.repository.ydb.YdbConfig;
import tech.ydb.yoj.repository.ydb.YdbRepositoryTransaction;
import tech.ydb.yoj.repository.ydb.client.SessionManager;
import tech.ydb.yoj.repository.ydb.client.YdbPaths;
import tech.ydb.yoj.repository.ydb.client.YdbSchemaOperations;
import tech.ydb.yoj.repository.ydb.client.YdbSessionManager;
import tech.ydb.yoj.repository.ydb.client.YdbTableHint;
import tech.ydb.yoj.repository.ydb.compatibility.YdbDataCompatibilityChecker;
import tech.ydb.yoj.repository.ydb.compatibility.YdbSchemaCompatibilityChecker;
import tech.ydb.yoj.repository.ydb.statement.Statement;
import tech.ydb.yoj.util.function.MoreSuppliers;

public class YdbRepository
implements Repository {
    private static final Logger log = LoggerFactory.getLogger(YdbRepository.class);
    private final GrpcTransport transport;
    private final MoreSuppliers.CloseableMemoizer<SessionManager> sessionManager;
    private final Supplier<YdbSchemaOperations> schemaOperations;
    private final String tablespace;
    private final YdbConfig config;
    private final ConcurrentMap<String, Class<? extends Entity<?>>> entityClassesByTableName;

    public YdbRepository(@NonNull YdbConfig config) {
        this(config, (AuthProvider)NopAuthProvider.INSTANCE);
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
    }

    public YdbRepository(@NonNull YdbConfig config, @NonNull AuthProvider authProvider) {
        this(config, authProvider, List.of());
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (authProvider == null) {
            throw new NullPointerException("authProvider is marked non-null but is null");
        }
    }

    public YdbRepository(@NonNull YdbConfig config, @NonNull AuthProvider authProvider, List<ClientInterceptor> interceptors) {
        this(config, YdbRepository.makeGrpcTransport(config, authProvider, interceptors));
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (authProvider == null) {
            throw new NullPointerException("authProvider is marked non-null but is null");
        }
    }

    public YdbRepository(@NonNull YdbConfig config, @NonNull GrpcTransport transport) {
        MoreSuppliers.CloseableMemoizer sessionManager;
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (transport == null) {
            throw new NullPointerException("transport is marked non-null but is null");
        }
        this.config = config;
        this.tablespace = YdbPaths.canonicalTablespace(config.getTablespace());
        this.entityClassesByTableName = new ConcurrentHashMap();
        this.transport = transport;
        this.sessionManager = sessionManager = MoreSuppliers.memoizeCloseable(() -> new YdbSessionManager(config, transport));
        this.schemaOperations = MoreSuppliers.memoize(() -> this.buildSchemaOperations(config.getTablespace(), transport, (SessionManager)sessionManager.get()));
    }

    private static GrpcTransport makeGrpcTransport(@NonNull YdbConfig config, @NonNull AuthProvider authProvider, List<ClientInterceptor> interceptors) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (authProvider == null) {
            throw new NullPointerException("authProvider is marked non-null but is null");
        }
        boolean singleChannel = config.isUseSingleChannelTransport();
        return new LazyGrpcTransport(YdbRepository.makeGrpcTransportBuilder(config, authProvider, interceptors), singleChannel ? SingleChannelTransport::new : GrpcTransportBuilder::build);
    }

    private static GrpcTransportBuilder makeGrpcTransportBuilder(@NonNull YdbConfig config, AuthProvider authProvider, List<ClientInterceptor> interceptors) {
        GrpcTransportBuilder transportBuilder;
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (!Strings.isNullOrEmpty((String)config.getDiscoveryEndpoint())) {
            transportBuilder = GrpcTransport.forEndpoint((String)config.getDiscoveryEndpoint(), (String)YdbPaths.canonicalDatabase(config.getDatabase())).withChannelInitializer(channelBuilder -> {
                YdbRepository.initializeTcpKeepAlive(config, channelBuilder);
                YdbRepository.initializeYdbMaxInboundMessageSize(channelBuilder);
                YdbRepository.initializeChannelInterceptors(channelBuilder, interceptors);
            });
        } else if (config.getHostAndPort() != null) {
            transportBuilder = GrpcTransport.forHost((HostAndPort)config.getHostAndPort(), (String)config.getDatabase()).withChannelInitializer(channelBuilder -> {
                YdbRepository.initializeTcpKeepAlive(config, channelBuilder);
                YdbRepository.initializeYdbMaxInboundMessageSize(channelBuilder);
                YdbRepository.initializeChannelInterceptors(channelBuilder, interceptors);
            });
        } else {
            throw new IllegalArgumentException("one of [discoveryEndpoint, hostAndPort] must be set");
        }
        if (config.isUseTLS()) {
            if (config.isUseTrustStore()) {
                transportBuilder.withSecureConnection();
            } else if (config.getRootCA() != null) {
                transportBuilder.withSecureConnection(config.getRootCA());
            } else {
                throw new IllegalArgumentException("you must either set useTrustStore=true or specify rootCA content");
            }
        }
        return transportBuilder.withAuthProvider((AuthRpcProvider)authProvider);
    }

    private static void initializeChannelInterceptors(NettyChannelBuilder channelBuilder, List<ClientInterceptor> interceptors) {
        channelBuilder.intercept(interceptors);
    }

    private static void initializeTcpKeepAlive(YdbConfig config, NettyChannelBuilder channelBuilder) {
        channelBuilder.keepAliveTime(config.getTcpKeepaliveTime().toMillis(), TimeUnit.MILLISECONDS).keepAliveTimeout(config.getTcpKeepaliveTimeout().toMillis(), TimeUnit.MILLISECONDS).keepAliveWithoutCalls(true);
    }

    private static void initializeYdbMaxInboundMessageSize(NettyChannelBuilder channelBuilder) {
        channelBuilder.maxInboundMessageSize(0x4000000);
    }

    public SessionManager getSessionManager() {
        return (SessionManager)this.sessionManager.get();
    }

    public YdbSchemaOperations getSchemaOperations() {
        return this.schemaOperations.get();
    }

    @NonNull
    protected YdbSchemaOperations buildSchemaOperations(@NonNull String tablespace, GrpcTransport transport, SessionManager sessionManager) {
        if (tablespace == null) {
            throw new NullPointerException("tablespace is marked non-null but is null");
        }
        return new YdbSchemaOperations(tablespace, sessionManager, transport);
    }

    public final void checkDataCompatibility(List<Class<? extends Entity>> entities) {
        this.checkDataCompatibility(entities, YdbDataCompatibilityChecker.Config.DEFAULT);
    }

    public final void checkSchemaCompatibility(List<Class<? extends Entity>> entities) {
        this.checkSchemaCompatibility(entities, YdbSchemaCompatibilityChecker.Config.DEFAULT);
    }

    public final void checkSchemaCompatibility(List<Class<? extends Entity>> entities, YdbSchemaCompatibilityChecker.Config config) {
        new YdbSchemaCompatibilityChecker(entities, this, config).run();
    }

    public final void checkDataCompatibility(List<Class<? extends Entity>> entities, YdbDataCompatibilityChecker.Config config) {
        new YdbDataCompatibilityChecker(entities, this, config).run();
    }

    public boolean healthCheck() {
        return this.getSessionManager().healthCheck();
    }

    public void shutdown() {
        this.sessionManager.close();
        this.transport.close();
    }

    public void createTablespace() {
        this.getSchemaOperations().createTablespace();
    }

    public Set<Class<? extends Entity<?>>> tables() {
        return this.getSchemaOperations().getTableNames().stream().map(this.entityClassesByTableName::get).filter(Objects::nonNull).collect(Collectors.toUnmodifiableSet());
    }

    public RepositoryTransaction startTransaction(TxOptions options) {
        return new YdbRepositoryTransaction<YdbRepository>(this, options);
    }

    public String makeSnapshot() {
        YdbSchemaOperations schemaOperations = this.getSchemaOperations();
        String snapshotPath = schemaOperations.getTablespace() + ".snapshot-" + UUID.randomUUID() + "/";
        schemaOperations.snapshot(snapshotPath);
        return snapshotPath;
    }

    public void loadSnapshot(String id) {
        YdbSchemaOperations schemaOperations = this.getSchemaOperations();
        String current = schemaOperations.getTablespace();
        schemaOperations.getTableNames().forEach(schemaOperations::dropTable);
        schemaOperations.getDirectoryNames().stream().filter(name -> !schemaOperations.isSnapshotDirectory((String)name)).forEach(schemaOperations::removeDirectoryRecursive);
        schemaOperations.setTablespace(id);
        schemaOperations.snapshot(current);
        schemaOperations.setTablespace(current);
        this.getSessionManager().invalidateAllSessions();
    }

    public void dropDb() {
        try {
            this.getSchemaOperations().removeTablespace();
            this.entityClassesByTableName.clear();
        }
        catch (Exception e) {
            log.error("Could not drop all tables from tablespace", (Throwable)e);
        }
    }

    public <T extends Entity<T>> SchemaOperations<T> schema(final Class<T> c) {
        final EntitySchema schema = EntitySchema.of(c);
        return new SchemaOperations<T>(){

            public void create() {
                String tableName = schema.getName();
                YdbRepository.this.getSchemaOperations().createTable(tableName, schema.flattenFields(), schema.flattenId(), this.extractHint(), schema.getGlobalIndexes(), schema.getTtlModifier(), schema.getChangefeeds());
                if (!schema.isDynamic()) {
                    YdbRepository.this.entityClassesByTableName.put(tableName, c);
                }
            }

            private YdbTableHint extractHint() {
                try {
                    Field ydbTableHintField = c.getDeclaredField("ydbTableHint");
                    ydbTableHintField.setAccessible(true);
                    return (YdbTableHint)ydbTableHintField.get(null);
                }
                catch (IllegalAccessException | NoSuchFieldException ignored) {
                    return null;
                }
            }

            public void drop() {
                String tableName = schema.getName();
                YdbRepository.this.getSchemaOperations().dropTable(tableName);
                YdbRepository.this.entityClassesByTableName.remove(tableName);
            }

            public boolean exists() {
                String tableName = schema.getName();
                boolean exists = YdbRepository.this.getSchemaOperations().hasTable(tableName);
                if (!schema.isDynamic()) {
                    if (exists) {
                        YdbRepository.this.entityClassesByTableName.put(tableName, c);
                    } else {
                        YdbRepository.this.entityClassesByTableName.remove(tableName);
                    }
                }
                return exists;
            }
        };
    }

    @Generated
    public String getTablespace() {
        return this.tablespace;
    }

    @Generated
    public YdbConfig getConfig() {
        return this.config;
    }

    public static final class Query<PARAMS> {
        private final Statement<PARAMS, ?> statement;
        private final List<PARAMS> values = new ArrayList<PARAMS>();

        public Query(Statement<PARAMS, ?> statement, PARAMS value) {
            this.statement = statement;
            this.values.add(value);
        }

        public Query<PARAMS> merge(Query<?> ps) {
            this.values.addAll(ps.getValues());
            return this;
        }

        @Generated
        public Statement<PARAMS, ?> getStatement() {
            return this.statement;
        }

        @Generated
        public List<PARAMS> getValues() {
            return this.values;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Query)) {
                return false;
            }
            Query other = (Query)o;
            Statement<PARAMS, ?> this$statement = this.getStatement();
            Statement<PARAMS, ?> other$statement = other.getStatement();
            if (this$statement == null ? other$statement != null : !this$statement.equals(other$statement)) {
                return false;
            }
            List<PARAMS> this$values = this.getValues();
            List<PARAMS> other$values = other.getValues();
            return !(this$values == null ? other$values != null : !((Object)this$values).equals(other$values));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Statement<PARAMS, ?> $statement = this.getStatement();
            result = result * 59 + ($statement == null ? 43 : $statement.hashCode());
            List<PARAMS> $values = this.getValues();
            result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "YdbRepository.Query(statement=" + this.getStatement() + ", values=" + this.getValues() + ")";
        }
    }
}

