/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.ydb.client.interceptors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import tech.ydb.core.Result;
import tech.ydb.table.Session;
import tech.ydb.table.query.ExplainDataQueryResult;
import tech.ydb.yoj.repository.ydb.client.QueryInterceptingSession;
import tech.ydb.yoj.repository.ydb.client.QueryInterceptor;

public final class FullScanDetector
implements QueryInterceptor {
    private static final Map<String, Boolean> executedQueries = new ConcurrentHashMap<String, Boolean>();
    private final Set<String> ignoredQueries;
    private final Map<QueryInterceptingSession.QueryType, List<Consumer<String>>> callbacks;
    private static final ThreadLocal<Boolean> ignoreFullScan = ThreadLocal.withInitial(() -> false);

    private FullScanDetector(Set<String> ignoredQueries, Map<QueryInterceptingSession.QueryType, List<Consumer<String>>> callbacks) {
        this.ignoredQueries = ignoredQueries;
        this.callbacks = callbacks;
    }

    public static FullScanDetectorBuilder builder() {
        return new FullScanDetectorBuilder();
    }

    public static <T> T ignoringFullScan(Supplier<T> supplier) {
        ignoreFullScan.set(true);
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            ignoreFullScan.set(false);
        }
    }

    public static void ignoringFullScan(Runnable runnable) {
        FullScanDetector.ignoringFullScan(() -> {
            runnable.run();
            return null;
        });
    }

    @Override
    public void beforeExecute(QueryInterceptingSession.QueryType type, Session session, String query) {
        if (this.mustHandle(session, query)) {
            for (Consumer<String> callback : this.callbacks.get((Object)type)) {
                callback.accept(query);
            }
        }
    }

    private boolean mustHandle(Session session, String query) {
        if (ignoreFullScan.get().booleanValue()) {
            return false;
        }
        if (this.ignoredQueries.contains(query)) {
            return false;
        }
        if (executedQueries.containsKey(query)) {
            return false;
        }
        String plan = this.explain(session, query);
        executedQueries.put(query, true);
        return plan.contains("FullScan");
    }

    private String explain(Session session, String query) {
        return ((ExplainDataQueryResult)((Result)session.explainDataQuery(query).join()).getValue()).getQueryPlan();
    }

    public static class FullScanDetectorBuilder {
        private Set<String> ignoredQueries = Collections.emptySet();
        private final List<Consumer<String>> scanQueryFullScanCallbacks = new ArrayList<Consumer<String>>();
        private final List<Consumer<String>> dataQueryFullScanCallbacks = new ArrayList<Consumer<String>>();

        FullScanDetectorBuilder() {
        }

        public FullScanDetectorBuilder ignoredQueries(Collection<String> ignoredQueries) {
            this.ignoredQueries = Set.copyOf(ignoredQueries);
            return this;
        }

        public FullScanDetectorBuilder callback(QueryInterceptingSession.QueryType type, Consumer<String> callback) {
            switch (type) {
                case SCAN_QUERY: {
                    this.scanQueryFullScanCallbacks.add(callback);
                    break;
                }
                case DATA_QUERY: {
                    this.dataQueryFullScanCallbacks.add(callback);
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            return this;
        }

        public FullScanDetectorBuilder callback(Consumer<String> callback) {
            this.scanQueryFullScanCallbacks.add(callback);
            this.dataQueryFullScanCallbacks.add(callback);
            return this;
        }

        public FullScanDetector build() {
            return new FullScanDetector(this.ignoredQueries, Map.of(QueryInterceptingSession.QueryType.SCAN_QUERY, this.scanQueryFullScanCallbacks, QueryInterceptingSession.QueryType.DATA_QUERY, this.dataQueryFullScanCallbacks));
        }
    }
}

