/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.ydb.yql;

import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import tech.ydb.yoj.repository.ydb.statement.PredicateStatement;

public final class YqlPredicateParam<T> {
    private final String fieldPath;
    private final T value;
    private final boolean optional;
    private final PredicateStatement.ComplexField complexField;
    private final PredicateStatement.CollectionKind collectionKind;

    public static <T> YqlPredicateParam<T> of(String fieldPath, T value) {
        return YqlPredicateParam.of(fieldPath, value, false, PredicateStatement.ComplexField.FLATTEN, PredicateStatement.CollectionKind.SINGLE);
    }

    public static <T> YqlPredicateParam<T> optionalOf(String fieldPath, T value) {
        return YqlPredicateParam.of(fieldPath, value, true, PredicateStatement.ComplexField.FLATTEN, PredicateStatement.CollectionKind.SINGLE);
    }

    public static <V> YqlPredicateParam<Collection<V>> of(String fieldPath, Collection<V> coll) {
        return YqlPredicateParam.of(fieldPath, coll, false, PredicateStatement.ComplexField.FLATTEN, PredicateStatement.CollectionKind.DICT_SET);
    }

    @SafeVarargs
    public static <V> YqlPredicateParam<Collection<V>> of(String fieldPath, V first, V ... rest) {
        return YqlPredicateParam.of(fieldPath, Stream.concat(Stream.of(first), Arrays.stream(rest)).collect(Collectors.toList()));
    }

    public static <T> YqlPredicateParam<T> of(String fieldPath, T value, boolean optional, PredicateStatement.ComplexField structKind, PredicateStatement.CollectionKind collectionKind) {
        if (value instanceof Collection) {
            Preconditions.checkArgument((collectionKind != PredicateStatement.CollectionKind.SINGLE ? 1 : 0) != 0, (Object)"Collection parameter cannot be used with SINGLE collection kind");
            Preconditions.checkArgument((!optional ? 1 : 0) != 0, (Object)"Collection parameters cannot be optional");
            Preconditions.checkArgument((!((Collection)value).isEmpty() ? 1 : 0) != 0, (Object)"Collection value must not be empty");
            return new YqlPredicateParam<T>(fieldPath, value, false, structKind, collectionKind);
        }
        Preconditions.checkArgument((collectionKind == PredicateStatement.CollectionKind.SINGLE ? 1 : 0) != 0, (Object)("Non-collection parameters cannot be used with " + collectionKind + " collection kind"));
        return new YqlPredicateParam<T>(fieldPath, value, optional, structKind, collectionKind);
    }

    @Generated
    public String getFieldPath() {
        return this.fieldPath;
    }

    @Generated
    public T getValue() {
        return this.value;
    }

    @Generated
    public boolean isOptional() {
        return this.optional;
    }

    @Generated
    public PredicateStatement.ComplexField getComplexField() {
        return this.complexField;
    }

    @Generated
    public PredicateStatement.CollectionKind getCollectionKind() {
        return this.collectionKind;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof YqlPredicateParam)) {
            return false;
        }
        YqlPredicateParam other = (YqlPredicateParam)o;
        if (this.isOptional() != other.isOptional()) {
            return false;
        }
        String this$fieldPath = this.getFieldPath();
        String other$fieldPath = other.getFieldPath();
        if (this$fieldPath == null ? other$fieldPath != null : !this$fieldPath.equals(other$fieldPath)) {
            return false;
        }
        T this$value = this.getValue();
        T other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        PredicateStatement.ComplexField this$complexField = this.getComplexField();
        PredicateStatement.ComplexField other$complexField = other.getComplexField();
        if (this$complexField == null ? other$complexField != null : !((Object)((Object)this$complexField)).equals((Object)other$complexField)) {
            return false;
        }
        PredicateStatement.CollectionKind this$collectionKind = this.getCollectionKind();
        PredicateStatement.CollectionKind other$collectionKind = other.getCollectionKind();
        return !(this$collectionKind == null ? other$collectionKind != null : !((Object)((Object)this$collectionKind)).equals((Object)other$collectionKind));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isOptional() ? 79 : 97);
        String $fieldPath = this.getFieldPath();
        result = result * 59 + ($fieldPath == null ? 43 : $fieldPath.hashCode());
        T $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        PredicateStatement.ComplexField $complexField = this.getComplexField();
        result = result * 59 + ($complexField == null ? 43 : ((Object)((Object)$complexField)).hashCode());
        PredicateStatement.CollectionKind $collectionKind = this.getCollectionKind();
        result = result * 59 + ($collectionKind == null ? 43 : ((Object)((Object)$collectionKind)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "YqlPredicateParam(fieldPath=" + this.getFieldPath() + ", value=" + this.getValue() + ", optional=" + this.isOptional() + ", complexField=" + this.getComplexField() + ", collectionKind=" + this.getCollectionKind() + ")";
    }

    @ConstructorProperties(value={"fieldPath", "value", "optional", "complexField", "collectionKind"})
    @Generated
    private YqlPredicateParam(String fieldPath, T value, boolean optional, PredicateStatement.ComplexField complexField, PredicateStatement.CollectionKind collectionKind) {
        this.fieldPath = fieldPath;
        this.value = value;
        this.optional = optional;
        this.complexField = complexField;
        this.collectionKind = collectionKind;
    }
}

