/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.ydb.yql;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import tech.ydb.yoj.databind.schema.Schema;
import tech.ydb.yoj.repository.db.Entity;
import tech.ydb.yoj.repository.db.EntitySchema;
import tech.ydb.yoj.repository.ydb.yql.YqlStatementPart;

public class YqlView
implements YqlStatementPart<YqlView> {
    public static final String TYPE = "VIEW";
    public static final YqlView EMPTY = new YqlView("");
    private final String index;

    private YqlView(String index) {
        Preconditions.checkArgument((index != null ? 1 : 0) != 0, (Object)"index cannot be null");
        this.index = index;
    }

    public static YqlView index(String index) {
        return new YqlView(index);
    }

    public static YqlView empty() {
        return EMPTY;
    }

    public String index() {
        return this.index;
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public String getYqlPrefix() {
        return "";
    }

    @Override
    public <T extends Entity<T>> String toYql(@NonNull EntitySchema<T> schema) {
        if (schema == null) {
            throw new NullPointerException("schema is marked non-null but is null");
        }
        if (Strings.isNullOrEmpty((String)this.index)) {
            return "";
        }
        for (Schema.Index idx : schema.getGlobalIndexes()) {
            if (!idx.getIndexName().equals(this.index)) continue;
            return "VIEW `" + this.index + "`";
        }
        throw new IllegalStateException(String.format("Unable to find index [%s] in table [%s]", this.index, schema.getName()));
    }

    @Override
    public List<? extends YqlStatementPart<?>> combine(@NonNull List<? extends YqlView> other) {
        if (other == null) {
            throw new NullPointerException("other is marked non-null but is null");
        }
        throw new UnsupportedOperationException("Multiple VIEW specifications are not supported");
    }

    public String toString() {
        return "view [" + this.index + "]";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof YqlView)) {
            return false;
        }
        YqlView other = (YqlView)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$index = this.index;
        String other$index = other.index;
        return !(this$index == null ? other$index != null : !this$index.equals(other$index));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof YqlView;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $index = this.index;
        result = result * 59 + ($index == null ? 43 : $index.hashCode());
        return result;
    }

    @Generated
    public YqlView withIndex(String index) {
        return this.index == index ? this : new YqlView(index);
    }
}

