/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.db;

import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import tech.ydb.yoj.repository.db.Entity;
import tech.ydb.yoj.repository.db.EntityIdSchema;

public final class Range<ID extends Entity.Id<?>> {
    private final EntityIdSchema<ID> type;
    private final Map<String, Object> eqMap;
    private final Map<String, Object> minMap;
    private final Map<String, Object> maxMap;

    public static <ID extends Entity.Id<?>> Range<ID> create(@NonNull ID partial) {
        if (partial == null) {
            throw new NullPointerException("partial is marked non-null but is null");
        }
        return Range.create(partial, partial);
    }

    public static <ID extends Entity.Id<?>> Range<ID> create(@NonNull ID min, @NonNull ID max) {
        if (min == null) {
            throw new NullPointerException("min is marked non-null but is null");
        }
        if (max == null) {
            throw new NullPointerException("max is marked non-null but is null");
        }
        Preconditions.checkArgument((min.getClass() == max.getClass() ? 1 : 0) != 0, (Object)"Min and max must be instances of the same class");
        EntityIdSchema<?> type = EntityIdSchema.of(min.getClass());
        Map mn = type.flatten(min);
        Map mx = type.flatten(max);
        return Range.create(type, mn, mx);
    }

    public static <ID extends Entity.Id<?>> Range<ID> create(EntityIdSchema<ID> type, Map<String, Object> map) {
        return Range.create(type, map, map);
    }

    public static <ID extends Entity.Id<?>> Range<ID> create(EntityIdSchema<ID> type, Map<String, Object> mn, Map<String, Object> mx) {
        HashMap<String, Object> eqMap = new HashMap<String, Object>();
        HashMap<String, Object> minMap = new HashMap<String, Object>();
        HashMap<String, Object> maxMap = new HashMap<String, Object>();
        StringBuilder s = new StringBuilder();
        for (String fn : type.flattenFieldNames()) {
            Comparable a = (Comparable)mn.get(fn);
            Comparable b = (Comparable)mx.get(fn);
            if (a == null && b == null) {
                s.append("0");
                continue;
            }
            if (a == null) {
                maxMap.put(fn, b);
                s.append("<");
                continue;
            }
            if (b == null) {
                minMap.put(fn, a);
                s.append("<");
                continue;
            }
            if (a.compareTo(b) < 0) {
                minMap.put(fn, a);
                maxMap.put(fn, b);
                s.append("<");
                continue;
            }
            if (a.compareTo(b) == 0) {
                s.append("=");
                eqMap.put(fn, a);
                continue;
            }
            throw new IllegalArgumentException("min must be less or equal to max");
        }
        Preconditions.checkArgument((boolean)s.toString().matches("=*<?0*"), (Object)"Fields of min and max must be filled in specific order: (equal)*(different)?(null)*");
        return new Range<ID>(type, eqMap, minMap, maxMap);
    }

    public boolean contains(ID id) {
        Map flat = this.type.flatten(id);
        for (String fn : this.type.flattenFieldNames()) {
            Comparable c = (Comparable)flat.get(fn);
            if (c == null) {
                throw new IllegalArgumentException("Id fields cannot be null: " + id);
            }
            Object x = this.eqMap.get(fn);
            if (x != null && c.compareTo(x) != 0) {
                return false;
            }
            Object a = this.minMap.get(fn);
            if (a != null && c.compareTo(a) < 0) {
                return false;
            }
            Object b = this.maxMap.get(fn);
            if (b == null || c.compareTo(b) <= 0) continue;
            return false;
        }
        return true;
    }

    public List<Set<String>> getSchema() {
        return Stream.of(this.eqMap.keySet(), this.minMap.keySet(), this.maxMap.keySet()).collect(Collectors.toList());
    }

    public String toString() {
        ArrayList list = new ArrayList();
        this.eqMap.forEach((k, v) -> list.add(k + "=" + v));
        this.minMap.forEach((k, v) -> list.add(k + ">=" + v));
        this.maxMap.forEach((k, v) -> list.add(k + "<=" + v));
        return Range.class.getSimpleName() + "(" + this.type.getType().getName().replaceFirst(".*\\.", "") + ": " + String.join((CharSequence)", ", list) + ")";
    }

    @Deprecated
    public Range(@NonNull ID partial) {
        this(partial, partial);
        if (partial == null) {
            throw new NullPointerException("partial is marked non-null but is null");
        }
    }

    @Deprecated
    public Range(@NonNull ID min, @NonNull ID max) {
        if (min == null) {
            throw new NullPointerException("min is marked non-null but is null");
        }
        if (max == null) {
            throw new NullPointerException("max is marked non-null but is null");
        }
        Range<ID> range = Range.create(min, max);
        this.type = range.getType();
        this.eqMap = range.getEqMap();
        this.minMap = range.getMinMap();
        this.maxMap = range.getMaxMap();
    }

    @Generated
    public EntityIdSchema<ID> getType() {
        return this.type;
    }

    @Generated
    public Map<String, Object> getEqMap() {
        return this.eqMap;
    }

    @Generated
    public Map<String, Object> getMinMap() {
        return this.minMap;
    }

    @Generated
    public Map<String, Object> getMaxMap() {
        return this.maxMap;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Range)) {
            return false;
        }
        Range other = (Range)o;
        EntityIdSchema<ID> this$type = this.getType();
        EntityIdSchema<ID> other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Map<String, Object> this$eqMap = this.getEqMap();
        Map<String, Object> other$eqMap = other.getEqMap();
        if (this$eqMap == null ? other$eqMap != null : !((Object)this$eqMap).equals(other$eqMap)) {
            return false;
        }
        Map<String, Object> this$minMap = this.getMinMap();
        Map<String, Object> other$minMap = other.getMinMap();
        if (this$minMap == null ? other$minMap != null : !((Object)this$minMap).equals(other$minMap)) {
            return false;
        }
        Map<String, Object> this$maxMap = this.getMaxMap();
        Map<String, Object> other$maxMap = other.getMaxMap();
        return !(this$maxMap == null ? other$maxMap != null : !((Object)this$maxMap).equals(other$maxMap));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EntityIdSchema<ID> $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Map<String, Object> $eqMap = this.getEqMap();
        result = result * 59 + ($eqMap == null ? 43 : ((Object)$eqMap).hashCode());
        Map<String, Object> $minMap = this.getMinMap();
        result = result * 59 + ($minMap == null ? 43 : ((Object)$minMap).hashCode());
        Map<String, Object> $maxMap = this.getMaxMap();
        result = result * 59 + ($maxMap == null ? 43 : ((Object)$maxMap).hashCode());
        return result;
    }

    @ConstructorProperties(value={"type", "eqMap", "minMap", "maxMap"})
    @Generated
    private Range(EntityIdSchema<ID> type, Map<String, Object> eqMap, Map<String, Object> minMap, Map<String, Object> maxMap) {
        this.type = type;
        this.eqMap = eqMap;
        this.minMap = minMap;
        this.maxMap = maxMap;
    }
}

