/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.db;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import lombok.NonNull;
import tech.ydb.yoj.databind.expression.FilterExpression;
import tech.ydb.yoj.databind.expression.OrderExpression;
import tech.ydb.yoj.repository.db.Entity;
import tech.ydb.yoj.repository.db.EntityExpressions;
import tech.ydb.yoj.repository.db.EntityIdSchema;
import tech.ydb.yoj.repository.db.Range;
import tech.ydb.yoj.repository.db.TableQueryBuilder;
import tech.ydb.yoj.repository.db.bulk.BulkParams;
import tech.ydb.yoj.repository.db.cache.FirstLevelCache;
import tech.ydb.yoj.repository.db.list.ListRequest;
import tech.ydb.yoj.repository.db.list.ListResult;
import tech.ydb.yoj.repository.db.list.ViewListResult;
import tech.ydb.yoj.repository.db.readtable.ReadTableParams;
import tech.ydb.yoj.repository.db.statement.Changeset;

public interface Table<T extends Entity<T>> {
    public <ID extends Entity.Id<T>> Stream<T> readTable(ReadTableParams<ID> var1);

    public <ID extends Entity.Id<T>> Stream<ID> readTableIds(ReadTableParams<ID> var1);

    public <V extends ViewId<T>, ID extends Entity.Id<T>> Stream<V> readTable(Class<V> var1, ReadTableParams<ID> var2);

    public Class<T> getType();

    @CheckForNull
    public T find(Entity.Id<T> var1);

    public <V extends View> V find(Class<V> var1, Entity.Id<T> var2);

    public <ID extends Entity.Id<T>> List<T> find(Range<ID> var1);

    public <ID extends Entity.Id<T>> List<ID> findIds(Range<ID> var1);

    public <ID extends Entity.Id<T>> List<ID> findIds(Set<ID> var1);

    public <V extends View, ID extends Entity.Id<T>> List<V> find(Class<V> var1, Range<ID> var2);

    public <V extends View, ID extends Entity.Id<T>> List<V> find(Class<V> var1, Set<ID> var2);

    public List<T> findAll();

    public <V extends View> List<V> findAll(Class<V> var1);

    public List<T> find(@Nullable String var1, @Nullable FilterExpression<T> var2, @Nullable OrderExpression<T> var3, @Nullable Integer var4, @Nullable Long var5);

    public <ID extends Entity.Id<T>> List<ID> findIds(@Nullable String var1, @Nullable FilterExpression<T> var2, @Nullable OrderExpression<T> var3, @Nullable Integer var4, @Nullable Long var5);

    public <V extends View> List<V> find(Class<V> var1, @Nullable String var2, @Nullable FilterExpression<T> var3, @Nullable OrderExpression<T> var4, @Nullable Integer var5, @Nullable Long var6, boolean var7);

    public <ID extends Entity.Id<T>> List<T> find(Set<ID> var1, @Nullable FilterExpression<T> var2, @Nullable OrderExpression<T> var3, @Nullable Integer var4);

    public <ID extends Entity.Id<T>> List<T> findUncached(Set<ID> var1, @Nullable FilterExpression<T> var2, @Nullable OrderExpression<T> var3, @Nullable Integer var4);

    public <V extends View, ID extends Entity.Id<T>> List<V> find(Class<V> var1, Set<ID> var2, @Nullable FilterExpression<T> var3, @Nullable OrderExpression<T> var4, @Nullable Integer var5);

    public <K> List<T> find(String var1, Set<K> var2, @Nullable FilterExpression<T> var3, @Nullable OrderExpression<T> var4, @Nullable Integer var5);

    public <V extends View, K> List<V> find(Class<V> var1, String var2, Set<K> var3, @Nullable FilterExpression<T> var4, @Nullable OrderExpression<T> var5, @Nullable Integer var6);

    public Stream<T> streamAll(int var1);

    public <V extends ViewId<T>> Stream<V> streamAll(Class<V> var1, int var2);

    public <ID extends Entity.Id<T>> Stream<T> streamPartial(ID var1, int var2);

    public <ID extends Entity.Id<T>, V extends ViewId<T>> Stream<V> streamPartial(Class<V> var1, ID var2, int var3);

    public <ID extends Entity.Id<T>> Stream<ID> streamAllIds(int var1);

    public <ID extends Entity.Id<T>> Stream<ID> streamPartialIds(ID var1, int var2);

    public long count(String var1, FilterExpression<T> var2);

    public long countAll();

    public T insert(T var1);

    public T save(T var1);

    public void delete(Entity.Id<T> var1);

    public void deleteAll();

    default public Stream<T> readTable() {
        return this.readTable(ReadTableParams.getDefault());
    }

    default public <ID extends Entity.Id<T>> Stream<ID> readTableIds() {
        return this.readTableIds(ReadTableParams.getDefault());
    }

    default public FirstLevelCache getFirstLevelCache() {
        return null;
    }

    @NonNull
    default public <X extends Exception> T find(Entity.Id<T> id, Supplier<? extends X> throwIfAbsent) throws X {
        T found = this.find(id);
        if (found != null) {
            return found;
        }
        throw (Exception)throwIfAbsent.get();
    }

    default public T findOrDefault(Entity.Id<T> id, Supplier<T> defaultSupplier) {
        T found = this.find(id);
        return (T)(found != null ? found : (Entity)defaultSupplier.get());
    }

    default public <V extends View, X extends Exception> V find(Class<V> viewType, Entity.Id<T> id, Supplier<? extends X> throwIfAbsent) throws X {
        V found = this.find(viewType, id);
        if (found != null) {
            return found;
        }
        throw (Exception)throwIfAbsent.get();
    }

    default public T modifyIfPresent(Entity.Id<T> id, Function<T, T> modify) {
        return (T)((Entity)Optional.ofNullable(this.find(id)).map(modify).map(this::save).orElse(null));
    }

    default public T generateAndSaveNew(@NonNull Supplier<T> generator) {
        if (generator == null) {
            throw new NullPointerException("generator is marked non-null but is null");
        }
        for (int i = 0; i < 7; ++i) {
            Entity t = (Entity)generator.get();
            if (this.find(t.getId()) != null) continue;
            return (T)this.save(t);
        }
        throw new IllegalStateException("Cannot generate unique entity id");
    }

    default public <X extends Throwable> T saveNewOrThrow(@NonNull T t, @NonNull Supplier<? extends X> alreadyExists) throws X {
        if (t == null) {
            throw new NullPointerException("t is marked non-null but is null");
        }
        if (alreadyExists == null) {
            throw new NullPointerException("alreadyExists is marked non-null but is null");
        }
        if (this.find(t.getId()) != null) {
            throw (Throwable)alreadyExists.get();
        }
        return this.save(t);
    }

    default public <X extends Throwable> T updateExistingOrThrow(@NonNull T t, @NonNull Supplier<? extends X> notFound) throws X {
        if (t == null) {
            throw new NullPointerException("t is marked non-null but is null");
        }
        if (notFound == null) {
            throw new NullPointerException("notFound is marked non-null but is null");
        }
        if (this.find(t.getId()) == null) {
            throw (Throwable)notFound.get();
        }
        return this.save(t);
    }

    default public T saveOrUpdate(@NonNull T t) {
        if (t == null) {
            throw new NullPointerException("t is marked non-null but is null");
        }
        this.find(t.getId());
        return this.save(t);
    }

    default public T deleteIfExists(@NonNull Entity.Id<T> id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        T t = this.find(id);
        if (t != null) {
            this.delete(id);
        }
        return t;
    }

    default public <ID extends Entity.Id<T>> void deleteAll(Set<ID> ids) {
        this.find(ids);
        ids.forEach(this::delete);
    }

    default public <ID extends Entity.Id<T>> void deleteAll(Range<ID> range) {
        this.find(range).forEach(e -> this.delete(e.getId()));
    }

    default public void insert(T first, T ... rest) {
        this.insertAll(Stream.concat(Stream.of(first), Stream.of(rest)).collect(Collectors.toList()));
    }

    default public void insertAll(Collection<? extends T> entities) {
        entities.forEach(this::insert);
    }

    default public <ID extends Entity.Id<T>> void delete(Set<ID> ids) {
        ids.forEach(this::delete);
    }

    default public <ID extends Entity.Id<T>> void delete(Range<ID> range) {
        this.findIds(range).forEach(this::delete);
    }

    default public ListResult<T> list(ListRequest<T> request) {
        List<T> nextPage = this.toQueryBuilder(request).find();
        return ListResult.forPage(request, this.postLoad((T)nextPage));
    }

    default public <V extends View> ViewListResult<T, V> list(Class<V> viewType, ListRequest<T> request) {
        List<V> nextPage = this.toQueryBuilder(request).find(viewType);
        return ViewListResult.forPage(request, viewType, nextPage);
    }

    default public <ID extends Entity.Id<T>> List<T> find(Set<ID> ids) {
        Entity.Id id;
        if (ids.isEmpty()) {
            return List.of();
        }
        OrderExpression<T> orderBy = EntityExpressions.defaultOrder(this.getType());
        FirstLevelCache cache = this.getFirstLevelCache();
        boolean isPartialIdMode = ((Entity.Id)ids.iterator().next()).isPartial();
        Map foundInCache = ids.stream().filter(cache::containsKey).map(cache::peek).flatMap(Optional::stream).collect(Collectors.toMap(Entity::getId, Function.identity()));
        Sets.SetView remainingIds = Sets.difference(ids, foundInCache.keySet());
        List<T> foundInDb = this.findUncached((Set<ID>)remainingIds, null, orderBy, null);
        HashMap<Entity.Id, Entity> merged = new HashMap<Entity.Id, Entity>();
        for (Entity entity : foundInDb) {
            id = entity.getId();
            if (cache.containsKey(id)) {
                Optional cached = cache.peek(id);
                cached.ifPresent(t -> merged.put(id, (Entity)t));
                continue;
            }
            merged.put(id, this.postLoad(entity));
        }
        for (Map.Entry entry : foundInCache.entrySet()) {
            id = (Entity.Id)entry.getKey();
            Entity entry2 = (Entity)entry.getValue();
            merged.put(id, entry2);
        }
        if (!isPartialIdMode) {
            Set foundInDbIds = foundInDb.stream().map(Entity::getId).collect(Collectors.toSet());
            HashSet<Entity.Id> hashSet = new HashSet<Entity.Id>(foundInCache.keySet());
            Sets.difference((Set)Sets.difference(ids, foundInDbIds), hashSet).forEach(cache::putEmpty);
        }
        return merged.values().stream().sorted(EntityIdSchema.SORT_ENTITY_BY_ID).collect(Collectors.toList());
    }

    default public void bulkUpsert(List<T> input, BulkParams params) {
        throw new UnsupportedOperationException();
    }

    default public TableQueryBuilder<T> toQueryBuilder(ListRequest<T> request) {
        return this.query().index(request.getIndex()).filter(request.getFilter()).orderBy(request.getOrderBy()).offset(request.getOffset()).limit(request.getPageSize() + 1);
    }

    default public List<T> postLoad(List<T> list) {
        return list.stream().map(this::postLoad).collect(Collectors.toList());
    }

    default public T postLoad(T e) {
        return (T)e.postLoad();
    }

    default public long count(FilterExpression<T> filter) {
        return this.count(null, filter);
    }

    default public TableQueryBuilder<T> query() {
        return new TableQueryBuilder(this);
    }

    @Deprecated
    public void update(Entity.Id<T> var1, Changeset var2);

    public static interface View {
    }

    public static interface RecordViewId<E extends Entity<E>>
    extends ViewId<E> {
        public Entity.Id<E> id();

        @Override
        default public Entity.Id<E> getId() {
            return this.id();
        }
    }

    public static interface ViewId<E extends Entity<E>>
    extends View {
        public Entity.Id<E> getId();
    }
}

