/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.db;

import com.google.common.base.Stopwatch;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ydb.yoj.repository.db.RepositoryTransaction;
import tech.ydb.yoj.repository.db.Tx;
import tech.ydb.yoj.repository.db.TxOptions;
import tech.ydb.yoj.repository.db.exception.OptimisticLockException;
import tech.ydb.yoj.util.lang.Interrupts;

final class TxImpl
implements Tx {
    private static final Logger log = LoggerFactory.getLogger(TxImpl.class);
    private final String name;
    private final RepositoryTransaction repositoryTransaction;
    private final List<Runnable> deferredAfterCommit = new ArrayList<Runnable>();
    private final List<Runnable> deferredFinally = new ArrayList<Runnable>();
    private final List<Runnable> deferredBeforeCommit = new ArrayList<Runnable>();
    private final boolean dryRun;
    private final boolean logStatementOnSuccess;

    public TxImpl(String name, RepositoryTransaction repositoryTransaction, TxOptions options) {
        this.name = name;
        this.repositoryTransaction = repositoryTransaction;
        this.dryRun = options.isDryRun();
        this.logStatementOnSuccess = options.isLogStatementOnSuccess();
    }

    <R> R run(Supplier<R> supplier) {
        Object value;
        try {
            value = Tx.Current.runInTx(this, () -> this.runImpl(supplier));
        }
        catch (Exception e) {
            if (Interrupts.isInterruptException((Throwable)e)) {
                Thread.currentThread().interrupt();
            }
            throw e;
        }
        if (!this.dryRun) {
            this.deferredAfterCommit.forEach(Runnable::run);
        }
        return (R)value;
    }

    @Override
    public void defer(Runnable runnable) {
        this.deferredAfterCommit.add(runnable);
    }

    @Override
    public void deferFinally(Runnable runnable) {
        this.deferredFinally.add(runnable);
    }

    void runDeferredFinally() {
        this.deferredFinally.forEach(Runnable::run);
    }

    @Override
    public void deferBeforeCommit(Runnable runnable) {
        this.deferredBeforeCommit.add(runnable);
    }

    private <R> R runImpl(Supplier<R> supplier) {
        R res;
        Stopwatch sw = Stopwatch.createStarted();
        try {
            res = supplier.get();
            this.deferredBeforeCommit.forEach(Runnable::run);
        }
        catch (Throwable t) {
            this.doRollback(this.isBusinessException(t), String.format("[%s] runInTx(): Rollback as inconsistent with business exception %s%s", sw, t, this.formatExecutionLogMultiline("! ")));
            log.debug("[{}] runInTx(): Rollback due to {}{}", new Object[]{sw, t, this.formatExecutionLogMultiline("! "), t});
            throw t;
        }
        if (this.dryRun) {
            this.doRollback(true, String.format("[%s]runInTx(): Rollback because dry-run transaction read inconsistent data", sw));
            log.debug("[{}] runInTx(): Rollback due to dry-run mode {}", (Object)sw, (Object)this.formatExecutionLogMultiline("# "));
            return res;
        }
        try {
            this.repositoryTransaction.commit();
        }
        catch (Throwable t) {
            log.debug("[{}] runInTx(): Commit failed due to {}{}", new Object[]{sw, t, this.formatExecutionLogMultiline("?! "), t});
            throw t;
        }
        if (this.logStatementOnSuccess) {
            log.debug("[{}] runInTx(): Commit {}", (Object)sw, (Object)this.formatExecutionLogMultiline(""));
        }
        return res;
    }

    private void doRollback(boolean isBusinessException, String businessExceptionLogMessage) {
        block2: {
            try {
                this.repositoryTransaction.rollback();
            }
            catch (OptimisticLockException optimisticRollbackException) {
                if (!isBusinessException) break block2;
                log.debug(businessExceptionLogMessage);
                throw optimisticRollbackException;
            }
        }
    }

    private boolean isBusinessException(Throwable th) {
        return !Interrupts.isInterruptException((Throwable)th);
    }

    private String formatExecutionLogMultiline(String prefix) {
        return this.repositoryTransaction.getTransactionLocal().log().format(prefix);
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Override
    @Generated
    public RepositoryTransaction getRepositoryTransaction() {
        return this.repositoryTransaction;
    }
}

