/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.db.cache;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.NonNull;
import tech.ydb.yoj.repository.db.Entity;

public interface FirstLevelCache {
    public <E extends Entity<E>> E get(@NonNull Entity.Id<E> var1, @NonNull Function<Entity.Id<E>, E> var2);

    public <E extends Entity<E>> Optional<E> peek(@NonNull Entity.Id<E> var1);

    public <E extends Entity<E>> List<E> snapshot(@NonNull Class<E> var1);

    public <E extends Entity<E>> Map<Entity.Id<E>, E> entities(@NonNull Class<E> var1);

    public <E extends Entity<E>> void put(@NonNull E var1);

    public <E extends Entity<E>> void putEmpty(@NonNull Entity.Id<E> var1);

    public <E extends Entity<E>> boolean containsKey(@NonNull Entity.Id<E> var1);

    public static FirstLevelCache empty() {
        return new FirstLevelCache(){

            @Override
            public <E extends Entity<E>> E get(@NonNull Entity.Id<E> id, Function<Entity.Id<E>, E> loader) {
                if (id == null) {
                    throw new NullPointerException("id is marked non-null but is null");
                }
                return (E)((Entity)loader.apply(id));
            }

            @Override
            public <E extends Entity<E>> Optional<E> peek(@NonNull Entity.Id<E> id) {
                if (id == null) {
                    throw new NullPointerException("id is marked non-null but is null");
                }
                throw new NoSuchElementException();
            }

            @Override
            public <E extends Entity<E>> List<E> snapshot(@NonNull Class<E> entityType) {
                if (entityType == null) {
                    throw new NullPointerException("entityType is marked non-null but is null");
                }
                return List.of();
            }

            @Override
            public <E extends Entity<E>> Map<Entity.Id<E>, E> entities(@NonNull Class<E> entityType) {
                if (entityType == null) {
                    throw new NullPointerException("entityType is marked non-null but is null");
                }
                return Map.of();
            }

            @Override
            public <E extends Entity<E>> void put(@NonNull E e) {
                if (e == null) {
                    throw new NullPointerException("e is marked non-null but is null");
                }
            }

            @Override
            public <E extends Entity<E>> void putEmpty(@NonNull Entity.Id<E> id) {
                if (id == null) {
                    throw new NullPointerException("id is marked non-null but is null");
                }
            }

            @Override
            public <E extends Entity<E>> boolean containsKey(@NonNull Entity.Id<E> id) {
                return false;
            }
        };
    }

    public static FirstLevelCache create() {
        return new FirstLevelCache(){
            private final 1EntityCache<?> entityCache;
            {
                class 1EntityCache<E extends Entity<E>>
                extends HashMap<Entity.Id<E>, Optional<E>> {
                    1EntityCache() {
                    }
                }
                this.entityCache = new 1EntityCache();
            }

            private <E extends Entity<E>> 1EntityCache<E> getEntityCache() {
                return this.entityCache;
            }

            @Override
            public <E extends Entity<E>> Optional<E> peek(@NonNull Entity.Id<E> id) {
                if (id == null) {
                    throw new NullPointerException("id is marked non-null but is null");
                }
                EntityCache<E> cache = this.getEntityCache();
                if (cache.containsKey(id)) {
                    return (Optional)cache.get(id);
                }
                throw new NoSuchElementException();
            }

            @Override
            public <E extends Entity<E>> E get(@NonNull Entity.Id<E> id, @NonNull Function<Entity.Id<E>, E> loader) {
                if (id == null) {
                    throw new NullPointerException("id is marked non-null but is null");
                }
                if (loader == null) {
                    throw new NullPointerException("loader is marked non-null but is null");
                }
                EntityCache<E> cache = this.getEntityCache();
                if (cache.containsKey(id)) {
                    return (E)((Entity)((Optional)cache.get(id)).orElse(null));
                }
                Entity entity = (Entity)loader.apply(id);
                cache.put(id, Optional.ofNullable(entity));
                return (E)entity;
            }

            @Override
            public <E extends Entity<E>> List<E> snapshot(@NonNull Class<E> entityType) {
                if (entityType == null) {
                    throw new NullPointerException("entityType is marked non-null but is null");
                }
                EntityCache<E> cache = this.getEntityCache();
                return cache.values().stream().flatMap(Optional::stream).filter(v -> entityType.equals(v.getId().getType())).collect(Collectors.toUnmodifiableList());
            }

            @Override
            public <E extends Entity<E>> Map<Entity.Id<E>, E> entities(@NonNull Class<E> entityType) {
                if (entityType == null) {
                    throw new NullPointerException("entityType is marked non-null but is null");
                }
                EntityCache<E> cache = this.getEntityCache();
                return Collections.unmodifiableMap(Maps.transformValues((Map)Maps.filterEntries(cache, e -> entityType.equals(((Entity.Id)e.getKey()).getType()) && ((Optional)e.getValue()).isPresent()), Optional::get));
            }

            @Override
            public <E extends Entity<E>> void put(@NonNull E e) {
                if (e == null) {
                    throw new NullPointerException("e is marked non-null but is null");
                }
                EntityCache<E> cache = this.getEntityCache();
                cache.put(e.getId(), Optional.of(e));
            }

            @Override
            public <E extends Entity<E>> void putEmpty(@NonNull Entity.Id<E> id) {
                if (id == null) {
                    throw new NullPointerException("id is marked non-null but is null");
                }
                EntityCache<E> cache = this.getEntityCache();
                cache.put(id, Optional.empty());
            }

            @Override
            public <E extends Entity<E>> boolean containsKey(@NonNull Entity.Id<E> id) {
                return this.getEntityCache().containsKey(id);
            }
        };
    }
}

