/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.db.common;

import com.google.common.base.Preconditions;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ydb.yoj.repository.db.common.JsonConverter;

@ParametersAreNonnullByDefault
public final class CommonConverters {
    private static final Logger log = LoggerFactory.getLogger(CommonConverters.class);
    private static volatile JsonConverter jsonConverter = JsonConverter.NONE;

    private CommonConverters() {
    }

    public static void defineJsonConverter(JsonConverter jsonConverter) {
        Preconditions.checkArgument((jsonConverter != JsonConverter.NONE ? 1 : 0) != 0, (Object)"Cannot redefine JSON converter to JsonConverter.NONE, use disableJsonConverter() for that");
        JsonConverter old = CommonConverters.jsonConverter;
        if (old != JsonConverter.NONE) {
            log.warn("Redefining JSON converter from {} to {}. Doing so is NOT recommended in production code", (Object)old, (Object)jsonConverter);
        }
        CommonConverters.jsonConverter = jsonConverter;
    }

    public static void disableJsonConverter() {
        jsonConverter = JsonConverter.NONE;
    }

    public static <D> ThrowingSetter<D> stringValueSetter(Type type, BiConsumer<D, Object> rawValueSetter) {
        return (d, v) -> rawValueSetter.accept(d, CommonConverters.serializeStringValue(type, v));
    }

    public static String serializeStringValue(Type ignored, Object v) {
        return v.toString();
    }

    public static Object deserializeStringValue(Type type, Object src) {
        return String.class.equals((Object)type) ? src : CommonConverters.stringValueGetter(type, v -> v).apply(src);
    }

    public static <S> ThrowingGetter<S> stringValueGetter(Type type, Function<S, Object> rawValueGetter) {
        if (!(type instanceof Class)) {
            throw new IllegalArgumentException(String.format("Type <%s> is not a class", type.getTypeName()));
        }
        Class clazz = (Class)type;
        if (String.class.equals((Object)clazz)) {
            return rawValueGetter::apply;
        }
        ThrowingGetter<Object> deserializer = CommonConverters.getStringValueDeserializerMethod(clazz);
        return v -> {
            try {
                return deserializer.throwingGet(rawValueGetter.apply(v));
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
            catch (Exception e) {
                throw new IllegalStateException("Reflection problem with deserializer method " + deserializer, e);
            }
        };
    }

    private static ThrowingGetter<Object> getStringValueDeserializerMethod(Class<?> clazz) {
        for (String methodName : new String[]{"fromString", "valueOf"}) {
            try {
                Method method = clazz.getMethod(methodName, String.class);
                if (!Modifier.isStatic(method.getModifiers())) continue;
                return s -> method.invoke(null, s);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        try {
            return arg_0 -> CommonConverters.lambda$getStringValueDeserializerMethod$4(clazz.getConstructor(String.class), arg_0);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalArgumentException(String.format("Type <%s> does not have a deserializer method: public static fromString(String)/valueOf(String) anddoesn't have constructor public %s(String)", clazz.getTypeName(), clazz.getTypeName()));
        }
    }

    public static <D> ThrowingSetter<D> enumValueSetter(Type type, BiConsumer<D, Object> rawValueSetter) {
        return (d, v) -> rawValueSetter.accept(d, CommonConverters.serializeEnumValue(type, v));
    }

    public static String serializeEnumValue(Type type, Object v) {
        if (v instanceof Enum) {
            return ((Enum)v).name();
        }
        if (v instanceof String) {
            return (String)v;
        }
        throw new IllegalArgumentException("Enum value should be Enum or String but is " + type.getTypeName());
    }

    public static Object deserializeEnumValue(Type type, Object src) {
        return CommonConverters.enumValueGetter(type, v -> v).apply(src);
    }

    public static <S> ThrowingGetter<S> enumValueGetter(Type type, Function<S, Object> rawValueGetter) {
        Class clazz;
        if (!(type instanceof Class) || !(clazz = (Class)type).isEnum()) {
            throw new IllegalArgumentException(String.format("Type <%s> is not a enum class", type.getTypeName()));
        }
        Map<String, Enum> enumValues = Stream.of(clazz.getEnumConstants()).collect(Collectors.toUnmodifiableMap(e -> ((Enum)e).name().toUpperCase(Locale.ROOT), e -> (Enum)e));
        return v -> enumValues.get(((String)rawValueGetter.apply(v)).toUpperCase(Locale.ROOT));
    }

    public static <D> ThrowingSetter<D> enumToStringValueSetter(Type type, BiConsumer<D, Object> rawValueSetter) {
        return (d, v) -> rawValueSetter.accept(d, CommonConverters.serializeEnumToStringValue(type, v));
    }

    public static String serializeEnumToStringValue(Type type, Object v) {
        if (v instanceof Enum || v instanceof String) {
            return v.toString();
        }
        throw new IllegalArgumentException("Enum value should be Enum or String but is " + type.getTypeName());
    }

    public static Object deserializeEnumToStringValue(Type type, Object src) {
        return CommonConverters.enumToStringValueGetter(type, v -> v).apply(src);
    }

    public static <S> ThrowingGetter<S> enumToStringValueGetter(Type type, Function<S, Object> rawValueGetter) {
        Class clazz;
        if (!(type instanceof Class) || !(clazz = (Class)type).isEnum()) {
            throw new IllegalArgumentException(String.format("Type <%s> is not a enum class", type.getTypeName()));
        }
        Map<String, Enum> enumValues = Stream.of(clazz.getEnumConstants()).collect(Collectors.toUnmodifiableMap(Object::toString, e -> (Enum)e));
        return v -> enumValues.get((String)rawValueGetter.apply(v));
    }

    public static <D> ThrowingSetter<D> opaqueObjectValueSetter(Type type, BiConsumer<D, Object> rawValueSetter) {
        return (d, v) -> rawValueSetter.accept(d, CommonConverters.serializeOpaqueObjectValue(type, v));
    }

    public static String serializeOpaqueObjectValue(Type type, Object v) {
        return jsonConverter.toJson(type, v);
    }

    public static Object deserializeOpaqueObjectValue(Type type, Object src) {
        return CommonConverters.opaqueObjectValueGetter(type, v -> v).apply(src);
    }

    public static <S> ThrowingGetter<S> opaqueObjectValueGetter(Type type, Function<S, Object> rawValueGetter) {
        return v -> jsonConverter.fromJson(type, (String)rawValueGetter.apply(v));
    }

    public static Object fromObject(Type javaType, Object content) {
        return jsonConverter.fromObject(javaType, content);
    }

    private static /* synthetic */ Object lambda$getStringValueDeserializerMethod$4(Constructor rec$, Object xva$0) throws Throwable {
        return rec$.newInstance(xva$0);
    }

    public static interface ThrowingSetter<D>
    extends BiConsumer<D, Object> {
        public void throwingSet(D var1, Object var2) throws Throwable;

        @Override
        default public void accept(D dst, Object newValue) {
            this.throwingSet(dst, newValue);
        }
    }

    public static interface ThrowingGetter<S>
    extends Function<S, Object> {
        public Object throwingGet(S var1) throws Throwable;

        @Override
        default public Object apply(S src) {
            return this.throwingGet(src);
        }
    }
}

