/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.db.common;

import java.lang.reflect.Type;
import javax.annotation.Nullable;
import lombok.NonNull;
import tech.ydb.yoj.repository.db.exception.ConversionException;

public interface JsonConverter {
    public static final JsonConverter NONE = new JsonConverter(){

        @Override
        public String toJson(@NonNull Type type, @Nullable Object o) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            throw new UnsupportedOperationException("Define appropriate JSON converter!");
        }

        @Override
        public <T> T fromJson(@NonNull Type type, @NonNull String content) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            if (content == null) {
                throw new NullPointerException("content is marked non-null but is null");
            }
            throw new UnsupportedOperationException("Define appropriate JSON converter!");
        }

        @Override
        public <T> T fromObject(@NonNull Type type, @Nullable Object content) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            throw new UnsupportedOperationException("Define appropriate JSON converter!");
        }

        public String toString() {
            return "JsonConverter.NONE";
        }
    };

    public String toJson(@NonNull Type var1, @Nullable Object var2) throws ConversionException, UnsupportedOperationException;

    public <T> T fromJson(@NonNull Type var1, @NonNull String var2) throws ConversionException, UnsupportedOperationException;

    public <T> T fromObject(@NonNull Type var1, @Nullable Object var2) throws ConversionException, UnsupportedOperationException;
}

