/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.db.exception;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import tech.ydb.yoj.repository.db.exception.RepositoryException;

public class AggregateRepositoryException
extends RepositoryException {
    private final List<RepositoryException> causes;

    private AggregateRepositoryException(Collection<? extends RepositoryException> causes) {
        super("Encountered " + causes.size() + " repository exception(s): " + causes.stream().map(ex -> String.format("\"%s\"", ex)).collect(Collectors.joining(", ")));
        Preconditions.checkArgument((!causes.isEmpty() ? 1 : 0) != 0, (Object)"cannot throw aggregate exception without causes");
        this.causes = ImmutableList.copyOf(causes);
        this.causes.forEach(this::addSuppressed);
    }

    public static void throwIfNeeded(Collection<? extends RepositoryException> causes) throws RepositoryException {
        if (causes.isEmpty()) {
            return;
        }
        if (causes.size() == 1) {
            throw causes.iterator().next();
        }
        throw new AggregateRepositoryException(causes);
    }

    @Generated
    public List<RepositoryException> getCauses() {
        return this.causes;
    }
}

