/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.db.list;

import com.google.common.hash.Hashing;
import java.beans.ConstructorProperties;
import java.util.Objects;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import lombok.Generated;
import lombok.NonNull;
import tech.ydb.yoj.databind.expression.FilterBuilder;
import tech.ydb.yoj.databind.expression.FilterExpression;
import tech.ydb.yoj.databind.expression.OrderBuilder;
import tech.ydb.yoj.databind.expression.OrderExpression;
import tech.ydb.yoj.databind.schema.Schema;
import tech.ydb.yoj.repository.db.Entity;
import tech.ydb.yoj.repository.db.EntitySchema;
import tech.ydb.yoj.repository.db.list.BadListingException;
import tech.ydb.yoj.repository.db.list.token.PageToken;

public final class ListRequest<T> {
    private final long offset;
    private final int pageSize;
    private final Schema<T> schema;
    private final ListingParams<T> params;
    private final String index;

    public static <T extends Entity<T>> Builder<T> builder(@NonNull Class<T> entityClass) {
        if (entityClass == null) {
            throw new NullPointerException("entityClass is marked non-null but is null");
        }
        return ListRequest.builder(EntitySchema.of(entityClass));
    }

    public static <T> Builder<T> builder(@NonNull Schema<T> schema) {
        if (schema == null) {
            throw new NullPointerException("schema is marked non-null but is null");
        }
        return new Builder<T>(schema);
    }

    @Nullable
    public FilterExpression<T> getFilter() {
        return this.params.filter;
    }

    @Nullable
    public OrderExpression<T> getOrderBy() {
        return this.params.orderBy;
    }

    @NonNull
    public ListRequest<T> withFilter(@NonNull UnaryOperator<FilterBuilder<T>> filterCtor) {
        if (filterCtor == null) {
            throw new NullPointerException("filterCtor is marked non-null but is null");
        }
        return this.withFilter(((FilterBuilder)filterCtor.apply(FilterBuilder.forSchema(this.schema))).build());
    }

    public ListRequest<T> withFilter(@Nullable FilterExpression<T> filter) {
        return this.withParams(this.params.withFilter(filter));
    }

    @NonNull
    public ListRequest<T> withOrderBy(@NonNull UnaryOperator<OrderBuilder<T>> orderCtor) {
        if (orderCtor == null) {
            throw new NullPointerException("orderCtor is marked non-null but is null");
        }
        return this.withOrderBy(((OrderBuilder)orderCtor.apply(OrderBuilder.forSchema(this.schema))).build());
    }

    public ListRequest<T> withOrderBy(@Nullable OrderExpression<T> orderBy) {
        return this.withParams(this.params.withOrderBy(orderBy));
    }

    public <U extends Entity<U>> ListRequest<U> forEntity(@NonNull Class<U> dstEntityType, @NonNull UnaryOperator<String> pathTransformer) {
        if (dstEntityType == null) {
            throw new NullPointerException("dstEntityType is marked non-null but is null");
        }
        if (pathTransformer == null) {
            throw new NullPointerException("pathTransformer is marked non-null but is null");
        }
        EntitySchema<U> dstSchema = EntitySchema.of(dstEntityType);
        return new ListRequest<U>(this.offset, this.pageSize, dstSchema, this.params.forSchema(dstSchema, pathTransformer), null);
    }

    @Generated
    public long getOffset() {
        return this.offset;
    }

    @Generated
    public int getPageSize() {
        return this.pageSize;
    }

    @Generated
    public Schema<T> getSchema() {
        return this.schema;
    }

    @Generated
    public ListingParams<T> getParams() {
        return this.params;
    }

    @Generated
    public String getIndex() {
        return this.index;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListRequest)) {
            return false;
        }
        ListRequest other = (ListRequest)o;
        if (this.getOffset() != other.getOffset()) {
            return false;
        }
        if (this.getPageSize() != other.getPageSize()) {
            return false;
        }
        Schema<T> this$schema = this.getSchema();
        Schema<T> other$schema = other.getSchema();
        if (this$schema == null ? other$schema != null : !this$schema.equals(other$schema)) {
            return false;
        }
        ListingParams<T> this$params = this.getParams();
        ListingParams<T> other$params = other.getParams();
        if (this$params == null ? other$params != null : !((Object)this$params).equals(other$params)) {
            return false;
        }
        String this$index = this.getIndex();
        String other$index = other.getIndex();
        return !(this$index == null ? other$index != null : !this$index.equals(other$index));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $offset = this.getOffset();
        result = result * 59 + (int)($offset >>> 32 ^ $offset);
        result = result * 59 + this.getPageSize();
        Schema<T> $schema = this.getSchema();
        result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
        ListingParams<T> $params = this.getParams();
        result = result * 59 + ($params == null ? 43 : ((Object)$params).hashCode());
        String $index = this.getIndex();
        result = result * 59 + ($index == null ? 43 : $index.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ListRequest(offset=" + this.getOffset() + ", pageSize=" + this.getPageSize() + ", schema=" + this.getSchema() + ", params=" + this.getParams() + ", index=" + this.getIndex() + ")";
    }

    @ConstructorProperties(value={"offset", "pageSize", "schema", "params", "index"})
    @Generated
    private ListRequest(long offset, int pageSize, Schema<T> schema, ListingParams<T> params, String index) {
        this.offset = offset;
        this.pageSize = pageSize;
        this.schema = schema;
        this.params = params;
        this.index = index;
    }

    @Generated
    public ListRequest<T> withOffset(long offset) {
        return this.offset == offset ? this : new ListRequest<T>(offset, this.pageSize, this.schema, this.params, this.index);
    }

    @Generated
    public ListRequest<T> withPageSize(int pageSize) {
        return this.pageSize == pageSize ? this : new ListRequest<T>(this.offset, pageSize, this.schema, this.params, this.index);
    }

    @Generated
    public ListRequest<T> withParams(ListingParams<T> params) {
        return this.params == params ? this : new ListRequest<T>(this.offset, this.pageSize, this.schema, params, this.index);
    }

    @Generated
    public ListRequest<T> withIndex(String index) {
        return this.index == index ? this : new ListRequest<T>(this.offset, this.pageSize, this.schema, this.params, index);
    }

    public static final class Builder<T> {
        public static final int DEFAULT_PAGE_SIZE = 100;
        public static final int MAX_PAGE_SIZE = 1000;
        public static final int MAX_SKIP_SIZE = 10000;
        private final Schema<T> schema;
        private int pageSize = 100;
        private long offset = 0L;
        private FilterExpression<T> filter;
        private OrderExpression<T> orderBy;
        private String index;
        private UnaryOperator<Builder<T>> transform;

        @NonNull
        public Builder<T> pageSize(long pageSize) {
            if (pageSize < 1L || pageSize > 1000L) {
                throw new BadListingException.BadPageSize(pageSize, 1000L);
            }
            this.pageSize = Math.toIntExact(pageSize);
            return this;
        }

        @NonNull
        public BuildPageToken pageToken(@NonNull PageToken codec) {
            if (codec == null) {
                throw new NullPointerException("codec is marked non-null but is null");
            }
            return new BuildPageToken(codec);
        }

        @NonNull
        public Builder<T> offset(long offset) {
            if (offset < 0L || offset > 10000L) {
                throw new BadListingException.BadOffset(10000L);
            }
            this.offset = offset;
            return this;
        }

        @NonNull
        public Builder<T> noFilter() {
            return this.filter((FilterExpression)null);
        }

        @NonNull
        public Builder<T> filter(@NonNull UnaryOperator<FilterBuilder<T>> filterCtor) {
            if (filterCtor == null) {
                throw new NullPointerException("filterCtor is marked non-null but is null");
            }
            return this.filter(((FilterBuilder)filterCtor.apply(FilterBuilder.forSchema(this.schema))).build());
        }

        @NonNull
        public Builder<T> filter(@Nullable FilterExpression<T> filter) {
            this.filter = filter;
            return this;
        }

        @NonNull
        public Builder<T> index(@Nullable String index) {
            this.index = index;
            return this;
        }

        @NonNull
        public Builder<T> defaultOrder() {
            return this.orderBy((OrderExpression)null);
        }

        @NonNull
        public Builder<T> orderBy(@NonNull UnaryOperator<OrderBuilder<T>> orderCtor) {
            if (orderCtor == null) {
                throw new NullPointerException("orderCtor is marked non-null but is null");
            }
            return this.orderBy(((OrderBuilder)orderCtor.apply(OrderBuilder.forSchema(this.schema))).build());
        }

        @NonNull
        public Builder<T> orderBy(@Nullable OrderExpression<T> orderBy) {
            this.orderBy = orderBy;
            return this;
        }

        @NonNull
        public ListRequest<T> build() {
            return (this.transform == null ? this : (Builder)this.transform.apply(this)).build0();
        }

        @NonNull
        private ListRequest<T> build0() {
            return new ListRequest<T>(this.offset, this.pageSize, this.schema, this.params(), this.index);
        }

        @NonNull
        public ListingParams<T> params() {
            return new ListingParams<T>(this.filter, this.orderBy);
        }

        @NonNull
        public Schema<T> schema() {
            return this.schema;
        }

        @ConstructorProperties(value={"schema"})
        @Generated
        private Builder(Schema<T> schema) {
            this.schema = schema;
        }

        public final class BuildPageToken {
            private final PageToken codec;

            @NonNull
            public Builder<T> decode(@Nullable String encodedToken) {
                Builder.this.transform = encodedToken == null ? null : bldr -> this.codec.decode(bldr, encodedToken);
                return Builder.this;
            }

            @ConstructorProperties(value={"codec"})
            @Generated
            private BuildPageToken(PageToken codec) {
                this.codec = codec;
            }
        }
    }

    public static final class ListingParams<T> {
        @Nullable
        private final FilterExpression<T> filter;
        @Nullable
        private final OrderExpression<T> orderBy;

        @NonNull
        public static <T extends Entity<T>> ListingParams<T> empty() {
            return new ListingParams<T>(null, null);
        }

        @NonNull
        public <U extends Entity<U>> ListingParams<U> forSchema(@NonNull Schema<U> dstSchema, @NonNull UnaryOperator<String> pathTransformer) {
            if (dstSchema == null) {
                throw new NullPointerException("dstSchema is marked non-null but is null");
            }
            if (pathTransformer == null) {
                throw new NullPointerException("pathTransformer is marked non-null but is null");
            }
            return new ListingParams<T>(this.filter == null ? null : this.filter.forSchema(dstSchema, pathTransformer), this.orderBy == null ? null : this.orderBy.forSchema(dstSchema, pathTransformer));
        }

        public long hash() {
            return Hashing.farmHashFingerprint64().newHasher().putInt(Objects.hashCode(this.filter)).putInt(Objects.hashCode(this.orderBy)).hash().asLong();
        }

        @ConstructorProperties(value={"filter", "orderBy"})
        @Generated
        public ListingParams(@Nullable FilterExpression<T> filter, @Nullable OrderExpression<T> orderBy) {
            this.filter = filter;
            this.orderBy = orderBy;
        }

        @Nullable
        @Generated
        public FilterExpression<T> getFilter() {
            return this.filter;
        }

        @Nullable
        @Generated
        public OrderExpression<T> getOrderBy() {
            return this.orderBy;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ListingParams)) {
                return false;
            }
            ListingParams other = (ListingParams)o;
            FilterExpression<T> this$filter = this.getFilter();
            FilterExpression<T> other$filter = other.getFilter();
            if (this$filter == null ? other$filter != null : !this$filter.equals(other$filter)) {
                return false;
            }
            OrderExpression<T> this$orderBy = this.getOrderBy();
            OrderExpression<T> other$orderBy = other.getOrderBy();
            return !(this$orderBy == null ? other$orderBy != null : !this$orderBy.equals(other$orderBy));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            FilterExpression<T> $filter = this.getFilter();
            result = result * 59 + ($filter == null ? 43 : $filter.hashCode());
            OrderExpression<T> $orderBy = this.getOrderBy();
            result = result * 59 + ($orderBy == null ? 43 : $orderBy.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ListRequest.ListingParams(filter=" + this.getFilter() + ", orderBy=" + this.getOrderBy() + ")";
        }

        @Generated
        public ListingParams<T> withFilter(@Nullable FilterExpression<T> filter) {
            return this.filter == filter ? this : new ListingParams<T>(filter, this.orderBy);
        }

        @Generated
        public ListingParams<T> withOrderBy(@Nullable OrderExpression<T> orderBy) {
            return this.orderBy == orderBy ? this : new ListingParams<T>(this.filter, orderBy);
        }
    }
}

