/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.db.list;

import java.util.Collections;
import java.util.List;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import lombok.NonNull;
import tech.ydb.yoj.repository.db.Entity;
import tech.ydb.yoj.repository.db.list.GenericListResult;
import tech.ydb.yoj.repository.db.list.ListRequest;

public final class ListResult<T>
extends GenericListResult<T, T>
implements Iterable<T> {
    private ListResult(@NonNull List<T> entries, boolean lastPage, @NonNull ListRequest<T> request) {
        super(entries, request.getSchema(), lastPage, request);
        if (entries == null) {
            throw new NullPointerException("entries is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
    }

    @NonNull
    public static <T extends Entity<T>> ListResult<T> empty(@NonNull ListRequest<T> request) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        return new ListResult(Collections.emptyList(), true, request);
    }

    @NonNull
    public static <T extends Entity<T>> GenericListResult.Builder<T, T, ListResult<T>> builder(@NonNull ListRequest<T> request) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        return new ListResultBuilder<T>(request);
    }

    @NonNull
    public static <T extends Entity<T>> ListResult<T> forPage(@NonNull ListRequest<T> request, @NonNull List<T> entries) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (entries == null) {
            throw new NullPointerException("entries is marked non-null but is null");
        }
        int pageSize = request.getPageSize();
        boolean lastPage = entries.size() <= pageSize;
        List<T> itemsToReturn = lastPage ? entries : entries.subList(0, pageSize);
        return new ListResult<T>(itemsToReturn, lastPage, request);
    }

    @NonNull
    public ListResult<T> returnWithParams(@NonNull ListRequest.ListingParams<T> overrideParams) {
        if (overrideParams == null) {
            throw new NullPointerException("overrideParams is marked non-null but is null");
        }
        return new ListResult(this.getEntries(), this.isLastPage(), this.getRequest().withParams(overrideParams));
    }

    @NonNull
    public ListResult<T> transform(@NonNull UnaryOperator<T> transform) {
        if (transform == null) {
            throw new NullPointerException("transform is marked non-null but is null");
        }
        return new ListResult(this.stream().map(transform).collect(Collectors.toList()), this.isLastPage(), this.getRequest());
    }

    public static final class ListResultBuilder<T extends Entity<T>>
    extends GenericListResult.Builder<T, T, ListResult<T>> {
        private ListResultBuilder(ListRequest<T> request) {
            super(request);
        }

        @Override
        @NonNull
        public ListResult<T> build() {
            return new ListResult(this.entries, this.lastPage, this.request);
        }
    }
}

