/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.db.list;

import java.util.List;
import lombok.NonNull;
import tech.ydb.yoj.databind.schema.Schema;
import tech.ydb.yoj.repository.db.Entity;
import tech.ydb.yoj.repository.db.Table;
import tech.ydb.yoj.repository.db.ViewSchema;
import tech.ydb.yoj.repository.db.list.GenericListResult;
import tech.ydb.yoj.repository.db.list.ListRequest;

public final class ViewListResult<T extends Entity<T>, V extends Table.View>
extends GenericListResult<T, V> {
    private ViewListResult(@NonNull List<V> entries, @NonNull Schema<V> viewSchema, boolean lastPage, @NonNull ListRequest<T> request) {
        super(entries, viewSchema, lastPage, request);
        if (entries == null) {
            throw new NullPointerException("entries is marked non-null but is null");
        }
        if (viewSchema == null) {
            throw new NullPointerException("viewSchema is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
    }

    @NonNull
    public static <T extends Entity<T>, V extends Table.View> GenericListResult.Builder<T, V, ViewListResult<T, V>> builder(@NonNull Class<V> viewType, @NonNull ListRequest<T> request) {
        if (viewType == null) {
            throw new NullPointerException("viewType is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        return new ViewListResultBuilder<T, V>(viewType, request);
    }

    @NonNull
    public static <T extends Entity<T>, V extends Table.View> ViewListResult<T, V> forPage(@NonNull ListRequest<T> request, @NonNull Class<V> viewClass, @NonNull List<V> entries) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (viewClass == null) {
            throw new NullPointerException("viewClass is marked non-null but is null");
        }
        if (entries == null) {
            throw new NullPointerException("entries is marked non-null but is null");
        }
        int pageSize = request.getPageSize();
        boolean lastPage = entries.size() <= pageSize;
        List<V> itemsToReturn = lastPage ? entries : entries.subList(0, pageSize);
        return new ViewListResult<T, V>(itemsToReturn, ViewSchema.of(viewClass), lastPage, request);
    }

    @NonNull
    public ViewListResult<T, V> returnWithParams(@NonNull ListRequest.ListingParams<T> overrideParams) {
        if (overrideParams == null) {
            throw new NullPointerException("overrideParams is marked non-null but is null");
        }
        return new ViewListResult(this.getEntries(), this.getResultSchema(), this.isLastPage(), this.getRequest().withParams(overrideParams));
    }

    public static final class ViewListResultBuilder<T extends Entity<T>, V extends Table.View>
    extends GenericListResult.Builder<T, V, ViewListResult<T, V>> {
        private final Class<V> viewType;

        private ViewListResultBuilder(Class<V> viewType, ListRequest<T> request) {
            super(request);
            this.viewType = viewType;
        }

        @Override
        @NonNull
        public ViewListResult<T, V> build() {
            return new ViewListResult(this.entries, ViewSchema.of(this.viewType), this.lastPage, this.request);
        }
    }
}

