/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.db.projection;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import tech.ydb.yoj.databind.schema.Schema;
import tech.ydb.yoj.repository.db.Entity;
import tech.ydb.yoj.repository.db.EntityIdSchema;
import tech.ydb.yoj.repository.db.EntitySchema;
import tech.ydb.yoj.repository.db.list.ListRequest;
import tech.ydb.yoj.repository.db.list.ListResult;

public final class ProjectionMappings {
    private ProjectionMappings() {
    }

    @NonNull
    public static <P extends Entity<P>, T extends Entity<T>> Map<String, String> lenientFieldMapping(@NonNull Class<P> projectionType, @NonNull Class<T> entityType) {
        if (projectionType == null) {
            throw new NullPointerException("projectionType is marked non-null but is null");
        }
        if (entityType == null) {
            throw new NullPointerException("entityType is marked non-null but is null");
        }
        EntitySchema<T> entitySchema = EntitySchema.of(entityType);
        Class entityIdType = entitySchema.getIdSchema().getType();
        HashBiMap mapping = HashBiMap.create(ProjectionMappings.strictFieldMapping(projectionType, entityType));
        EntitySchema.of(projectionType).flattenFields().stream().filter(arg_0 -> ProjectionMappings.lambda$lenientFieldMapping$0(entityIdType, (BiMap)mapping, arg_0)).forEach(arg_0 -> ProjectionMappings.lambda$lenientFieldMapping$2(entitySchema, (BiMap)mapping, arg_0));
        return mapping;
    }

    @NonNull
    public static <P extends Entity<P>, T extends Entity<T>> Map<String, String> strictFieldMapping(@NonNull Class<P> projectionType, @NonNull Class<T> entityType) {
        if (projectionType == null) {
            throw new NullPointerException("projectionType is marked non-null but is null");
        }
        if (entityType == null) {
            throw new NullPointerException("entityType is marked non-null but is null");
        }
        EntitySchema entitySchema = EntitySchema.of(entityType);
        Class entityIdType = entitySchema.getIdSchema().getType();
        List projectionIdFields = EntityIdSchema.ofEntity(projectionType).getFields();
        HashMap<String, String> mapping = new HashMap<String, String>();
        projectionIdFields.stream().filter(f -> !ProjectionMappings.isEntityId(f, entityIdType)).flatMap(Schema.JavaField::flatten).forEach(f -> mapping.put(ProjectionMappings.getMatchingNonIdField(f, entitySchema).getPath(), f.getPath()));
        List idTypeFields = projectionIdFields.stream().filter(f -> ProjectionMappings.isEntityId(f, entityIdType)).collect(Collectors.toList());
        if (idTypeFields.size() > 1) {
            throw new IllegalStateException("Projection ID cannot have more than 1 field with type: " + entityIdType);
        }
        if (idTypeFields.size() == 0) {
            return mapping;
        }
        ((Schema.JavaField)idTypeFields.get(0)).flatten().forEach(idPart -> mapping.put(ProjectionMappings.getMatchingIdField(idPart, entitySchema).getPath(), idPart.getPath()));
        return mapping;
    }

    private static boolean isEntityId(@NonNull Schema.JavaField field, @NonNull Class<?> entityIdType) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (entityIdType == null) {
            throw new NullPointerException("entityIdType is marked non-null but is null");
        }
        return field.getType().equals(entityIdType);
    }

    @NonNull
    private static Optional<Schema.JavaField> findMatchingNonIdField(@NonNull Schema.JavaField projectionField, @NonNull EntitySchema<?> realEntity) {
        if (projectionField == null) {
            throw new NullPointerException("projectionField is marked non-null but is null");
        }
        if (realEntity == null) {
            throw new NullPointerException("realEntity is marked non-null but is null");
        }
        return realEntity.findField(projectionField.getRawPath());
    }

    @NonNull
    private static Schema.JavaField getMatchingNonIdField(@NonNull Schema.JavaField projectionField, @NonNull EntitySchema<?> realEntity) {
        if (projectionField == null) {
            throw new NullPointerException("projectionField is marked non-null but is null");
        }
        if (realEntity == null) {
            throw new NullPointerException("realEntity is marked non-null but is null");
        }
        return realEntity.getField(projectionField.getRawPath());
    }

    @NonNull
    private static Schema.JavaField getMatchingIdField(@NonNull Schema.JavaField projectionIdField, @NonNull EntitySchema<?> realEntity) {
        if (projectionIdField == null) {
            throw new NullPointerException("projectionIdField is marked non-null but is null");
        }
        if (realEntity == null) {
            throw new NullPointerException("realEntity is marked non-null but is null");
        }
        return realEntity.getIdSchema().getField(projectionIdField.getRawSubPath(1));
    }

    @NonNull
    public static <P extends Entity<P>> ListViaProjection<P> listViaProjection(@NonNull Class<P> projectionType) {
        if (projectionType == null) {
            throw new NullPointerException("projectionType is marked non-null but is null");
        }
        return new ListViaProjection<P>(projectionType);
    }

    private static /* synthetic */ void lambda$lenientFieldMapping$2(EntitySchema entitySchema, BiMap mapping, Schema.JavaField pf) {
        ProjectionMappings.findMatchingNonIdField(pf, entitySchema).ifPresent(ef -> mapping.put((Object)ef.getPath(), (Object)pf.getPath()));
    }

    private static /* synthetic */ boolean lambda$lenientFieldMapping$0(Class entityIdType, BiMap mapping, Schema.JavaField pf) {
        return !ProjectionMappings.isEntityId(pf, entityIdType) && !mapping.inverse().containsKey((Object)pf.getPath());
    }

    public static final class ListViaProjection<P extends Entity<P>> {
        private final Class<P> projectionType;

        @NonNull
        public <T extends Entity<T>> Listing<T, P> entities(@NonNull ListRequest<T> request) {
            if (request == null) {
                throw new NullPointerException("request is marked non-null but is null");
            }
            return this.entities(request, ProjectionMappings.lenientFieldMapping(this.projectionType, request.getSchema().getType()));
        }

        @NonNull
        public <T extends Entity<T>> Listing<T, P> entities(@NonNull ListRequest<T> request, @NonNull Map<String, String> fieldMapping) {
            if (request == null) {
                throw new NullPointerException("request is marked non-null but is null");
            }
            if (fieldMapping == null) {
                throw new NullPointerException("fieldMapping is marked non-null but is null");
            }
            return this.entities(request, f -> this.getFieldMapping(fieldMapping, (String)f));
        }

        @NonNull
        private String getFieldMapping(@NonNull Map<String, String> fieldMapping, String f) {
            if (fieldMapping == null) {
                throw new NullPointerException("fieldMapping is marked non-null but is null");
            }
            String mapping = fieldMapping.get(f);
            Preconditions.checkState((mapping != null ? 1 : 0) != 0, (String)"No mapping for entity field \"%s\" in projection %s", (Object)f, this.projectionType);
            return mapping;
        }

        @NonNull
        public <T extends Entity<T>> Listing<T, P> entities(@NonNull ListRequest<T> request, @NonNull UnaryOperator<String> fieldMapping) {
            if (request == null) {
                throw new NullPointerException("request is marked non-null but is null");
            }
            if (fieldMapping == null) {
                throw new NullPointerException("fieldMapping is marked non-null but is null");
            }
            return new Listing<T, P>(request, request.forEntity(this.projectionType, fieldMapping));
        }

        @ConstructorProperties(value={"projectionType"})
        @Generated
        private ListViaProjection(Class<P> projectionType) {
            this.projectionType = projectionType;
        }

        public static final class Listing<T extends Entity<T>, P extends Entity<P>> {
            private final ListRequest<T> request;
            private final ListRequest<P> projRequest;

            @NonNull
            public TransformedListing<T, P> transforming(@NonNull Function<P, T> unproject) {
                if (unproject == null) {
                    throw new NullPointerException("unproject is marked non-null but is null");
                }
                return new TransformedListing<T, P>(this, unproject);
            }

            @NonNull
            public ListResult<P> run(@NonNull Function<ListRequest<P>, ListResult<P>> listFunc) {
                if (listFunc == null) {
                    throw new NullPointerException("listFunc is marked non-null but is null");
                }
                return listFunc.apply(this.projRequest);
            }

            @ConstructorProperties(value={"request", "projRequest"})
            @Generated
            private Listing(ListRequest<T> request, ListRequest<P> projRequest) {
                this.request = request;
                this.projRequest = projRequest;
            }
        }

        public static final class TransformedListing<T extends Entity<T>, P extends Entity<P>> {
            private final Listing<T, P> listing;
            private final Function<P, T> unproject;

            @NonNull
            public ListResult<T> run(@NonNull Function<ListRequest<P>, ListResult<P>> listFunc) {
                if (listFunc == null) {
                    throw new NullPointerException("listFunc is marked non-null but is null");
                }
                ListResult<P> projResult = this.listing.run(listFunc);
                return ListResult.builder(this.listing.request).entries(projResult.stream().map(this.unproject).collect(Collectors.toList())).lastPage(projResult.isLastPage()).build();
            }

            @ConstructorProperties(value={"listing", "unproject"})
            @Generated
            private TransformedListing(Listing<T, P> listing, Function<P, T> unproject) {
                this.listing = listing;
                this.unproject = unproject;
            }
        }
    }
}

