/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.util.lang;

import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import lombok.NonNull;

public final class Strings {
    private Strings() {
    }

    public static String join(String delimiter, Object ... values) {
        return Stream.of(values).filter(Objects::nonNull).map(Object::toString).filter(s -> !s.isBlank()).collect(Collectors.joining(delimiter));
    }

    public static String removeSuffix(@Nullable String s, @NonNull String suffix) {
        if (suffix == null) {
            throw new NullPointerException("suffix is marked non-null but is null");
        }
        return s != null && s.endsWith(suffix) ? s.substring(0, s.length() - suffix.length()) : s;
    }

    public static String leftPad(@NonNull String s, int minLength, char padChar) {
        if (s == null) {
            throw new NullPointerException("s is marked non-null but is null");
        }
        return s.length() >= minLength ? s : String.valueOf(padChar).repeat(minLength - s.length()) + s;
    }
}

