/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.util.retry;

import java.time.Duration;
import lombok.NonNull;
import tech.ydb.yoj.util.retry.ExponentialBackoffRetryPolicy;
import tech.ydb.yoj.util.retry.FixedDelayRetryPolicy;

public interface RetryPolicy {
    public Duration calcDuration(int var1);

    public boolean isSameAs(@NonNull RetryPolicy var1);

    public static RetryPolicy expBackoff() {
        return ExponentialBackoffRetryPolicy.DEFAULT;
    }

    @NonNull
    public static RetryPolicy expBackoff(long initial, long max, double jitter, double multiplier) {
        return new ExponentialBackoffRetryPolicy(initial, max, jitter, multiplier);
    }

    @NonNull
    public static RetryPolicy expBackoff(Duration initial, Duration max, double jitter, double multiplier) {
        return new ExponentialBackoffRetryPolicy(initial.toMillis(), max.toMillis(), jitter, multiplier);
    }

    @NonNull
    public static RetryPolicy fixed(Duration delay) {
        return RetryPolicy.fixed(delay.toMillis());
    }

    @NonNull
    public static RetryPolicy fixed(Duration delay, double jitter) {
        return RetryPolicy.fixed(delay.toMillis(), jitter);
    }

    @NonNull
    public static RetryPolicy fixed(long delay) {
        return RetryPolicy.fixed(delay, 0.0);
    }

    @NonNull
    public static RetryPolicy fixed(long delay, double jitter) {
        return new FixedDelayRetryPolicy(delay, jitter);
    }

    public static RetryPolicy retryImmediately() {
        return new FixedDelayRetryPolicy(0L, 0.0);
    }
}

