/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.util.lang;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.function.Predicate;

public final class CallStack {
    private final ConcurrentMap<FrameKey, Object> mapperCache = new ConcurrentHashMap<FrameKey, Object>();

    public FrameResult findCallingFrame() {
        return new FrameResult();
    }

    public class FrameResult {
        private StackWalker.StackFrame frameCached;
        private final List<Predicate<StackWalker.StackFrame>> predicates = new ArrayList<Predicate<StackWalker.StackFrame>>();

        private FrameResult() {
        }

        public FrameResult skipPackage(Package packageToSkip) {
            return this.skipFramesWhile(frame -> frame.getDeclaringClass().getPackage().equals(packageToSkip));
        }

        public FrameResult skipPackage(String packageToSkip) {
            return this.skipFramesWhile(frame -> frame.getDeclaringClass().getPackage().getName().equals(packageToSkip));
        }

        public FrameResult skipPackages(Set<String> packagesToSkip) {
            return this.skipFramesWhile(frame -> packagesToSkip.contains(frame.getDeclaringClass().getPackage().getName()));
        }

        public FrameResult skipFramesWhile(Predicate<StackWalker.StackFrame> predicate) {
            this.predicates.add(predicate);
            return this;
        }

        public StackWalker.StackFrame frame() {
            return this.findFrame();
        }

        public <T> T map(Function<StackWalker.StackFrame, T> mapper) {
            StackWalker.StackFrame frame = this.findFrame();
            return (T)CallStack.this.mapperCache.computeIfAbsent(new FrameKey(frame), __ -> mapper.apply(frame));
        }

        private StackWalker.StackFrame findFrame() {
            if (this.frameCached != null) {
                return this.frameCached;
            }
            this.frameCached = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE).walk(stream -> {
                stream = stream.dropWhile(f -> f.getDeclaringClass().equals(this.getClass()));
                for (Predicate<StackWalker.StackFrame> predicate : this.predicates) {
                    stream = stream.dropWhile(predicate);
                }
                return stream.findFirst().orElseThrow(() -> new IllegalStateException("Stacktrace doesn't contain matching frames"));
            });
            return this.frameCached;
        }
    }

    private record FrameKey(String className, String methodName, int lineNumber) {
        FrameKey(StackWalker.StackFrame frame) {
            this(frame.getClassName(), frame.getMethodName(), frame.getLineNumber());
        }
    }
}

