/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.util.lang;

import java.io.InterruptedIOException;
import java.nio.channels.ClosedByInterruptException;
import java.time.Duration;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import tech.ydb.yoj.util.lang.Exceptions;

public final class Interrupts {
    private Interrupts() {
    }

    public static boolean isThreadInterrupted(Throwable t) {
        return Interrupts.isThreadInterrupted() || Interrupts.isInterruptException(t);
    }

    public static boolean isInterruptException(Throwable t) {
        if (Exceptions.isOrCausedBy(t, InterruptedException.class)) {
            return true;
        }
        if (Exceptions.isOrCausedByExact(t, InterruptedIOException.class)) {
            return true;
        }
        return Exceptions.isOrCausedBy(t, ClosedByInterruptException.class);
    }

    public static boolean isThreadInterrupted() {
        return Thread.currentThread().isInterrupted();
    }

    public static boolean awaitTermination(ExecutorService executor, Duration timeout) {
        try {
            return executor.awaitTermination(timeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public static void runInCleanupMode(Runnable action) {
        boolean interrupted = Thread.interrupted();
        try {
            action.run();
        }
        catch (Exception e) {
            interrupted = interrupted || Interrupts.isInterruptException(e);
            throw e;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

