/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.util.retry;

import java.beans.ConstructorProperties;
import java.time.Duration;
import javax.annotation.Nullable;
import lombok.Generated;
import tech.ydb.yoj.util.retry.RetryPolicy;

public final class FixedDelayRetryPolicy
implements RetryPolicy {
    private final long delay;
    private final double jitter;

    @Override
    public Duration calcDuration(int attempt) {
        return Duration.ofMillis((long)((double)this.delay * (1.0 + this.jitter * (Math.random() * 2.0 - 1.0))));
    }

    @Override
    public boolean isSameAs(@Nullable RetryPolicy other) {
        return this.equals(other);
    }

    @Generated
    public long getDelay() {
        return this.delay;
    }

    @Generated
    public double getJitter() {
        return this.jitter;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FixedDelayRetryPolicy)) {
            return false;
        }
        FixedDelayRetryPolicy other = (FixedDelayRetryPolicy)o;
        if (this.getDelay() != other.getDelay()) {
            return false;
        }
        return Double.compare(this.getJitter(), other.getJitter()) == 0;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $delay = this.getDelay();
        result = result * 59 + (int)($delay >>> 32 ^ $delay);
        long $jitter = Double.doubleToLongBits(this.getJitter());
        result = result * 59 + (int)($jitter >>> 32 ^ $jitter);
        return result;
    }

    @Generated
    public String toString() {
        return "FixedDelayRetryPolicy(delay=" + this.getDelay() + ", jitter=" + this.getJitter() + ")";
    }

    @ConstructorProperties(value={"delay", "jitter"})
    @Generated
    FixedDelayRetryPolicy(long delay, double jitter) {
        this.delay = delay;
        this.jitter = jitter;
    }
}

