/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.util.lang;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import javax.annotation.Nullable;
import lombok.NonNull;

public final class Exceptions {
    private Exceptions() {
    }

    public static <X extends Throwable> boolean isOrCausedBy(@Nullable Throwable t, @NonNull Class<X> causeClass) {
        if (causeClass == null) {
            throw new NullPointerException("causeClass is marked non-null but is null");
        }
        Set dejaVu = Collections.newSetFromMap(new IdentityHashMap());
        Throwable current = t;
        while (current != null) {
            if (causeClass.isInstance(current)) {
                return true;
            }
            dejaVu.add(current);
            Throwable next = current.getCause();
            if (dejaVu.contains(next)) {
                return false;
            }
            current = next;
        }
        return false;
    }

    public static <X extends Throwable> boolean isOrCausedByExact(@Nullable Throwable t, @NonNull Class<X> causeClass) {
        if (causeClass == null) {
            throw new NullPointerException("causeClass is marked non-null but is null");
        }
        Set dejaVu = Collections.newSetFromMap(new IdentityHashMap());
        Throwable current = t;
        while (current != null) {
            if (causeClass.equals(current.getClass())) {
                return true;
            }
            dejaVu.add(current);
            Throwable next = current.getCause();
            if (dejaVu.contains(next)) {
                return false;
            }
            current = next;
        }
        return false;
    }
}

