/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.util.retry;

import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.time.Duration;
import javax.annotation.Nullable;
import lombok.Generated;
import tech.ydb.yoj.util.retry.RetryPolicy;

public final class ExponentialBackoffRetryPolicy
implements RetryPolicy {
    private static final long NANOS_IN_MILLIS = 1000000L;
    public static final RetryPolicy DEFAULT = new ExponentialBackoffRetryPolicy(1000L, 120000L, 0.2, 1.6);
    private final long initial;
    private final long max;
    private final double jitter;
    private final double multiplier;

    @ConstructorProperties(value={"initial", "max", "jitter", "multiplier"})
    public ExponentialBackoffRetryPolicy(long initial, long max, double jitter, double multiplier) {
        Preconditions.checkArgument((multiplier >= 1.0 ? 1 : 0) != 0, (Object)"multiplier must be at least 1");
        Preconditions.checkArgument((initial >= 0L ? 1 : 0) != 0, (Object)"initial delay must be non-negative");
        Preconditions.checkArgument((max >= 0L ? 1 : 0) != 0, (Object)"max delay must be non-negative");
        Preconditions.checkArgument((jitter >= 0.0 && jitter <= 1.0 ? 1 : 0) != 0, (Object)"jitter must be a ratio between 0 and 1, inclusive");
        this.initial = initial;
        this.max = max;
        this.jitter = jitter;
        this.multiplier = multiplier;
    }

    @Override
    public Duration calcDuration(int attempt) {
        Preconditions.checkArgument((attempt >= 0 ? 1 : 0) != 0, (Object)"attempt must be greater than 0");
        if (attempt == 0) {
            return Duration.ofMillis(Math.min(this.max, this.initial));
        }
        double delay = Math.min((double)this.max, (double)this.initial * Math.pow(this.multiplier, attempt - 1));
        return Duration.ofNanos((long)(delay * 1000000.0 * (1.0 + this.jitter * (Math.random() * 2.0 - 1.0))));
    }

    @Override
    public boolean isSameAs(@Nullable RetryPolicy other) {
        return this.equals(other);
    }

    @Generated
    public long getInitial() {
        return this.initial;
    }

    @Generated
    public long getMax() {
        return this.max;
    }

    @Generated
    public double getJitter() {
        return this.jitter;
    }

    @Generated
    public double getMultiplier() {
        return this.multiplier;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExponentialBackoffRetryPolicy)) {
            return false;
        }
        ExponentialBackoffRetryPolicy other = (ExponentialBackoffRetryPolicy)o;
        if (this.getInitial() != other.getInitial()) {
            return false;
        }
        if (this.getMax() != other.getMax()) {
            return false;
        }
        if (Double.compare(this.getJitter(), other.getJitter()) != 0) {
            return false;
        }
        return Double.compare(this.getMultiplier(), other.getMultiplier()) == 0;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $initial = this.getInitial();
        result = result * 59 + (int)($initial >>> 32 ^ $initial);
        long $max = this.getMax();
        result = result * 59 + (int)($max >>> 32 ^ $max);
        long $jitter = Double.doubleToLongBits(this.getJitter());
        result = result * 59 + (int)($jitter >>> 32 ^ $jitter);
        long $multiplier = Double.doubleToLongBits(this.getMultiplier());
        result = result * 59 + (int)($multiplier >>> 32 ^ $multiplier);
        return result;
    }

    @Generated
    public String toString() {
        return "ExponentialBackoffRetryPolicy(initial=" + this.getInitial() + ", max=" + this.getMax() + ", jitter=" + this.getJitter() + ", multiplier=" + this.getMultiplier() + ")";
    }
}

