/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.util.lang;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class Annotations {
    private Annotations() {
    }

    @Nullable
    public static <A extends Annotation> A find(Class<A> annotation, @Nonnull AnnotatedElement component) {
        A found = component.getAnnotation(annotation);
        return found != null ? found : Annotations.findInDepth(annotation, component);
    }

    @Nonnull
    private static Set<Annotation> collectAnnotations(Class<?> component) {
        HashSet<Annotation> result = new HashSet<Annotation>();
        HashSet classesToExamine = new HashSet();
        classesToExamine.add(component);
        while (!classesToExamine.isEmpty()) {
            Class candidate = (Class)classesToExamine.iterator().next();
            Annotations.nonJdkAnnotations(candidate.getDeclaredAnnotations()).forEach(result::add);
            if (candidate.getSuperclass() != null && !Annotations.jdkClass(candidate.getSuperclass())) {
                classesToExamine.add(candidate.getSuperclass());
            }
            for (Class<?> in : candidate.getInterfaces()) {
                if (Annotations.jdkClass(in)) continue;
                classesToExamine.add(in);
            }
            classesToExamine.remove(candidate);
        }
        return result;
    }

    @Nullable
    private static <A extends Annotation> A findInDepth(Class<A> annotation, @Nonnull AnnotatedElement component) {
        HashSet<Annotation> visited = new HashSet<Annotation>();
        Set<Annotation> annotationToExamine = Annotations.getAnnotations(component);
        while (!annotationToExamine.isEmpty()) {
            Annotation candidate = annotationToExamine.iterator().next();
            if (visited.add(candidate)) {
                if (candidate.annotationType() == annotation) {
                    return (A)candidate;
                }
                Annotations.nonJdkAnnotations(candidate.annotationType().getDeclaredAnnotations()).forEach(annotationToExamine::add);
            }
            annotationToExamine.remove(candidate);
        }
        return null;
    }

    private static Set<Annotation> getAnnotations(AnnotatedElement component) {
        if (component instanceof Class) {
            Class clazz = (Class)component;
            return Annotations.jdkClass(clazz) ? new HashSet() : Annotations.collectAnnotations(clazz);
        }
        return Annotations.nonJdkAnnotations(component.getAnnotations()).collect(Collectors.toSet());
    }

    private static Stream<Annotation> nonJdkAnnotations(Annotation[] annotations) {
        return Arrays.stream(annotations).filter(da -> !Annotations.jdkClass(da.annotationType()));
    }

    static boolean jdkClass(Class<?> type) {
        return type.getName().startsWith("java.");
    }
}

