/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.util.lang;

import com.google.common.base.Preconditions;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collector;

public final class BetterCollectors {
    private BetterCollectors() {
    }

    public static <T, K, U> Collector<T, ?, Map<K, U>> toMapNullFriendly(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
        return Collector.of(LinkedHashMap::new, (map, elem) -> {
            Object key = keyMapper.apply(elem);
            Preconditions.checkState((!map.containsKey(key) ? 1 : 0) != 0, (String)"Duplicate key: %s", key);
            map.put(key, valueMapper.apply(elem));
        }, (m1, m2) -> {
            for (Map.Entry e : m2.entrySet()) {
                Preconditions.checkState((!m1.containsKey(e.getKey()) ? 1 : 0) != 0, (String)"Duplicate key: %s", e.getKey());
                m1.put(e.getKey(), e.getValue());
            }
            return m1;
        }, Collector.Characteristics.IDENTITY_FINISH);
    }
}

