/*
 * Decompiled with CFR 0.152.
 */
package technology.dice.dicewhere.downloader.source.s3;

import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectResponse;
import technology.dice.dicewhere.downloader.destination.FileAcceptor;
import technology.dice.dicewhere.downloader.exception.DownloaderException;
import technology.dice.dicewhere.downloader.files.FileInfo;
import technology.dice.dicewhere.downloader.files.S3FileInfo;
import technology.dice.dicewhere.downloader.md5.MD5Checksum;
import technology.dice.dicewhere.downloader.source.FileSource;
import technology.dice.dicewhere.downloader.stream.StreamWithMD5Decorator;

public class S3Source
implements FileSource {
    private static Logger LOG = LoggerFactory.getLogger(S3Source.class);
    public static final String TIMESTAMP_METADATA_KEY = "ts";
    private final S3Client client;
    private final String bucket;
    private final String key;
    private FileInfo fileInfo;

    public S3Source(S3Client s3Client, String bucket, String key) {
        this.client = s3Client;
        this.bucket = bucket;
        this.key = key;
    }

    @Override
    public FileInfo fileInfo() {
        if (this.fileInfo == null) {
            HeadObjectRequest headObjectRequest = (HeadObjectRequest)HeadObjectRequest.builder().key(this.key).bucket(this.bucket).build();
            HeadObjectResponse headObjectResponse = this.client.headObject(headObjectRequest);
            if (headObjectResponse.eTag() == null) {
                throw new DownloaderException("Remote file does not have md5 information. Please delete the file and re-upload");
            }
            Map metadata = headObjectResponse.metadata();
            if (!metadata.containsKey(TIMESTAMP_METADATA_KEY)) {
                LOG.warn("Timestamp not available at source. Using now as timestamp.");
            }
            long size = headObjectResponse.contentLength();
            this.fileInfo = new S3FileInfo(this.bucket, this.key, Optional.ofNullable((String)metadata.get(TIMESTAMP_METADATA_KEY)).map(m -> Instant.ofEpochMilli(Long.valueOf(m))).orElse(Instant.now()), MD5Checksum.of(headObjectResponse.eTag().replaceAll("\"", "")), size);
        }
        return this.fileInfo;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public MD5Checksum produce(FileAcceptor consumer, boolean noMd5Check) {
        GetObjectRequest getObjectRequest = (GetObjectRequest)GetObjectRequest.builder().bucket(this.bucket).key(this.key).build();
        try (ResponseInputStream object = this.client.getObject(getObjectRequest);){
            MD5Checksum mD5Checksum;
            block14: {
                StreamWithMD5Decorator is = StreamWithMD5Decorator.of((InputStream)object);
                try {
                    consumer.getStreamConsumer(this.fileInfo.getMd5Checksum(), this.fileInfo.getTimestamp(), noMd5Check).consume(is, this.fileInfo.getSize());
                    mD5Checksum = is.md5();
                    if (is == null) break block14;
                }
                catch (Throwable throwable) {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                is.close();
            }
            return mD5Checksum;
        }
        catch (IOException | NoSuchAlgorithmException e) {
            throw new DownloaderException("Could not read file at " + this.fileInfo.getUri().toString(), e);
        }
    }
}

