/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.css;

import cz.vutbr.web.css.CSSProperty;
import cz.vutbr.web.css.NodeData;
import cz.vutbr.web.css.Term;
import cz.vutbr.web.css.TermList;
import cz.vutbr.web.css.TermPair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class Counters
extends HashMap<String, Integer> {
    private static final long serialVersionUID = 1L;
    private Counters parent;

    public Counters() {
        this.parent = null;
    }

    public Counters(Counters parent) {
        this.parent = parent;
    }

    public Counters getScope(String key) {
        if (this.containsKey(key)) {
            return this;
        }
        if (this.parent != null) {
            return this.parent.getScope(key);
        }
        return null;
    }

    public int getCounter(String key) {
        Counters scope = this.getScope(key);
        return scope == null ? 0 : (Integer)scope.get(key);
    }

    public List<Integer> getCounters(String key) {
        Counters scope = this;
        ArrayList<Integer> ret = new ArrayList<Integer>();
        while (scope != null) {
            if (scope.containsKey(key)) {
                ret.add(0, (Integer)scope.get(key));
            }
            scope = scope.parent;
        }
        return ret;
    }

    public void resetCounter(String key, int value) {
        this.put(key, value);
    }

    public void incrementCounter(String key, int value) {
        Counters scope = this.getScope(key);
        if (scope == null) {
            this.resetCounter(key, 0);
            scope = this;
        }
        scope.put(key, (Integer)scope.get(key) + value);
    }

    public void applyStyle(NodeData style) {
        CSSProperty.CounterIncrement ci;
        CSSProperty.CounterReset cr = (CSSProperty.CounterReset)style.getProperty("counter-reset");
        if (cr == CSSProperty.CounterReset.list_values) {
            TermList terms = (TermList)style.getValue(TermList.class, "counter-reset");
            for (Term term : terms) {
                if (!(term instanceof TermPair)) continue;
                TermPair pair = (TermPair)term;
                this.resetCounter((String)pair.getKey(), (Integer)pair.getValue());
            }
        }
        if ((ci = (CSSProperty.CounterIncrement)style.getProperty("counter-increment")) == CSSProperty.CounterIncrement.list_values) {
            TermList terms = (TermList)style.getValue(TermList.class, "counter-increment");
            for (Term term : terms) {
                if (!(term instanceof TermPair)) continue;
                TermPair pair = (TermPair)term;
                this.incrementCounter((String)pair.getKey(), (Integer)pair.getValue());
            }
        }
    }
}

