/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.css;

import cz.vutbr.web.css.CSSProperty;

public class FontSpec {
    private String family;
    private CSSProperty.FontWeight weight;
    private CSSProperty.FontStyle style;

    public FontSpec(String family, CSSProperty.FontWeight weight, CSSProperty.FontStyle style) {
        this.family = family;
        this.weight = weight;
        this.style = style;
    }

    public String getFamily() {
        return this.family;
    }

    public void setFamily(String family) {
        this.family = family;
    }

    public CSSProperty.FontWeight getWeight() {
        return this.weight;
    }

    public void setWeight(CSSProperty.FontWeight weight) {
        this.weight = weight;
    }

    public CSSProperty.FontStyle getStyle() {
        return this.style;
    }

    public void setStyle(CSSProperty.FontStyle style) {
        this.style = style;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.family == null ? 0 : this.family.toLowerCase().hashCode());
        result = 31 * result + (this.style == null ? 0 : this.style.hashCode());
        result = 31 * result + (this.weight == null ? 0 : this.weight.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FontSpec other = (FontSpec)obj;
        if (this.family == null ? other.family != null : !this.family.toLowerCase().equals(other.family.toLowerCase())) {
            return false;
        }
        if (this.style != other.style) {
            return false;
        }
        return this.weight == other.weight;
    }

    public int match(FontSpec font) {
        if (this.family.equalsIgnoreCase(font.family)) {
            int ret = 100;
            if (this.weight == null) {
                ++ret;
            } else if (FontSpec.representsBold(this.weight) == FontSpec.representsBold(font.weight)) {
                ret += 10;
            }
            if (this.style == null) {
                ++ret;
            } else if (this.style == font.style) {
                ret += 10;
            }
            return ret;
        }
        return 0;
    }

    public static boolean representsBold(CSSProperty.FontWeight weight) {
        return weight == CSSProperty.FontWeight.BOLD || weight == CSSProperty.FontWeight.BOLDER || weight == CSSProperty.FontWeight.numeric_600 || weight == CSSProperty.FontWeight.numeric_700 || weight == CSSProperty.FontWeight.numeric_800 || weight == CSSProperty.FontWeight.numeric_900;
    }
}

