/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.css;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import org.fit.cssbox.css.Output;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NormalOutput
extends Output {
    private boolean filterStyles = true;

    public NormalOutput(Node root) {
        super(root);
    }

    public NormalOutput(Node root, boolean filterStyles) {
        super(root);
        this.filterStyles = filterStyles;
    }

    @Override
    public void dumpTo(OutputStream out) {
        PrintWriter writer = new PrintWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8));
        this.recursiveDump(this.root, 0, writer);
        writer.close();
    }

    @Override
    public void dumpTo(PrintWriter writer) {
        this.recursiveDump(this.root, 0, writer);
    }

    private void recursiveDump(Node n, int level, PrintWriter p) {
        if (n.getNodeType() == 1) {
            Object tag = "";
            Element el = (Element)n;
            if (this.filterStyles) {
                if (el.getTagName().equals("style")) {
                    return;
                }
                if (el.getTagName().equals("link") && ("stylesheet".equalsIgnoreCase(el.getAttribute("rel")) || "text/css".equalsIgnoreCase(el.getAttribute("type")))) {
                    return;
                }
            }
            if (el.getTagName().equals("meta") && "generator".equalsIgnoreCase(el.getAttribute("name"))) {
                el.setAttribute("content", "CSS Transformer by Radek Burget, burgetr@fit.vutbr.cz");
            }
            if (el.getTagName().equals("meta") && "content-type".equalsIgnoreCase(el.getAttribute("http-equiv"))) {
                el.setAttribute("content", "text/html; charset=utf-8");
            }
            tag = (String)tag + "<" + el.getTagName();
            NamedNodeMap attrs = el.getAttributes();
            for (int i = 0; i < attrs.getLength(); ++i) {
                Node attr = attrs.item(i);
                tag = (String)tag + " " + attr.getNodeName() + "=\"" + attr.getNodeValue() + "\"";
            }
            tag = (String)tag + ">";
            p.print((String)tag);
        } else if (n.getNodeType() == 3) {
            p.print(n.getNodeValue());
        } else if (n.getNodeType() == 8) {
            p.print("<!--");
            p.print(n.getNodeValue());
            p.print("-->");
        }
        NodeList child = n.getChildNodes();
        for (int i = 0; i < child.getLength(); ++i) {
            this.recursiveDump(child.item(i), level + 1, p);
        }
        if (n.getNodeType() == 1) {
            p.print("</" + n.getNodeName() + ">");
        }
    }

    private void recursiveDumpNice(Node n, int level, PrintWriter p) {
        if (n.getNodeType() == 1) {
            Object tag = "";
            Element el = (Element)n;
            if (el.getTagName().equals("style")) {
                return;
            }
            tag = (String)tag + "<" + el.getTagName();
            NamedNodeMap attrs = el.getAttributes();
            for (int i = 0; i < attrs.getLength(); ++i) {
                Node attr = attrs.item(i);
                tag = (String)tag + " " + attr.getNodeName() + "=\"" + attr.getNodeValue() + "\"";
            }
            tag = (String)tag + ">";
            this.indent(level, p);
            p.println((String)tag);
        } else if (n.getNodeType() == 3) {
            this.indent(level, p);
            p.println(n.getNodeValue());
        } else if (n.getNodeType() == 8) {
            this.indent(level, p);
            p.print("<!--");
            p.print(n.getNodeValue());
            p.print("-->");
        }
        NodeList child = n.getChildNodes();
        for (int i = 0; i < child.getLength(); ++i) {
            this.recursiveDumpNice(child.item(i), level + 1, p);
        }
        if (n.getNodeType() == 1) {
            this.indent(level, p);
            p.println("</" + n.getNodeName() + ">");
        }
    }

    private void indent(int level, PrintWriter p) {
        Object ind = "";
        for (int i = 0; i < level * 4; ++i) {
            ind = (String)ind + " ";
        }
        p.print((String)ind);
    }
}

