/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.layout;

import cz.vutbr.web.css.CSSProperty;
import cz.vutbr.web.css.NodeData;
import java.awt.Dimension;
import java.awt.Graphics2D;
import org.fit.cssbox.css.HTMLNorm;
import org.fit.cssbox.layout.Box;
import org.fit.cssbox.layout.CSSDecoder;
import org.fit.cssbox.layout.ElementBox;
import org.fit.cssbox.layout.Inline;
import org.fit.cssbox.layout.InlineElement;
import org.fit.cssbox.layout.LengthSet;
import org.fit.cssbox.layout.LineBox;
import org.fit.cssbox.layout.VisualContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class InlineBox
extends ElementBox
implements InlineElement {
    private static final Logger LOG = LoggerFactory.getLogger(InlineBox.class);
    private CSSProperty.VerticalAlign valign;
    private LineBox linebox;
    private LineBox curline;
    private int halflead = 0;
    private int minDescendantY;
    private int maxDescendantY;
    protected boolean lineBreakStop = false;
    protected boolean collapsedCompletely = false;

    public InlineBox(Element n, Graphics2D g, VisualContext ctx) {
        super(n, g, ctx);
    }

    public void copyValues(InlineBox src) {
        super.copyValues(src);
        this.valign = src.valign;
    }

    @Override
    public InlineBox copyBox() {
        InlineBox ret = new InlineBox(this.el, this.g, this.ctx);
        ret.copyValues(this);
        return ret;
    }

    public String toString() {
        return "<" + this.el.getTagName() + " id=\"" + HTMLNorm.getAttribute(this.el, "id") + "\" class=\"" + HTMLNorm.getAttribute(this.el, "class") + "\">";
    }

    @Override
    public void setStyle(NodeData s) {
        super.setStyle(s);
        this.loadInlineStyle();
    }

    @Override
    public CSSProperty.VerticalAlign getVerticalAlign() {
        return this.valign;
    }

    @Override
    public void setLineBox(LineBox linebox) {
        this.linebox = linebox;
        for (int i = this.startChild; i < this.endChild; ++i) {
            Box sub = this.getSubBox(i);
            if (!(sub instanceof InlineElement)) continue;
            ((InlineElement)((Object)sub)).setLineBox(linebox);
        }
    }

    @Override
    public LineBox getLineBox() {
        return this.linebox;
    }

    @Override
    public int getBaselineOffset() {
        if (this.curline == null) {
            return 0;
        }
        return this.curline.getBaselineOffset();
    }

    @Override
    public int getBelowBaseline() {
        if (this.curline == null) {
            return 0;
        }
        return this.curline.getBelowBaseline();
    }

    @Override
    public int getTotalLineHeight() {
        if (this.curline == null) {
            return 0;
        }
        return this.curline.getTotalLineHeight();
    }

    @Override
    public int getMaxLineHeight() {
        if (this.curline == null) {
            return this.lineHeight;
        }
        return Math.max(this.lineHeight, this.curline.getMaxBoxHeight());
    }

    @Override
    public int getLineboxOffset() {
        if (this.curline == null) {
            return 0;
        }
        return this.curline.getBaselineOffset() - this.ctx.getBaselineOffset() - this.halflead;
    }

    @Override
    public int getHalfLead() {
        return this.halflead;
    }

    @Override
    public int getFirstLineLength() {
        if (this.preservesLineBreaks()) {
            if (this.endChild > this.startChild) {
                return ((Inline)((Object)this.getSubBox(this.startChild))).getFirstLineLength();
            }
            return 0;
        }
        int ret = 0;
        for (int i = this.startChild; i < this.endChild; ++i) {
            ret += this.getSubBox(i).getMaximalWidth();
        }
        return ret;
    }

    @Override
    public int getLastLineLength() {
        if (this.preservesLineBreaks()) {
            if (this.endChild > this.startChild) {
                return ((Inline)((Object)this.getSubBox(this.endChild - 1))).getLastLineLength();
            }
            return 0;
        }
        int ret = 0;
        for (int i = this.startChild; i < this.endChild; ++i) {
            ret += this.getSubBox(i).getMaximalWidth();
        }
        return ret;
    }

    @Override
    public boolean containsLineBreak() {
        for (int i = this.startChild; i < this.endChild; ++i) {
            if (!((Inline)((Object)this.getSubBox(i))).containsLineBreak()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean finishedByLineBreak() {
        return this.lineBreakStop;
    }

    @Override
    public boolean collapsedCompletely() {
        return this.collapsedCompletely;
    }

    @Override
    public int getWidthExpansionPoints(boolean atLineStart, boolean atLineEnd) {
        return this.countInlineExpansionPoints(this.startChild, this.endChild, atLineStart, atLineEnd);
    }

    @Override
    public void extendWidth(int dif, boolean atLineStart, boolean atLineEnd) {
        this.extendInlineChildWidths(dif, this.startChild, this.endChild, atLineStart, atLineEnd);
        this.bounds.width += dif;
        this.content.width += dif;
    }

    public int getMinDescendantY() {
        return this.minDescendantY;
    }

    public int getMaxDescendantY() {
        return this.minDescendantY;
    }

    @Override
    public boolean isInFlow() {
        return true;
    }

    @Override
    public boolean containsFlow() {
        return !this.isempty;
    }

    @Override
    public boolean mayContainBlocks() {
        return false;
    }

    @Override
    public boolean doLayout(int availw, boolean force, boolean linestart) {
        if (!this.displayed) {
            this.content.setSize(0, 0);
            this.bounds.setSize(0, 0);
            return true;
        }
        this.setAvailableWidth(availw);
        this.curline = new LineBox(this, this.startChild, 0);
        int wlimit = this.getAvailableContentWidth();
        int x = 0;
        boolean ret = true;
        this.rest = null;
        int lastbreak = this.startChild;
        this.collapsedCompletely = true;
        for (int i = this.startChild; i < this.endChild; ++i) {
            boolean f;
            boolean fit;
            Box subbox = this.getSubBox(i);
            if (subbox.canSplitBefore()) {
                lastbreak = i;
            }
            if (fit = subbox.doLayout(wlimit - x, f = force && (i == this.startChild || lastbreak == this.startChild), linestart && i == this.startChild)) {
                if (subbox instanceof Inline) {
                    subbox.setPosition(x, 0);
                    x += subbox.getWidth();
                    this.curline.considerBox((Inline)((Object)subbox));
                    if (((Inline)((Object)subbox)).finishedByLineBreak()) {
                        this.lineBreakStop = true;
                    }
                    if (!((Inline)((Object)subbox)).collapsedCompletely()) {
                        this.collapsedCompletely = false;
                    }
                } else if (LOG.isDebugEnabled()) {
                    LOG.atDebug().log("Warning: doLayout(): subbox is not inline: " + subbox);
                }
                if (subbox.getRest() != null) {
                    InlineBox rbox = this.copyBox();
                    rbox.splitted = true;
                    rbox.splitid = this.splitid + 1;
                    rbox.setStartChild(i);
                    rbox.nested.setElementAt(subbox.getRest(), i);
                    rbox.adoptChildren();
                    this.setEndChild(i + 1);
                    this.rest = rbox;
                    break;
                }
                if (this.lineBreakStop) {
                    if (i + 1 >= this.endChild) break;
                    InlineBox rbox = this.copyBox();
                    rbox.splitted = true;
                    rbox.splitid = this.splitid + 1;
                    rbox.setStartChild(i + 1);
                    rbox.adoptChildren();
                    this.setEndChild(i + 1);
                    this.rest = rbox;
                    break;
                }
            } else {
                if (lastbreak == this.startChild) {
                    ret = false;
                    break;
                }
                InlineBox rbox = this.copyBox();
                rbox.splitted = true;
                rbox.splitid = this.splitid + 1;
                rbox.setStartChild(lastbreak);
                rbox.adoptChildren();
                this.setEndChild(lastbreak);
                this.rest = rbox;
                break;
            }
            if (!subbox.canSplitAfter()) continue;
            lastbreak = i + 1;
        }
        this.content.width = x;
        this.content.height = this.ctx.getFontHeight();
        this.halflead = (this.content.height - this.ctx.getFontHeight()) / 2;
        this.alignBoxes();
        this.setSize(this.totalWidth(), this.totalHeight());
        return ret;
    }

    @Override
    public void absolutePositions() {
        this.updateStackingContexts();
        if (this.isDisplayed()) {
            this.absbounds.x = this.getParent().getAbsoluteContentX() + this.bounds.x;
            if (this.valign == CSSProperty.VerticalAlign.TOP) {
                int topOfs = Math.min(this.minDescendantY, 0);
                this.absbounds.y = this.linebox.getAbsoluteY() - this.getContentOffsetY() - topOfs;
            } else if (this.valign == CSSProperty.VerticalAlign.BOTTOM) {
                int bottomOfs = this.maxDescendantY >= this.getContentHeight() ? this.maxDescendantY - this.getContentHeight() + 1 : 0;
                this.absbounds.y = this.linebox.getAbsoluteY() + this.linebox.getMaxBoxHeight() - this.getContentHeight() - this.getContentOffsetY() - bottomOfs;
            } else {
                this.absbounds.y = this.getParent().getAbsoluteContentY() + this.bounds.y;
            }
            if (this.position == POS_RELATIVE) {
                this.absbounds.x = this.absbounds.x + (this.leftset ? this.coords.left : -this.coords.right);
                this.absbounds.y = this.absbounds.y + (this.topset ? this.coords.top : -this.coords.bottom);
            }
            this.absbounds.width = this.bounds.width;
            this.absbounds.height = this.bounds.height;
            for (int i = this.startChild; i < this.endChild; ++i) {
                this.getSubBox(i).absolutePositions();
            }
        }
    }

    @Override
    public int getMinimalWidth() {
        int ret = 0;
        if (this.allowsWrapping()) {
            for (int i = this.startChild; i < this.endChild; ++i) {
                int w = this.getSubBox(i).getMinimalWidth();
                if (w <= ret) continue;
                ret = w;
            }
        } else if (this.preservesLineBreaks()) {
            int total = 0;
            for (int i = this.startChild; i < this.endChild; ++i) {
                Box cur = this.getSubBox(i);
                int w = cur.getMinimalWidth();
                if (w > ret) {
                    ret = w;
                }
                if ((total += ((Inline)((Object)cur)).getFirstLineLength()) > ret) {
                    ret = total;
                }
                if (((Inline)((Object)cur)).containsLineBreak()) {
                    total = 0;
                }
                total += ((Inline)((Object)cur)).getLastLineLength();
            }
        } else {
            for (int i = this.startChild; i < this.endChild; ++i) {
                ret += this.getSubBox(i).getMaximalWidth();
            }
        }
        return ret += this.margin.left + this.padding.left + this.border.left + this.margin.right + this.padding.right + this.border.right;
    }

    @Override
    public int getMaximalWidth() {
        int ret = 0;
        if (!this.preservesLineBreaks()) {
            for (int i = this.startChild; i < this.endChild; ++i) {
                ret += this.getSubBox(i).getMaximalWidth();
            }
        } else {
            int total = 0;
            for (int i = this.startChild; i < this.endChild; ++i) {
                Box cur = this.getSubBox(i);
                int w = cur.getMaximalWidth();
                if (w > ret) {
                    ret = w;
                }
                if ((total += ((Inline)((Object)cur)).getFirstLineLength()) > ret) {
                    ret = total;
                }
                if (((Inline)((Object)cur)).containsLineBreak()) {
                    total = 0;
                }
                total += ((Inline)((Object)cur)).getLastLineLength();
            }
        }
        return ret += this.margin.left + this.padding.left + this.border.left + this.margin.right + this.padding.right + this.border.right;
    }

    public int getMaximalHeight() {
        int ret = this.getHeight();
        for (int i = this.startChild; i < this.endChild; ++i) {
            Box sub = this.getSubBox(i);
            int h = sub instanceof InlineBox ? ((InlineBox)sub).getMaximalHeight() : sub.getHeight();
            if (h <= ret) continue;
            ret = h;
        }
        return ret;
    }

    @Override
    public boolean canSplitInside() {
        for (int i = this.startChild; i < this.endChild; ++i) {
            if (!this.getSubBox(i).canSplitInside()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canSplitBefore() {
        return this.endChild > this.startChild && this.getSubBox(this.startChild).canSplitBefore();
    }

    @Override
    public boolean canSplitAfter() {
        return this.endChild > this.startChild && this.getSubBox(this.endChild - 1).canSplitAfter();
    }

    @Override
    public boolean startsWithWhitespace() {
        return this.endChild > this.startChild && this.getSubBox(this.startChild).startsWithWhitespace();
    }

    @Override
    public boolean endsWithWhitespace() {
        return this.endChild > this.startChild && this.getSubBox(this.endChild - 1).endsWithWhitespace();
    }

    @Override
    public void setIgnoreInitialWhitespace(boolean b) {
        if (this.endChild > this.startChild) {
            this.getSubBox(this.startChild).setIgnoreInitialWhitespace(b);
        }
    }

    @Override
    public void draw(Box.DrawStage turn) {
        this.ctx.updateGraphics(this.g);
        if (this.displayed && !this.formsStackingContext()) {
            switch (turn) {
                case DRAW_NONINLINE: 
                case DRAW_FLOAT: {
                    break;
                }
                case DRAW_INLINE: {
                    if (!this.isVisible()) break;
                    this.getViewport().getRenderer().renderElementBackground(this);
                    this.getViewport().getRenderer().startElementContents(this);
                    this.drawChildren(turn);
                    this.getViewport().getRenderer().finishElementContents(this);
                }
            }
        }
    }

    @Override
    public void drawExtent(Graphics2D g) {
        super.drawExtent(g);
    }

    @Override
    public int totalHeight() {
        return this.border.top + this.padding.top + this.content.height + this.padding.bottom + this.border.bottom;
    }

    protected void loadInlineStyle() {
        this.valign = (CSSProperty.VerticalAlign)this.style.getProperty("vertical-align");
        if (this.valign == null) {
            this.valign = CSSProperty.VerticalAlign.BASELINE;
        }
    }

    @Override
    protected void loadSizes() {
        CSSDecoder dec = new CSSDecoder(this.ctx);
        int contw = this.getContainingBlock().width;
        this.margin = new LengthSet();
        this.margin.right = dec.getLength(this.getLengthValue("margin-right"), this.style.getProperty("margin-right") == CSSProperty.Margin.AUTO, 0, 0, contw);
        this.margin.left = dec.getLength(this.getLengthValue("margin-left"), this.style.getProperty("margin-left") == CSSProperty.Margin.AUTO, 0, 0, contw);
        this.emargin = new LengthSet(this.margin);
        this.loadBorders(dec, contw);
        this.padding = new LengthSet();
        this.padding.top = dec.getLength(this.getLengthValue("padding-top"), false, null, null, contw);
        this.padding.right = dec.getLength(this.getLengthValue("padding-right"), false, null, null, contw);
        this.padding.bottom = dec.getLength(this.getLengthValue("padding-bottom"), false, null, null, contw);
        this.padding.left = dec.getLength(this.getLengthValue("padding-left"), false, null, null, contw);
        this.content = new Dimension(0, 0);
        this.loadPosition();
    }

    @Override
    public void updateSizes() {
    }

    @Override
    public boolean hasFixedWidth() {
        return false;
    }

    @Override
    public boolean hasFixedHeight() {
        return false;
    }

    @Override
    public void computeEfficientMargins() {
        this.emargin.top = this.margin.top;
        this.emargin.bottom = this.margin.bottom;
    }

    @Override
    public boolean marginsAdjoin() {
        if (this.padding.top > 0 || this.padding.bottom > 0 || this.border.top > 0 || this.border.bottom > 0) {
            return false;
        }
        for (int i = this.startChild; i < this.endChild; ++i) {
            Box box = this.getSubBox(i);
            if (!(box instanceof ElementBox ? !((ElementBox)box).marginsAdjoin() : !box.isWhitespace())) continue;
            return false;
        }
        return true;
    }

    private void alignBoxes() {
        for (int i = this.startChild; i < this.endChild; ++i) {
            int dy;
            int dy2;
            Box sub = this.getSubBox(i);
            if (sub.isBlock()) continue;
            int dif = this.curline.alignBox((Inline)((Object)sub));
            dif -= this.getLineboxOffset();
            if (sub instanceof InlineBox) {
                dif -= ((ElementBox)sub).getContentOffsetY();
            }
            if (dif != 0) {
                sub.moveDown(dif);
            }
            int y1 = sub.getContentY();
            if (sub instanceof InlineBox && (dy2 = ((InlineBox)sub).getMinDescendantY()) < 0) {
                y1 += dy2;
            }
            this.minDescendantY = Math.min(this.minDescendantY, y1);
            int y2 = sub.getContentY() + sub.getContentHeight() - 1;
            if (sub instanceof InlineBox && (dy = ((InlineBox)sub).getMaxDescendantY()) > sub.getContentHeight()) {
                y2 += dy;
            }
            this.maxDescendantY = Math.max(this.maxDescendantY, y2);
        }
    }
}

