/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.layout;

import cz.vutbr.web.css.CSSProperty;
import cz.vutbr.web.css.NodeData;
import cz.vutbr.web.css.TermURI;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import org.fit.cssbox.layout.BlockBox;
import org.fit.cssbox.layout.Box;
import org.fit.cssbox.layout.ElementBox;
import org.fit.cssbox.layout.InlineBox;
import org.fit.cssbox.layout.ReplacedImage;
import org.fit.cssbox.layout.VisualContext;
import org.w3c.dom.Element;

public class ListItemBox
extends BlockBox {
    private static final String[] RCODE = new String[]{"M", "CM", "D", "CD", "C", "XC", "L", "XL", "X", "IX", "V", "IV", "I"};
    private static final int[] BVAL = new int[]{1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1};
    private CSSProperty.ListStyleType styleType;
    private int itemNumber;
    private ReplacedImage image;

    public ListItemBox(Element n, Graphics2D g, VisualContext ctx) {
        super(n, g, ctx);
        this.isblock = true;
    }

    @Override
    public void initBox() {
        super.initBox();
        this.itemNumber = this.findItemNumber();
        this.initFirstLine(this);
    }

    public ListItemBox(InlineBox src) {
        super(src);
        this.isblock = true;
    }

    @Override
    public void setStyle(NodeData s) {
        super.setStyle(s);
        this.styleType = (CSSProperty.ListStyleType)this.style.getProperty("list-style-type");
        if (this.styleType == null) {
            this.styleType = CSSProperty.ListStyleType.DISC;
        }
        this.image = this.loadMarkerImage(s);
    }

    private ReplacedImage loadMarkerImage(NodeData style) {
        CSSProperty.ListStyleImage img = (CSSProperty.ListStyleImage)style.getProperty("list-style-image");
        if (img == CSSProperty.ListStyleImage.uri) {
            TermURI urlstring = (TermURI)style.getValue(TermURI.class, "list-style-image");
            ReplacedImage bgimg = new ReplacedImage(this, this.ctx, urlstring.getBase(), (String)urlstring.getValue());
            return bgimg;
        }
        return null;
    }

    @Override
    public void draw(Box.DrawStage turn) {
        if (this.displayed && this.isDeclaredVisible()) {
            if (turn == Box.DrawStage.DRAW_INLINE && this.floating == FLOAT_NONE && this.position == POS_STATIC) {
                this.getViewport().getRenderer().renderMarker(this);
            }
            super.draw(turn);
        }
    }

    public boolean hasVisibleBullet() {
        return this.styleType != CSSProperty.ListStyleType.NONE;
    }

    public String getListStyleType() {
        return this.styleType.toString();
    }

    public ReplacedImage getMarkerImage() {
        return this.image;
    }

    public int getItemNumber() {
        return this.itemNumber;
    }

    public String getMarkerText() {
        String text = ListItemBox.formatItemNumber(this.itemNumber, this.styleType);
        return text + ". ";
    }

    public static String formatItemNumber(int itemNumber, CSSProperty.ListStyleType styleType) {
        Object text;
        block9: {
            block8: {
                if (itemNumber <= 0) break block8;
                switch (styleType) {
                    case UPPER_ALPHA: {
                        text = "";
                        while (itemNumber > 0) {
                            text = String.valueOf((char)(65 + (itemNumber - 1) % 26)) + (String)text;
                            itemNumber = (itemNumber - 1) / 26;
                        }
                        break block9;
                    }
                    case LOWER_ALPHA: {
                        text = "";
                        while (itemNumber > 0) {
                            text = String.valueOf((char)(97 + (itemNumber - 1) % 26)) + (String)text;
                            itemNumber = (itemNumber - 1) / 26;
                        }
                        break block9;
                    }
                    case UPPER_ROMAN: {
                        text = ListItemBox.binaryToRoman(itemNumber);
                        break;
                    }
                    case LOWER_ROMAN: {
                        text = ListItemBox.binaryToRoman(itemNumber).toLowerCase();
                        break;
                    }
                    default: {
                        text = String.valueOf(itemNumber);
                        break;
                    }
                }
                break block9;
            }
            text = String.valueOf(itemNumber);
        }
        return text;
    }

    private int findItemNumber() {
        ElementBox parent = this.getParent();
        int cnt = 0;
        for (int i = parent.getStartChild(); i < parent.getEndChild(); ++i) {
            Box child = parent.getSubBox(i);
            if (child instanceof ListItemBox) {
                ++cnt;
            }
            if (child != this) continue;
            return cnt;
        }
        return 1;
    }

    public void drawMarker(Graphics2D g) {
        Shape oldclip = g.getClip();
        if (this.clipblock != null) {
            g.setClip(this.applyClip(oldclip, this.clipblock.getClippedContentBounds()));
        }
        if (this.image != null) {
            if (!this.drawImage(g)) {
                this.drawBullet(g);
            }
        } else {
            this.drawBullet(g);
        }
        g.setClip(oldclip);
    }

    protected void drawBullet(Graphics2D g) {
        this.ctx.updateGraphics(g);
        int x = (int)Math.round((double)this.getAbsoluteContentX() - 1.2 * this.ctx.getEm());
        int y = (int)Math.round((double)this.getAbsoluteContentY() + 0.5 * this.ctx.getEm());
        int r = (int)Math.round(0.4 * this.ctx.getEm());
        if (this.styleType == CSSProperty.ListStyleType.CIRCLE) {
            g.drawOval(x, y, r, r);
        } else if (this.styleType == CSSProperty.ListStyleType.SQUARE) {
            g.fillRect(x, y, r, r);
        } else if (this.styleType == CSSProperty.ListStyleType.DISC) {
            g.fillOval(x, y, r, r);
        } else if (this.styleType != CSSProperty.ListStyleType.NONE) {
            this.drawText(g, this.getMarkerText());
        }
    }

    protected boolean drawImage(Graphics2D g) {
        int ofs = this.getFirstInlineBoxBaseline();
        if (ofs == -1) {
            ofs = this.ctx.getBaselineOffset();
        }
        int x = (int)Math.round((double)this.getAbsoluteContentX() - 0.5 * this.ctx.getEm());
        int y = this.getAbsoluteContentY() + ofs;
        Image img = this.image.getImage();
        if (img != null) {
            int w = img.getWidth(this.image);
            int h = img.getHeight(this.image);
            g.drawImage(img, x - w, y - h, this.image);
            return true;
        }
        return false;
    }

    protected void drawText(Graphics2D g, String text) {
        int x = this.getAbsoluteContentX();
        int y = this.getAbsoluteContentY();
        FontMetrics fm = g.getFontMetrics();
        Rectangle2D rect = fm.getStringBounds(text, g);
        int ofs = this.getFirstInlineBoxBaseline();
        if (ofs == -1) {
            ofs = this.ctx.getBaselineOffset();
        }
        g.drawString(text, x + (int)rect.getX() - (int)Math.round(rect.getWidth()), y + ofs);
    }

    private static String binaryToRoman(int binary) {
        if (binary <= 0 || binary >= 4000) {
            throw new NumberFormatException("Value outside roman numeral range.");
        }
        Object roman = "";
        for (int i = 0; i < RCODE.length; ++i) {
            while (binary >= BVAL[i]) {
                binary -= BVAL[i];
                roman = (String)roman + RCODE[i];
            }
        }
        return roman;
    }
}

