/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.layout;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.net.MalformedURLException;
import java.net.URL;
import org.fit.cssbox.layout.ContentImage;
import org.fit.cssbox.layout.ElementBox;
import org.fit.cssbox.layout.VisualContext;
import org.fit.net.DataURLHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplacedImage
extends ContentImage {
    private static final Logger LOG = LoggerFactory.getLogger(ReplacedImage.class);
    protected final int DEFAULT_IMAGE_WIDTH = 20;
    protected final int DEFAULT_IMAGE_HEIGHT = 20;
    protected URL base;
    protected VisualContext ctx;

    public ReplacedImage(ElementBox owner, VisualContext ctx, URL baseurl, String src) {
        super(owner);
        this.ctx = ctx;
        this.loadImages = owner.getViewport().getConfig().getLoadImages();
        this.base = baseurl;
        try {
            this.url = DataURLHandler.createURL((URL)this.base, (String)src);
            if (this.loadImages && !src.trim().isEmpty()) {
                this.image = this.loadImage(this.caching);
            }
        }
        catch (MalformedURLException e) {
            LOG.error("URL: {}", (Object)e.getMessage());
            this.image = null;
            this.url = null;
        }
        catch (IllegalArgumentException e) {
            LOG.error("Format error: {}", (Object)e.getMessage());
            this.image = null;
        }
    }

    @Override
    public void draw(Graphics2D g, int width, int height) {
        Rectangle bounds = this.getOwner().getAbsoluteContentBounds();
        if (this.image != null) {
            this.ctx.updateGraphics(g);
            if (this.container == null) {
                this.waitForLoad();
            }
            g.drawImage(this.image, bounds.x, bounds.y, width, height, this.observer);
        } else {
            this.ctx.updateGraphics(g);
            g.setStroke(new BasicStroke(1.0f));
            g.drawRect(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1);
        }
    }

    public String toString() {
        return "ReplacedImage [url=" + this.url + "]";
    }
}

