/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.layout;

import java.awt.Graphics2D;
import java.util.Iterator;
import java.util.Vector;
import org.fit.cssbox.layout.BlockBox;
import org.fit.cssbox.layout.Box;
import org.fit.cssbox.layout.CSSDecoder;
import org.fit.cssbox.layout.ElementBox;
import org.fit.cssbox.layout.InlineBox;
import org.fit.cssbox.layout.LengthSet;
import org.fit.cssbox.layout.TableBox;
import org.fit.cssbox.layout.TableCellBox;
import org.fit.cssbox.layout.TableColumn;
import org.fit.cssbox.layout.TableRowBox;
import org.fit.cssbox.layout.VisualContext;
import org.w3c.dom.Element;

public class TableBodyBox
extends BlockBox {
    protected TableBox ownerTable;
    protected Vector<TableRowBox> rows;
    protected int numCols;
    protected TableCellBox[][] cells;
    protected int spacing = 2;

    public TableBodyBox(Element n, Graphics2D g, VisualContext ctx) {
        super(n, g, ctx);
        this.isblock = true;
        this.rows = new Vector();
    }

    public TableBodyBox(InlineBox src) {
        super(src);
        this.isblock = true;
        this.rows = new Vector();
    }

    public void addRow(TableRowBox row) {
        this.rows.add(row);
        row.setOwnerBody(this);
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public int getColumnCount() {
        return this.numCols;
    }

    public TableRowBox getRow(int index) {
        return this.rows.elementAt(index);
    }

    public void setSpacing(int spacing) {
        this.spacing = spacing;
    }

    public TableBox getOwnerTable() {
        return this.ownerTable;
    }

    public void setOwnerTable(TableBox ownerTable) {
        this.ownerTable = ownerTable;
    }

    @Override
    public int getMaximalWidth() {
        int sum = this.spacing;
        for (int i = 0; i < this.numCols; ++i) {
            sum += this.getMaximalColumnWidth(i) + this.spacing;
        }
        return sum;
    }

    @Override
    public int getMinimalWidth() {
        int sum = this.spacing;
        for (int i = 0; i < this.numCols; ++i) {
            sum += this.getMinimalColumnWidth(i) + this.spacing;
        }
        return sum;
    }

    public int getMinimalColumnWidth(int col) {
        int ret = 0;
        int r = 0;
        while (r < this.getRowCount()) {
            TableCellBox cell = this.cells[col][r];
            if (cell != null) {
                int min = cell.getMinimalWidth() / cell.getColspan();
                if (min > ret) {
                    ret = min;
                }
                r += cell.getRowspan();
                continue;
            }
            ++r;
        }
        return ret;
    }

    public int getMaximalColumnWidth(int col) {
        int ret = 0;
        int r = 0;
        while (r < this.getRowCount()) {
            TableCellBox cell = this.cells[col][r];
            if (cell != null) {
                int max = cell.getMaximalWidth() / cell.getColspan();
                if (max > ret) {
                    ret = max;
                }
                r += cell.getRowspan();
                continue;
            }
            ++r;
        }
        return ret;
    }

    public void updateColumn(int c, TableColumn col) {
        int r = 0;
        while (r < this.getRowCount()) {
            TableCellBox cell = this.cells[c][r];
            if (cell != null) {
                int max;
                cell.setOwnerColumn(col);
                int min = cell.getMinimalWidth() / cell.getColspan();
                if (min > col.getMinimalWidth()) {
                    col.setMinimalWidth(min);
                }
                if ((max = cell.getMaximalWidth() / cell.getColspan()) > col.getMaximalWidth()) {
                    col.setMaximalWidth(max);
                }
                if (cell.wset) {
                    col.wset = true;
                    if (cell.isRelative()) {
                        col.setRelative(true);
                        if (col.percent < cell.percent) {
                            col.percent = cell.percent;
                        }
                    } else if (cell.getContentWidth() > col.abswidth) {
                        col.abswidth = cell.getContentWidth();
                    }
                }
                if (col.getWidth() < col.getMinimalWidth()) {
                    col.setColumnWidth(col.getMinimalWidth());
                }
                r += cell.getRowspan();
                continue;
            }
            ++r;
        }
    }

    @Override
    public void initBox() {
        this.organizeContent();
        this.calcOffsets();
    }

    @Override
    public boolean doLayout(int widthlimit, boolean force, boolean linestart) {
        return true;
    }

    public boolean doLayout(int widthlimit, Vector<TableColumn> columns) {
        this.setAvailableWidth(widthlimit);
        int y = this.spacing;
        int x = this.spacing;
        int maxw = 0;
        int maxh = 0;
        int wlimit = this.getAvailableContentWidth();
        int[] rowY = new int[this.getRowCount()];
        for (int r = 0; r < this.getRowCount(); ++r) {
            TableRowBox row = this.getRow(r);
            x = this.spacing;
            maxh = 0;
            int c = 0;
            while (c < this.getColumnCount()) {
                TableCellBox cell = this.cells[c][r];
                if (cell != null) {
                    int ch;
                    int firstrow = cell.getRow();
                    int lastrow = cell.getRow() + cell.getRowspan() - 1;
                    int cw = columns.elementAt(c).getWidth();
                    for (int i = 1; i < cell.getColspan(); ++i) {
                        cw += this.spacing + columns.elementAt(c + i).getWidth();
                    }
                    cell.setWidth(cw);
                    if (r == firstrow) {
                        cell.doLayout(wlimit, true, true);
                        cell.setPosition(x, 0);
                        if (cell.getRowspan() == 1 && (ch = cell.getHeight()) > maxh) {
                            maxh = ch;
                        }
                    } else if (r < lastrow) {
                        if (cell.getRowspan() == 1 && (ch = cell.getHeight()) > maxh) {
                            maxh = ch;
                        }
                    } else if (r == lastrow) {
                        int startY = rowY[cell.getRow()];
                        int remain = cell.getHeight() - (y - startY);
                        if (remain > maxh) {
                            maxh = remain;
                        }
                    }
                    x += cw + this.spacing;
                    c += cell.getColspan();
                    continue;
                }
                ++c;
            }
            int baseline = 0;
            c = 0;
            while (c < this.getColumnCount()) {
                TableCellBox cell = this.cells[c][r];
                if (cell != null) {
                    int cbase;
                    if (cell.getRow() == r && (cbase = cell.getFirstInlineBoxBaseline()) > baseline) {
                        baseline = cbase;
                    }
                    c += cell.getColspan();
                    continue;
                }
                ++c;
            }
            c = 0;
            while (c < this.getColumnCount()) {
                TableCellBox cell = this.cells[c][r];
                if (cell != null) {
                    if (cell.getRow() + cell.getRowspan() - 1 == r) {
                        int startY = cell.getRowspan() > 1 ? rowY[cell.getRow()] : y;
                        int oldheight = cell.getHeight();
                        int newheight = y + maxh - startY;
                        cell.setHeight(newheight);
                        cell.applyVerticalAlign(oldheight, newheight, baseline);
                    }
                    c += cell.getColspan();
                    continue;
                }
                ++c;
            }
            rowY[r] = y;
            row.setPosition(0, y);
            row.content.width = x;
            row.content.height = maxh;
            row.setSize(row.totalWidth(), row.totalHeight());
            if (x > maxw) {
                maxw = x;
            }
            y += maxh + this.spacing;
        }
        this.content.width = maxw;
        this.content.height = y;
        this.setSize(this.totalWidth(), this.totalHeight());
        return true;
    }

    @Override
    public void drawBackground(Graphics2D g) {
    }

    @Override
    protected void loadPadding(CSSDecoder dec, int contw) {
        this.padding = new LengthSet();
    }

    private void organizeContent() {
        BlockBox anonrow = null;
        Iterator it = this.nested.iterator();
        while (it.hasNext()) {
            Box box = (Box)it.next();
            if (box instanceof ElementBox && ((ElementBox)box).getDisplay() == ElementBox.DISPLAY_TABLE_ROW) {
                this.addRow((TableRowBox)box);
                if (anonrow != null) {
                    ((TableRowBox)anonrow).endChild = ((TableRowBox)anonrow).nested.size();
                    this.addSubBox(anonrow);
                }
                anonrow = null;
                continue;
            }
            if (anonrow == null) {
                Element anonelem = this.viewport.getFactory().createAnonymousElement(this.getParent().getParent().getElement().getOwnerDocument(), "tr", "table-row");
                anonrow = new TableRowBox(anonelem, this.g, this.ctx);
                anonrow.adoptParent(this);
                anonrow.setStyle(this.viewport.getFactory().createAnonymousStyle("table-row"));
                this.addRow((TableRowBox)anonrow);
            }
            anonrow.addSubBox(box);
            ((TableRowBox)anonrow).isempty = false;
            box.setContainingBlockBox(anonrow);
            box.setParent(anonrow);
            it.remove();
            --this.endChild;
        }
        if (anonrow != null) {
            ((TableRowBox)anonrow).endChild = ((TableRowBox)anonrow).nested.size();
            this.addSubBox(anonrow);
        }
    }

    private void calcOffsets() {
        int[] rowidx = new int[this.rows.size()];
        int maxCells = 0;
        for (int r = 0; r < this.rows.size(); ++r) {
            int count = this.rows.elementAt(r).getCellCount();
            if (count > maxCells) {
                maxCells = count;
            }
            rowidx[r] = 0;
            this.rows.elementAt(r).rewind();
        }
        int col = 0;
        boolean cell_found = true;
        while (cell_found) {
            cell_found = false;
            int r = 0;
            while (r < this.rows.size()) {
                TableRowBox row = this.rows.elementAt(r);
                if (row.hasNext()) {
                    cell_found = true;
                    if (rowidx[r] <= col) {
                        TableCellBox cell = row.next();
                        cell.setCellPosition(rowidx[r], r);
                        for (int nr = r; nr < r + cell.getRowspan(); ++nr) {
                            if (nr < this.rows.size()) {
                                int n = nr;
                                rowidx[n] = rowidx[n] + cell.getColspan();
                                if (rowidx[nr] <= this.numCols) continue;
                                this.numCols = rowidx[nr];
                                continue;
                            }
                            --cell.rowspan;
                        }
                        r += cell.getRowspan();
                        continue;
                    }
                    ++r;
                    continue;
                }
                ++r;
            }
            ++col;
        }
        for (int i = 0; i < this.rows.size(); ++i) {
            this.rows.elementAt(i).rewind();
        }
        this.cells = new TableCellBox[this.numCols][this.rows.size()];
        for (int c = 0; c < maxCells; ++c) {
            for (int r = 0; r < this.rows.size(); ++r) {
                TableRowBox row = this.rows.elementAt(r);
                if (!row.hasNext()) continue;
                TableCellBox cell = row.next();
                if (cell.getRow() + cell.getRowspan() > this.rows.size()) {
                    cell.setRowspan(this.rows.size() - cell.getRow());
                }
                if (cell.getColumn() + cell.getColspan() > this.numCols) {
                    cell.setColspan(this.numCols - cell.getColumn());
                }
                int endrow = cell.getRow() + cell.getRowspan();
                int endcol = cell.getColumn() + cell.getColspan();
                for (int nr = cell.getRow(); nr < endrow; ++nr) {
                    for (int nc = cell.getColumn(); nc < endcol; ++nc) {
                        this.cells[nc][nr] = cell;
                    }
                }
            }
        }
    }
}

