/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.layout;

import cz.vutbr.web.css.CSSFactory;
import cz.vutbr.web.css.Declaration;
import cz.vutbr.web.css.TermLength;
import cz.vutbr.web.css.TermLengthOrPercent;
import cz.vutbr.web.css.TermList;
import java.awt.Graphics2D;
import java.util.Iterator;
import java.util.Vector;
import org.fit.cssbox.css.HTMLNorm;
import org.fit.cssbox.layout.BlockBox;
import org.fit.cssbox.layout.Box;
import org.fit.cssbox.layout.CSSDecoder;
import org.fit.cssbox.layout.ElementBox;
import org.fit.cssbox.layout.InlineBox;
import org.fit.cssbox.layout.TableBodyBox;
import org.fit.cssbox.layout.TableColumn;
import org.fit.cssbox.layout.TableColumnGroup;
import org.fit.cssbox.layout.VisualContext;
import org.w3c.dom.Element;

public class TableBox
extends BlockBox {
    private final int DEFAULT_SPACING = 0;
    protected TableBodyBox header;
    protected TableBodyBox footer;
    protected Vector<TableBodyBox> bodies;
    protected Vector<TableColumn> columns;
    protected int columnCount;
    protected int spacing = 0;
    private TableBodyBox anonbody;
    private boolean columnsCalculated = false;

    public TableBox(Element n, Graphics2D g, VisualContext ctx) {
        super(n, g, ctx);
        this.isblock = true;
    }

    public TableBox(InlineBox src) {
        super(src);
        this.isblock = true;
    }

    public TableBox(BlockBox src) {
        super(src.el, src.g, src.ctx);
        this.copyValues(src);
        this.isblock = true;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    @Override
    public boolean hasFixedWidth() {
        return this.wset;
    }

    @Override
    public void initBox() {
        this.loadTableStyle();
        this.organizeContent();
        this.propagateCellSpacing(this.spacing);
    }

    @Override
    public boolean doLayout(int widthlimit, boolean force, boolean linestart) {
        this.setAvailableWidth(widthlimit);
        int wlimit = this.getAvailableContentWidth();
        int maxw = 0;
        int y = 0;
        this.calculateColumns();
        if (this.header != null) {
            this.header.doLayout(wlimit, this.columns);
            this.header.setPosition(0, y);
            if (this.header.getWidth() > maxw) {
                maxw = this.header.getWidth();
            }
            y += this.header.getHeight();
        }
        for (TableBodyBox body : this.bodies) {
            body.doLayout(wlimit, this.columns);
            body.setPosition(0, y);
            if (body.getWidth() > maxw) {
                maxw = body.getWidth();
            }
            y += body.getHeight();
        }
        if (this.footer != null) {
            this.footer.doLayout(wlimit, this.columns);
            this.footer.setPosition(0, y);
            if (this.footer.getWidth() > maxw) {
                maxw = this.footer.getWidth();
            }
            y += this.footer.getHeight();
        }
        this.content.width = maxw;
        this.content.height = y;
        this.setSize(this.totalWidth(), this.totalHeight());
        return true;
    }

    @Override
    protected void loadSizes(boolean update) {
        if (!update) {
            TermLengthOrPercent hspec;
            String height;
            TermLengthOrPercent wspec;
            String width = HTMLNorm.getAttribute(this.getElement(), "width");
            if (!width.isEmpty() && (wspec = HTMLNorm.createLengthOrPercent(width)) != null) {
                Declaration dec = CSSFactory.getRuleFactory().createDeclaration();
                dec.setProperty("width");
                dec.unlock();
                dec.add((Object)wspec);
                dec.setImportant(true);
                this.style.push(dec);
            }
            if (!(height = HTMLNorm.getAttribute(this.getElement(), "height")).isEmpty() && (hspec = HTMLNorm.createLengthOrPercent(height)) != null) {
                Declaration dec = CSSFactory.getRuleFactory().createDeclaration();
                dec.setProperty("height");
                dec.unlock();
                dec.add((Object)hspec);
                dec.setImportant(true);
                this.style.push(dec);
            }
        }
        super.loadSizes(update);
    }

    @Override
    protected void computeWidthsInFlow(TermLengthOrPercent width, boolean auto, boolean exact, int contw, boolean update) {
        CSSDecoder dec = new CSSDecoder(this.ctx);
        if (width == null) {
            auto = true;
        }
        if (exact) {
            boolean bl = this.wset = !auto;
        }
        if (this.wset && exact && width.isPercentage()) {
            this.wrelative = true;
        }
        this.margin.right = 0;
        this.margin.left = 0;
        if (!this.columnsCalculated) {
            update = false;
        }
        if (!this.wset && !update) {
            this.content.width = contw - this.border.left - this.padding.left - this.padding.right - this.border.right;
        } else {
            int fullw = this.getContainingBlockBox().getContainingBlock().width;
            if (!update) {
                this.content.width = dec.getLength(width, auto, 0, 0, fullw);
            }
        }
    }

    @Override
    protected void computeHeightsInFlow(TermLengthOrPercent height, boolean auto, boolean exact, int contw, int conth, boolean update) {
        CSSDecoder dec = new CSSDecoder(this.ctx);
        int newh = this.getContainingBlockBox().getContainingBlock().height;
        if (height == null) {
            auto = true;
        }
        this.margin.bottom = 0;
        this.margin.top = 0;
        if (this.getContainingBlockBox().hasFixedWidth()) {
            boolean bl = this.hset = exact && !auto;
            if (!update) {
                this.content.height = dec.getLength(height, auto, 0, 0, newh);
            }
        } else {
            boolean bl = this.hset = exact && !auto && !height.isPercentage();
            if (!update) {
                this.content.height = dec.getLength(height, auto, 0, 0, 0);
            }
        }
    }

    @Override
    protected int getMaximalContentWidth() {
        int m;
        int ret = 0;
        if (this.header != null && (m = this.header.getMaximalWidth()) > ret) {
            ret = m;
        }
        if (this.footer != null && (m = this.footer.getMaximalWidth()) > ret) {
            ret = m;
        }
        for (TableBodyBox body : this.bodies) {
            int m2 = body.getMaximalWidth();
            if (m2 <= ret) continue;
            ret = m2;
        }
        return ret;
    }

    @Override
    protected int getMinimalContentWidth() {
        int m;
        int ret = 0;
        if (this.header != null && (m = this.header.getMinimalWidth()) > ret) {
            ret = m;
        }
        if (this.footer != null && (m = this.footer.getMinimalWidth()) > ret) {
            ret = m;
        }
        for (TableBodyBox body : this.bodies) {
            int m2 = body.getMinimalWidth();
            if (m2 <= ret) continue;
            ret = m2;
        }
        return ret;
    }

    @Override
    protected int getMinimalDecorationWidth() {
        if (this.wset) {
            return super.getMinimalDecorationWidth();
        }
        return this.getMinimalWidth();
    }

    @Override
    protected void drawChildren(Box.DrawStage turn) {
        if (this.header != null) {
            this.header.draw(turn);
        }
        for (TableBodyBox body : this.bodies) {
            body.draw(turn);
        }
        if (this.footer != null) {
            this.footer.draw(turn);
        }
    }

    public void determineColumnCount() {
        int c;
        int ret = 0;
        if (this.header != null && (c = this.header.getColumnCount()) > ret) {
            ret = c;
        }
        if (this.footer != null && (c = this.footer.getColumnCount()) > ret) {
            ret = c;
        }
        for (TableBodyBox body : this.bodies) {
            int c2 = body.getColumnCount();
            if (c2 <= ret) continue;
            ret = c2;
        }
        this.columnCount = ret;
    }

    private void updateColumns(TableBodyBox body) {
        for (int i = 0; i < this.columns.size(); ++i) {
            if (i >= body.getColumnCount()) continue;
            body.updateColumn(i, this.columns.elementAt(i));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void calculateColumns() {
        int addw;
        int mincw;
        int neww;
        int remain;
        int wlimit = this.getAvailableContentWidth();
        this.determineColumnCount();
        while (this.columns.size() < this.columnCount) {
            this.columns.add(new TableColumn(TableColumn.createAnonymousColumn(this.getParent().getElement().getOwnerDocument()), this.g, this.ctx));
        }
        if (this.header != null) {
            this.updateColumns(this.header);
        }
        if (this.footer != null) {
            this.updateColumns(this.footer);
        }
        for (TableBodyBox body : this.bodies) {
            this.updateColumns(body);
        }
        int sumabs = 0;
        int sumperc = 0;
        int mintotalw = 0;
        int sumnonemin = 0;
        int sumnonemax = 0;
        int totalwperc = 0;
        for (TableColumn col : this.columns) {
            mintotalw += col.getMinimalWidth();
            if (col.wrelative) {
                sumperc += col.percent;
                int maxw = col.getMaximalWidth();
                int newtotal = maxw * 100 / col.percent;
                if (newtotal <= totalwperc) continue;
                totalwperc = newtotal;
                continue;
            }
            if (col.wset) {
                sumabs += Math.max(col.abswidth, col.getMinimalWidth());
                continue;
            }
            sumnonemin += col.getWidth();
            sumnonemax += col.getMaximalWidth();
        }
        if (totalwperc > wlimit) {
            totalwperc = wlimit;
        }
        int totalwabs = 0;
        if (sumabs + sumnonemax > 0) {
            int abspart = 100 - sumperc;
            totalwabs = abspart == 0 ? wlimit : (sumabs + sumnonemax) * 100 / abspart;
        }
        int totalw = Math.max(totalwperc, totalwabs);
        if (this.wset) {
            totalw = this.content.width - (this.columns.size() + 1) * this.spacing;
        } else if (totalw > wlimit) {
            totalw = wlimit;
        }
        if (totalw < mintotalw) {
            totalw = mintotalw;
        }
        if ((remain = totalw - mintotalw) > 0 && sumperc > 0) {
            for (TableColumn tableColumn : this.columns) {
                if (!tableColumn.wrelative) continue;
                neww = tableColumn.percent * totalw / 100;
                mincw = tableColumn.getMinimalWidth();
                if (neww < mincw) {
                    neww = mincw;
                }
                tableColumn.setColumnWidth(neww);
                remain -= neww - mincw;
            }
        }
        if (remain > 0 && sumabs > 0) {
            for (TableColumn tableColumn : this.columns) {
                if (!tableColumn.wset || tableColumn.wrelative) continue;
                neww = tableColumn.abswidth;
                mincw = tableColumn.getMinimalWidth();
                if (neww < mincw) {
                    neww = mincw;
                }
                tableColumn.setColumnWidth(neww);
                remain -= neww - mincw;
            }
        }
        if (remain > 0 && sumnonemin > 0 && sumnonemax > 0) {
            int remainmax = sumnonemax;
            remain += sumnonemin;
            for (TableColumn col : this.columns) {
                if (col.wset) continue;
                int mincw2 = col.getMinimalWidth();
                int neww2 = remain * col.getMaximalWidth() / remainmax;
                if (neww2 < mincw2) {
                    neww2 = mincw2;
                }
                col.setColumnWidth(neww2);
                if ((remainmax -= col.getMaximalWidth()) > 0 && (remain -= neww2) > 0) continue;
                break;
            }
        }
        if (remain > 0 && sumabs > 0) {
            int remainabs = sumabs;
            for (TableColumn col : this.columns) {
                if (!col.wset || col.wrelative) continue;
                addw = remain * col.getMaximalWidth() / remainabs;
                col.setColumnWidth(col.getWidth() + addw);
                remain -= addw;
                remainabs -= col.getMaximalWidth();
            }
        }
        if (remain > 0 && sumperc > 0 && sumperc < 100) {
            int remainperc = sumperc;
            for (TableColumn col : this.columns) {
                if (!col.wrelative) continue;
                addw = remain * col.percent / remainperc;
                col.setColumnWidth(col.getWidth() + addw);
                if ((remainperc -= col.getMaximalWidth()) > 0 && (remain -= addw) > 0) continue;
                break;
            }
        }
        if (remain > 0) {
            void var12_36;
            int remaincols = this.columns.size();
            int n = this.columns.size() - 1;
            while (var12_36 >= 0) {
                TableColumn col = this.columns.elementAt((int)var12_36);
                addw = remain / remaincols;
                col.setColumnWidth(col.getWidth() + addw);
                remain -= addw;
                --remaincols;
                --var12_36;
            }
        }
        if (remain < 0) {
            int addw2;
            int dif;
            if (sumnonemin > 0) {
                void var12_39;
                int totaldif = 0;
                for (TableColumn col : this.columns) {
                    if (col.wset) continue;
                    totaldif += col.getWidth() - col.getMinimalWidth();
                }
                int n = this.columns.size() - 1;
                while (var12_39 >= 0 && totaldif > 0) {
                    TableColumn col = this.columns.elementAt((int)var12_39);
                    if (!col.wset) {
                        dif = col.getWidth() - col.getMinimalWidth();
                        int addw22 = remain * dif / totaldif;
                        col.setColumnWidth(col.getWidth() + addw22);
                        totaldif -= dif;
                        if ((remain -= addw22) >= 0) break;
                    }
                    --var12_39;
                }
            }
            if (remain < 0 && sumabs > 0) {
                void var12_42;
                int totaldif = 0;
                for (TableColumn col : this.columns) {
                    if (!col.wset || col.wrelative) continue;
                    totaldif += col.getWidth() - col.getMinimalWidth();
                }
                int n = this.columns.size() - 1;
                while (var12_42 >= 0 && totaldif > 0) {
                    TableColumn col = this.columns.elementAt((int)var12_42);
                    if (col.wset && !col.wrelative) {
                        dif = col.getWidth() - col.getMinimalWidth();
                        addw2 = remain * dif / totaldif;
                        col.setColumnWidth(col.getWidth() + addw2);
                        totaldif -= dif;
                        if ((remain -= addw2) >= 0) break;
                    }
                    --var12_42;
                }
            }
            if (remain < 0 && sumperc > 0) {
                void var12_45;
                int totaldif = 0;
                for (TableColumn col : this.columns) {
                    if (!col.wrelative) continue;
                    totaldif += col.getWidth() - col.getMinimalWidth();
                }
                int n = this.columns.size() - 1;
                while (var12_45 >= 0 && totaldif > 0) {
                    TableColumn col = this.columns.elementAt((int)var12_45);
                    if (col.wrelative) {
                        dif = col.getWidth() - col.getMinimalWidth();
                        addw2 = remain * dif / totaldif;
                        col.setColumnWidth(col.getWidth() + addw2);
                        totaldif -= dif;
                        if ((remain -= addw2) >= 0) break;
                    }
                    --var12_45;
                }
            }
        }
        this.columnsCalculated = true;
    }

    @Override
    protected void loadBlockStyle() {
        super.loadBlockStyle();
        this.position = POS_STATIC;
        this.floating = FLOAT_NONE;
    }

    private void loadTableStyle() {
        CSSDecoder dec = new CSSDecoder(this.ctx);
        TermList spc = (TermList)this.style.getValue(TermList.class, "border-spacing");
        this.spacing = spc != null ? dec.getLength((TermLengthOrPercent)((TermLength)spc.get(0)), false, 0, 0, 0) : dec.getLength(this.getLengthValue("border-spacing"), false, 0, 0, 0);
    }

    private void organizeContent() {
        this.bodies = new Vector();
        this.columns = new Vector();
        this.anonbody = null;
        Iterator it = this.nested.iterator();
        while (it.hasNext()) {
            Box box = (Box)it.next();
            if (!(box instanceof ElementBox)) continue;
            ElementBox subbox = (ElementBox)box;
            if (subbox.getDisplay() == ElementBox.DISPLAY_TABLE_HEADER_GROUP) {
                this.header = (TableBodyBox)subbox;
                this.header.setOwnerTable(this);
                continue;
            }
            if (subbox.getDisplay() == ElementBox.DISPLAY_TABLE_FOOTER_GROUP) {
                this.footer = (TableBodyBox)subbox;
                this.footer.setOwnerTable(this);
                continue;
            }
            if (subbox.getDisplay() == ElementBox.DISPLAY_TABLE_ROW_GROUP) {
                this.bodies.add((TableBodyBox)subbox);
                ((TableBodyBox)subbox).setOwnerTable(this);
                continue;
            }
            if (subbox.getDisplay() == ElementBox.DISPLAY_TABLE_COLUMN) {
                for (int i = 0; i < ((TableColumn)subbox).getSpan(); ++i) {
                    if (i == 0) {
                        this.columns.add((TableColumn)subbox);
                        continue;
                    }
                    this.columns.add(((TableColumn)subbox).copyBox());
                }
                continue;
            }
            if (subbox.getDisplay() == ElementBox.DISPLAY_TABLE_COLUMN_GROUP) {
                for (int i = 0; i < ((TableColumnGroup)subbox).getSpan(); ++i) {
                    this.columns.add(((TableColumnGroup)subbox).getColumn(i));
                }
                continue;
            }
            if (this.anonbody == null) {
                Element anonelem = this.viewport.getFactory().createAnonymousElement(this.getParent().getElement().getOwnerDocument(), "tbody", "table-row-group");
                this.anonbody = new TableBodyBox(anonelem, this.g, this.ctx);
                this.anonbody.adoptParent(this);
                this.anonbody.setStyle(this.viewport.getFactory().createAnonymousStyle("table-row-group"));
                this.anonbody.setOwnerTable(this);
                this.bodies.add(this.anonbody);
            }
            this.anonbody.addSubBox(subbox);
            this.anonbody.isempty = false;
            subbox.setContainingBlockBox(this.anonbody);
            subbox.setParent(this.anonbody);
            it.remove();
            --this.endChild;
        }
        if (this.anonbody != null) {
            this.anonbody.endChild = this.anonbody.nested.size();
            this.addSubBox(this.anonbody);
        }
    }

    private void propagateCellSpacing(int spacing) {
        if (this.header != null) {
            this.header.setSpacing(spacing);
        }
        for (TableBodyBox body : this.bodies) {
            body.setSpacing(spacing);
        }
        if (this.footer != null) {
            this.footer.setSpacing(spacing);
        }
    }
}

