/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.layout;

import cz.vutbr.web.css.CSSProperty;
import cz.vutbr.web.css.TermLengthOrPercent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import org.fit.cssbox.css.HTMLNorm;
import org.fit.cssbox.layout.BlockBox;
import org.fit.cssbox.layout.CSSDecoder;
import org.fit.cssbox.layout.ElementBox;
import org.fit.cssbox.layout.FloatList;
import org.fit.cssbox.layout.InlineBox;
import org.fit.cssbox.layout.LengthSet;
import org.fit.cssbox.layout.TableColumn;
import org.fit.cssbox.layout.TableRowBox;
import org.fit.cssbox.layout.VisualContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class TableCellBox
extends BlockBox {
    private static final Logger LOG = LoggerFactory.getLogger(TableCellBox.class);
    protected int colspan;
    protected int rowspan;
    protected int row;
    protected int column;
    protected TableRowBox ownerRow;
    protected TableColumn ownerColumn;
    protected int percent;
    protected int coffset;

    public TableCellBox(Element n, Graphics2D g, VisualContext ctx) {
        super(n, g, ctx);
        this.isblock = true;
        this.loadAttributes();
        this.fleft = new FloatList(this);
        this.fright = new FloatList(this);
        this.coffset = 0;
    }

    public TableCellBox(InlineBox src) {
        super(src);
        this.isblock = true;
        this.loadAttributes();
        this.fleft = new FloatList(this);
        this.fright = new FloatList(this);
        this.coffset = 0;
    }

    public int getColspan() {
        return this.colspan;
    }

    public int getRowspan() {
        return this.rowspan;
    }

    public void setColspan(int colspan) {
        this.colspan = colspan;
    }

    public void setRowspan(int rowspan) {
        this.rowspan = rowspan;
    }

    public int getRow() {
        return this.row;
    }

    public int getColumn() {
        return this.column;
    }

    public TableRowBox getOwnerRow() {
        return this.ownerRow;
    }

    public void setOwnerRow(TableRowBox ownerRow) {
        this.ownerRow = ownerRow;
    }

    public TableColumn getOwnerColumn() {
        return this.ownerColumn;
    }

    public void setOwnerColumn(TableColumn ownerColumn) {
        this.ownerColumn = ownerColumn;
    }

    public void setCellPosition(int column, int row) {
        this.column = column;
        this.row = row;
    }

    public void setWidth(int width) {
        this.content.width = width - this.border.left - this.padding.left - this.padding.right - this.border.right;
        this.bounds.width = width;
        this.wset = true;
        this.updateChildSizes();
    }

    public void setHeight(int height) {
        this.content.height = height - this.border.top - this.padding.top - this.padding.bottom - this.border.bottom;
        this.bounds.height = height;
        this.hset = true;
    }

    public int getPercent() {
        return this.percent;
    }

    @Override
    public String toString() {
        return super.toString() + "[" + this.column + "," + this.row + "]";
    }

    public void applyVerticalAlign(int origHeight, int newHeight, int baseline) {
        int yofs = 0;
        CSSProperty.VerticalAlign valign = (CSSProperty.VerticalAlign)this.style.getProperty("vertical-align");
        if (valign == null) {
            valign = CSSProperty.VerticalAlign.MIDDLE;
        }
        switch (valign) {
            case TOP: {
                yofs = 0;
                break;
            }
            case BOTTOM: {
                yofs = newHeight - origHeight;
                break;
            }
            case MIDDLE: {
                yofs = (newHeight - origHeight) / 2;
                break;
            }
            default: {
                yofs = baseline - this.getFirstInlineBoxBaseline();
            }
        }
        if (yofs > 0) {
            this.coffset = yofs;
        }
    }

    @Override
    public int getAbsoluteContentY() {
        return super.getAbsoluteContentY() + this.coffset;
    }

    @Override
    public void computeEfficientMargins() {
        this.emargin = new LengthSet(this.margin);
    }

    @Override
    public int getMinimalWidth() {
        int ret = this.getMinimalContentWidth();
        if (!this.wrelative && this.hasFixedWidth() && this.content.width > ret) {
            ret = this.content.width;
        }
        return ret += this.margin.left + this.padding.left + this.border.left + this.margin.right + this.padding.right + this.border.right;
    }

    @Override
    public int getMaximalWidth() {
        int ret = this.getMaximalContentWidth();
        return ret += this.margin.left + this.padding.left + this.border.left + this.margin.right + this.padding.right + this.border.right;
    }

    @Override
    protected void loadSizes(boolean update) {
        boolean hauto;
        CSSDecoder dec = new CSSDecoder(this.ctx);
        int contw = this.getContainingBlock().width;
        if (!update) {
            this.loadBorders(dec, contw);
        }
        this.loadPadding(dec, contw);
        if (!update) {
            this.content = new Dimension(0, 0);
            this.margin = new LengthSet();
            this.emargin = new LengthSet();
            this.min_size = new Dimension(-1, -1);
            this.max_size = new Dimension(-1, -1);
            this.coords = new LengthSet();
        }
        CSSProperty.Width wprop = null;
        TermLengthOrPercent width = null;
        String widthattr = HTMLNorm.getAttribute(this.getElement(), "width");
        if (!widthattr.equals("")) {
            width = HTMLNorm.createLengthOrPercent(widthattr);
            if (width != null) {
                wprop = width.isPercentage() ? CSSProperty.Width.percentage : CSSProperty.Width.length;
            }
        } else {
            wprop = (CSSProperty.Width)this.style.getProperty("width");
            width = this.getLengthValue("width");
        }
        if (wprop == null || wprop == CSSProperty.Width.AUTO) {
            this.wset = false;
        } else {
            this.wset = true;
            if (!update) {
                this.content.width = dec.getLength(width, false, 0, 0, contw);
            }
            if (width.isPercentage()) {
                this.wrelative = true;
                this.percent = Math.round(((Float)width.getValue()).floatValue());
                if (this.percent == 0) {
                    this.wrelative = false;
                }
            }
        }
        String heightattr = HTMLNorm.getAttribute(this.getElement(), "height");
        CSSProperty.Height hprop = null;
        TermLengthOrPercent height = null;
        if (!heightattr.equals("")) {
            height = HTMLNorm.createLengthOrPercent(widthattr);
            if (height != null) {
                hprop = height.isPercentage() ? CSSProperty.Height.percentage : CSSProperty.Height.length;
            }
        } else {
            hprop = (CSSProperty.Height)this.style.getProperty("height");
            height = this.getLengthValue("height");
        }
        boolean bl = hauto = hprop == null || hprop == CSSProperty.Height.AUTO;
        if (this.getContainingBlockBox().hasFixedWidth()) {
            boolean bl2 = this.hset = !hauto;
            if (!update) {
                this.content.height = dec.getLength(height, hauto, 0, 0, this.getContainingBlock().width);
            }
        } else {
            boolean bl3 = this.hset = !hauto && !height.isPercentage();
            if (!update) {
                this.content.height = dec.getLength(height, hauto, 0, 0, 0);
            }
        }
    }

    @Override
    public boolean hasFixedWidth() {
        return true;
    }

    @Override
    public boolean canIncreaseWidth() {
        return true;
    }

    @Override
    public Color getBgcolor() {
        Color bg = this.bgcolor;
        if (bg == null) {
            bg = this.getOwnerRow().getBgcolor();
        }
        if (bg == null) {
            bg = this.getOwnerColumn().getBgcolor();
        }
        if (bg == null) {
            bg = this.getOwnerRow().getOwnerBody().getBgcolor();
        }
        return bg;
    }

    @Override
    protected boolean separatedFromTop(ElementBox box) {
        return true;
    }

    @Override
    protected boolean separatedFromBottom(ElementBox box) {
        return true;
    }

    @Override
    protected boolean encloseFloats() {
        return true;
    }

    protected void loadAttributes() {
        try {
            this.colspan = !HTMLNorm.getAttribute(this.el, "colspan").equals("") ? Integer.parseInt(HTMLNorm.getAttribute(this.el, "colspan")) : 1;
            this.rowspan = !HTMLNorm.getAttribute(this.el, "rowspan").equals("") ? Integer.parseInt(HTMLNorm.getAttribute(this.el, "rowspan")) : 1;
        }
        catch (NumberFormatException e) {
            LOG.warn("Invalid width value: {}", (Object)e.getMessage());
        }
    }
}

