/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.layout;

import cz.vutbr.web.css.CSSFactory;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.Vector;
import org.fit.cssbox.layout.BlockBox;
import org.fit.cssbox.layout.Box;
import org.fit.cssbox.layout.BoxFactory;
import org.fit.cssbox.layout.BrowserConfig;
import org.fit.cssbox.layout.ElementBox;
import org.fit.cssbox.layout.LengthSet;
import org.fit.cssbox.layout.VisualContext;
import org.fit.cssbox.render.BoxRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class Viewport
extends BlockBox {
    private static final Logger LOG = LoggerFactory.getLogger(Viewport.class);
    private int width;
    private int height;
    private Rectangle visibleRect;
    protected BrowserConfig config;
    private BoxFactory factory;
    private BoxRenderer renderer;
    private Element root;
    private ElementBox rootBox;
    private ElementBox bgSrc;
    private boolean rootOverflowVisible = true;
    private int maxx;
    private int maxy;
    private boolean recomputeAbs;

    public Viewport(Element e, Graphics2D g, VisualContext ctx, BoxFactory factory, Element root, int width, int height) {
        super(e, g, ctx);
        ctx.setViewport(this);
        this.factory = factory;
        this.root = root;
        this.style = CSSFactory.createNodeData();
        this.nested = new Vector();
        this.startChild = 0;
        this.endChild = 0;
        this.width = width;
        this.height = height;
        this.isblock = true;
        this.contblock = true;
        root = null;
        this.visibleRect = new Rectangle(0, 0, width, height);
    }

    public Rectangle getVisibleRect() {
        return this.visibleRect;
    }

    public void setVisibleRect(Rectangle visibleRect) {
        this.visibleRect = visibleRect;
        this.content = visibleRect.getSize();
    }

    public Dimension getCanvasSize() {
        return new Dimension(this.width, this.height);
    }

    public BrowserConfig getConfig() {
        return this.config;
    }

    public void setConfig(BrowserConfig config) {
        this.config = config;
        this.overflowY = config.getClipViewport() ? OVERFLOW_HIDDEN : OVERFLOW_VISIBLE;
        this.overflowX = this.overflowY;
    }

    @Override
    public void initSubtree() {
        super.initSubtree();
        this.loadBackgroundFromContents();
    }

    @Override
    public String toString() {
        return "Viewport " + this.width + "x" + this.height + "[visible " + this.visibleRect.x + "," + this.visibleRect.y + "," + this.visibleRect.width + "," + this.visibleRect.height + "]";
    }

    public BoxFactory getFactory() {
        return this.factory;
    }

    public int getMinimalWidthLimit() {
        return this.width;
    }

    public Element getRootElement() {
        return this.root;
    }

    public ElementBox getRootBox() {
        return this.rootBox;
    }

    public ElementBox getElementBoxByName(String name, boolean case_sensitive) {
        return this.recursiveFindElementBoxByName(this, name, case_sensitive);
    }

    @Override
    public void addSubBox(Box box) {
        super.addSubBox(box);
        if (box instanceof ElementBox && ((ElementBox)box).getElement() == this.root) {
            if (this.rootBox != null && LOG.isDebugEnabled()) {
                LOG.debug("Viewport warning: another root box '" + box + "' in addition to previous '" + this.rootBox + "'");
            }
            box.makeRoot();
            this.rootBox = (ElementBox)box;
        }
    }

    @Override
    public boolean hasFixedHeight() {
        return true;
    }

    @Override
    public boolean hasFixedWidth() {
        return true;
    }

    @Override
    public boolean canIncreaseWidth() {
        return true;
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public boolean visibleInClip(Box box) {
        if (this.config.getClipViewport()) {
            return super.visibleInClip(box);
        }
        Rectangle bb = box instanceof ElementBox ? ((ElementBox)box).getAbsoluteBorderBounds() : box.getAbsoluteBounds();
        return bb.x + bb.width > 0 && bb.y + bb.height > 0;
    }

    @Override
    protected boolean separatedFromTop(ElementBox box) {
        return true;
    }

    @Override
    protected boolean separatedFromBottom(ElementBox box) {
        return true;
    }

    @Override
    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
        this.content = new Dimension(width, height);
        this.bounds = new Rectangle(0, 0, this.totalWidth(), this.totalHeight());
    }

    @Override
    public Viewport getViewport() {
        return this;
    }

    @Override
    protected void loadPosition() {
        this.position = BlockBox.POS_ABSOLUTE;
        this.topset = true;
        this.leftset = true;
        this.bottomset = false;
        this.rightset = false;
        this.coords = new LengthSet(0, 0, 0, 0);
    }

    @Override
    protected void loadSizes(boolean update) {
        if (!update) {
            this.margin = new LengthSet();
            this.emargin = new LengthSet();
            this.declMargin = new LengthSet();
            this.border = new LengthSet();
            this.padding = new LengthSet();
            this.content = new Dimension(this.width, this.height);
            this.min_size = new Dimension(-1, -1);
            this.max_size = new Dimension(-1, -1);
            this.loadPosition();
        }
        this.bounds = new Rectangle(0, 0, this.totalWidth(), this.totalHeight());
    }

    @Override
    public void setContentWidth(int width) {
        if (width > this.width) {
            super.setContentWidth(width);
        }
    }

    @Override
    public void setContentHeight(int height) {
        if (height > this.height) {
            super.setContentHeight(height);
        }
    }

    @Override
    protected void loadBackground() {
        this.bgcolor = null;
    }

    public ElementBox getBackgroundSource() {
        return this.bgSrc;
    }

    private void loadBackgroundFromContents() {
        if (this.rootBox != null && this.bgSrc == null) {
            ElementBox src = this.rootBox;
            if (src.getBgcolor() == null && src.getBackgroundImages() == null && this.config.getUseHTML()) {
                src = this.getElementBoxByName("body", false);
            }
            if (src != null) {
                this.bgSrc = src;
                if (src.getBgcolor() != null) {
                    this.bgcolor = src.getBgcolor();
                    src.setBgcolor(null);
                } else if (this.bgcolor == null) {
                    this.bgcolor = this.config.getViewportBackgroundColor();
                }
                if (src.getBackgroundImages() != null && !src.getBackgroundImages().isEmpty()) {
                    this.bgimages = this.loadBackgroundImages(src.getStyle());
                    src.getBackgroundImages().clear();
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("Couldn't find background source for viewport");
            }
        }
    }

    public void updateBounds(Dimension min) {
        this.maxx = min.width;
        this.maxy = min.height;
        this.absolutePositionsChildren();
        if (this.width < this.maxx) {
            this.width = this.maxx;
        }
        if (this.height < this.maxy) {
            this.height = this.maxy;
        }
        this.loadSizes();
        this.loadBackgroundFromContents();
    }

    @Override
    public boolean doLayout(int availw, boolean force, boolean linestart) {
        this.clearSplitted();
        int min = this.getMinimalContentWidth();
        int pref = Math.max(min, this.width);
        this.setContentWidth(pref);
        this.updateChildSizes();
        this.widthComputed = true;
        this.setAvailableWidth(this.totalWidth());
        if (!this.contblock) {
            this.layoutInline();
        } else {
            this.layoutBlocks();
        }
        return true;
    }

    @Override
    public boolean formsStackingContext() {
        return true;
    }

    @Override
    public void absolutePositions() {
        this.absbounds = this.parent == null ? new Rectangle(this.bounds) : new Rectangle(this.parent.getAbsoluteContentBounds());
        if (this.scontext != null) {
            this.scontext.clear();
        }
        this.absolutePositionsChildren();
    }

    protected void absolutePositionsChildren() {
        int i;
        this.recomputeAbs = false;
        for (i = 0; i < this.getSubBoxNumber(); ++i) {
            this.getSubBox(i).absolutePositions();
        }
        if (this.recomputeAbs) {
            if (this.scontext != null) {
                this.scontext.clear();
            }
            for (i = 0; i < this.getSubBoxNumber(); ++i) {
                this.getSubBox(i).absolutePositions();
            }
            this.recomputeAbs = false;
        }
    }

    public void draw(BoxRenderer renderer) {
        this.renderer = renderer;
        this.drawStackingContext(false);
    }

    public BoxRenderer getRenderer() {
        return this.renderer;
    }

    public void updateBoundsFor(Rectangle bounds) {
        int y;
        int x = bounds.x + bounds.width - 1;
        if (this.maxx < x) {
            this.maxx = x;
        }
        if (this.maxy < (y = bounds.y + bounds.height - 1)) {
            this.maxy = y;
        }
    }

    public void requireRecomputePositions() {
        this.recomputeAbs = true;
    }

    public void clipByBlock(BlockBox block) {
        this.recursivelySetClipBlock(this, block);
    }

    private void recursivelySetClipBlock(Box root, BlockBox clip) {
        if (root == this || root.getClipBlock() == this) {
            root.setClipBlock(clip);
            if (root instanceof ElementBox) {
                ElementBox eb = (ElementBox)root;
                for (int i = eb.getStartChild(); i < eb.getEndChild(); ++i) {
                    this.recursivelySetClipBlock(eb.getSubBox(i), clip);
                }
            }
        }
    }

    public boolean checkPropagateOverflow(BlockBox block) {
        if (this.rootBox == null && block.getElement() == this.root) {
            this.rootOverflowVisible = block.getOverflowX() == BlockBox.OVERFLOW_VISIBLE;
            this.takeBoxOverflow(block);
            return !this.rootOverflowVisible || !this.config.getUseHTML();
        }
        if ("body".equals(block.getElement().getTagName())) {
            if (this.config.getUseHTML()) {
                this.takeBoxOverflow(block);
            }
            return true;
        }
        return false;
    }

    private void takeBoxOverflow(BlockBox srcBlock) {
        this.overflowX = srcBlock.overflowX;
        this.overflowY = srcBlock.overflowY;
        srcBlock.overflowX = BlockBox.OVERFLOW_VISIBLE;
        srcBlock.overflowY = BlockBox.OVERFLOW_VISIBLE;
        if (this.config.getClipViewport()) {
            this.overflowX = BlockBox.OVERFLOW_HIDDEN;
            this.overflowY = BlockBox.OVERFLOW_HIDDEN;
        } else {
            if (this.overflowX != BlockBox.OVERFLOW_HIDDEN) {
                this.overflowX = BlockBox.OVERFLOW_VISIBLE;
            }
            if (this.overflowY != BlockBox.OVERFLOW_HIDDEN) {
                this.overflowY = BlockBox.OVERFLOW_VISIBLE;
            }
        }
    }

    @Override
    public int getContentX() {
        return this.visibleRect.x;
    }

    @Override
    public int getContentY() {
        return this.visibleRect.y;
    }

    @Override
    public int getContentWidth() {
        return this.visibleRect.width;
    }

    @Override
    public int getContentHeight() {
        return this.visibleRect.height;
    }

    @Override
    public Rectangle getAbsoluteBackgroundBounds() {
        return new Rectangle(this.visibleRect);
    }

    @Override
    public Rectangle getAbsoluteBorderBounds() {
        return new Rectangle(this.visibleRect);
    }

    @Override
    public Rectangle getClippedBounds() {
        if (this.config.getClipViewport()) {
            return this.getAbsoluteBounds();
        }
        return new Rectangle(0, 0, this.width, this.height);
    }

    @Override
    public Rectangle getClippedContentBounds() {
        if (this.config.getClipViewport()) {
            return this.getAbsoluteBounds();
        }
        return new Rectangle(0, 0, this.width, this.height);
    }

    @Override
    public void drawBackground(Graphics2D g) {
        if (this.bgcolor != null) {
            Color color = g.getColor();
            g.setColor(this.bgcolor);
            g.fillRect(0, 0, this.width, this.height);
            g.setColor(color);
        }
        super.drawBackground(g);
    }

    private ElementBox recursiveFindElementBoxByName(ElementBox ebox, String name, boolean case_sensitive) {
        boolean eq = case_sensitive ? ebox.getElement().getTagName().equals(name) : ebox.getElement().getTagName().equalsIgnoreCase(name);
        if (eq) {
            return ebox;
        }
        ElementBox ret = null;
        for (int i = 0; i < ebox.getSubBoxNumber() && ret == null; ++i) {
            Box child = ebox.getSubBox(i);
            if (!(child instanceof ElementBox)) continue;
            ret = this.recursiveFindElementBoxByName((ElementBox)child, name, case_sensitive);
        }
        return ret;
    }
}

