/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.layout;

import cz.vutbr.web.css.CSSProperty;
import cz.vutbr.web.css.NodeData;
import cz.vutbr.web.css.RuleFontFace;
import cz.vutbr.web.css.Term;
import cz.vutbr.web.css.TermAngle;
import cz.vutbr.web.css.TermCalc;
import cz.vutbr.web.css.TermColor;
import cz.vutbr.web.css.TermFloatValue;
import cz.vutbr.web.css.TermLength;
import cz.vutbr.web.css.TermLengthOrPercent;
import cz.vutbr.web.css.TermList;
import cz.vutbr.web.css.TermNumeric;
import cz.vutbr.web.css.TermURI;
import cz.vutbr.web.csskit.CalcArgs;
import cz.vutbr.web.csskit.TermCalcAngleImpl;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.fit.cssbox.css.CSSUnits;
import org.fit.cssbox.css.FontDecoder;
import org.fit.cssbox.css.FontSpec;
import org.fit.cssbox.io.DocumentSource;
import org.fit.cssbox.layout.BoxFactory;
import org.fit.cssbox.layout.Viewport;
import org.fit.net.DataURLHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VisualContext {
    protected static final Logger LOG = LoggerFactory.getLogger(VisualContext.class);
    private VisualContext parent;
    private VisualContext rootContext;
    private BoxFactory factory;
    private Viewport viewport;
    private Font font;
    private FontMetrics fm;
    private double fontSize;
    private CSSProperty.FontWeight fontWeight;
    private CSSProperty.FontStyle fontStyle;
    private CSSProperty.FontVariant fontVariant;
    private List<CSSProperty.TextDecoration> textDecoration;
    private double letterSpacing;
    private double em;
    private double rem;
    private double ex;
    private double ch;
    private double dpi;
    public Color color;
    private PxEvaluator pxEval;
    private PtEvaluator ptEval;
    private DegEvaluator degEval;
    private RadEvaluator radEval;

    public VisualContext(VisualContext parent, BoxFactory factory) {
        this.parent = parent;
        this.factory = factory;
        this.rootContext = parent == null ? this : parent.rootContext;
        this.rem = this.em = 16.0;
        this.ex = 0.6 * this.em;
        this.ch = 0.8 * this.ch;
        this.dpi = 96.0;
        this.font = new Font("Serif", 0, 16);
        this.fontSize = CSSUnits.points(16.0);
        this.fontWeight = CSSProperty.FontWeight.NORMAL;
        this.fontStyle = CSSProperty.FontStyle.NORMAL;
        this.fontVariant = CSSProperty.FontVariant.NORMAL;
        this.textDecoration = new ArrayList<CSSProperty.TextDecoration>(2);
        this.letterSpacing = 0.0;
        this.color = Color.BLACK;
    }

    public VisualContext create() {
        VisualContext ret = new VisualContext(this, this.factory);
        ret.viewport = this.viewport;
        ret.rootContext = this.rootContext;
        ret.em = this.em;
        ret.rem = this.rem;
        ret.ex = this.ex;
        ret.ch = this.ch;
        ret.dpi = this.dpi;
        ret.font = this.font;
        ret.fontSize = this.fontSize;
        ret.fontWeight = this.fontWeight;
        ret.fontStyle = this.fontStyle;
        ret.fontVariant = this.fontVariant;
        ret.textDecoration = new ArrayList<CSSProperty.TextDecoration>(this.textDecoration);
        ret.letterSpacing = this.letterSpacing;
        ret.color = this.color;
        return ret;
    }

    public VisualContext getParentContext() {
        return this.parent;
    }

    public Viewport getViewport() {
        return this.viewport;
    }

    public void setViewport(Viewport viewport) {
        this.viewport = viewport;
    }

    public boolean isRootContext() {
        return this == this.rootContext;
    }

    public void makeRootContext() {
        if (this.rootContext != null) {
            this.rootContext.rootContext = this;
        }
        this.rootContext = this;
    }

    public Font getFont() {
        return this.font;
    }

    public double getFontSize() {
        return this.fontSize;
    }

    public String getFontVariant() {
        return this.fontVariant.toString();
    }

    public String getTextDecorationString() {
        if (this.textDecoration.isEmpty()) {
            return "none";
        }
        StringBuilder ret = new StringBuilder();
        for (CSSProperty.TextDecoration dec : this.textDecoration) {
            if (ret.length() > 0) {
                ret.append(' ');
            }
            ret.append(dec.toString());
        }
        return ret.toString();
    }

    public List<CSSProperty.TextDecoration> getTextDecoration() {
        return this.textDecoration;
    }

    public double getLetterSpacing() {
        return this.letterSpacing;
    }

    public Color getColor() {
        return this.color;
    }

    public double getEm() {
        return this.em;
    }

    public double getRem() {
        return this.rem;
    }

    public double getEx() {
        return this.ex;
    }

    public double getCh() {
        return this.ch;
    }

    public double getDpi() {
        return this.dpi;
    }

    public void update(NodeData style) {
        TermColor clr;
        CSSProperty.LetterSpacing spacing;
        double size;
        CSSProperty.FontStyle fstyle;
        CSSProperty.FontWeight weight = (CSSProperty.FontWeight)style.getProperty("font-weight");
        if (weight != null) {
            this.fontWeight = weight;
        }
        if ((fstyle = (CSSProperty.FontStyle)style.getProperty("font-style")) != null) {
            this.fontStyle = fstyle;
        }
        String family = null;
        CSSProperty.FontFamily ff = (CSSProperty.FontFamily)style.getProperty("font-family");
        if (ff == null) {
            family = this.font.getFamily();
        } else if (ff == CSSProperty.FontFamily.list_values) {
            TermList fmlspec = (TermList)style.getValue(TermList.class, "font-family");
            family = fmlspec == null ? this.font.getFamily() : this.getFontName(fmlspec, this.fontWeight, this.fontStyle);
        } else {
            if (this.factory != null) {
                family = this.factory.getConfig().getDefaultFont(ff.getAWTValue());
            }
            if (family == null) {
                family = ff.getAWTValue();
            }
        }
        double psize = this.parent == null ? 16.0 : this.parent.getEm();
        CSSProperty.FontSize fsize = (CSSProperty.FontSize)style.getProperty("font-size");
        if (fsize == null) {
            size = this.em;
        } else if (fsize == CSSProperty.FontSize.length || fsize == CSSProperty.FontSize.percentage) {
            TermLengthOrPercent lenspec = (TermLengthOrPercent)style.getValue(TermLengthOrPercent.class, "font-size");
            if (lenspec != null) {
                this.em = psize;
                size = this.pxLength(lenspec, psize);
            } else {
                size = this.em;
            }
        } else {
            size = CSSUnits.convertFontSize(psize, fsize);
        }
        this.fontSize = CSSUnits.points(size);
        this.rem = this.rootContext != null ? this.rootContext.getEm() : this.em;
        this.font = this.createFont(family, (int)Math.round(size), this.fontWeight, this.fontStyle, this.letterSpacing);
        this.em = size;
        CSSProperty.FontVariant variant = (CSSProperty.FontVariant)style.getProperty("font-variant");
        if (variant != null) {
            this.fontVariant = variant;
        }
        CSSProperty.TextDecoration decor = (CSSProperty.TextDecoration)style.getProperty("text-decoration");
        this.textDecoration.clear();
        if (decor != null) {
            if (decor == CSSProperty.TextDecoration.list_values) {
                TermList list = (TermList)style.getValue(TermList.class, "text-decoration");
                for (Term t : list) {
                    if (!(t.getValue() instanceof CSSProperty.TextDecoration)) continue;
                    this.textDecoration.add((CSSProperty.TextDecoration)t.getValue());
                }
            } else if (decor != CSSProperty.TextDecoration.NONE) {
                this.textDecoration.add(decor);
            }
        }
        if ((spacing = (CSSProperty.LetterSpacing)style.getProperty("letter-spacing")) != null) {
            if (spacing == CSSProperty.LetterSpacing.NORMAL) {
                this.letterSpacing = 0.0;
            } else {
                TermLength lenspec = (TermLength)style.getValue(TermLength.class, "letter-spacing");
                if (lenspec != null) {
                    this.letterSpacing = this.pxLength((TermLengthOrPercent)lenspec);
                }
            }
        }
        if ((clr = (TermColor)style.getSpecifiedValue(TermColor.class, "color")) != null) {
            this.color = CSSUnits.convertColor((cz.vutbr.web.csskit.Color)clr.getValue());
        }
    }

    public void updateGraphics(Graphics2D g) {
        g.setFont(this.font);
        g.setColor(this.color);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
    }

    public void updateForGraphics(NodeData style, Graphics2D g) {
        if (style != null) {
            this.update(style);
        }
        this.updateGraphics(g);
        this.fm = g.getFontMetrics();
        FontRenderContext frc = new FontRenderContext(null, false, false);
        TextLayout layout = new TextLayout("x", this.font, frc);
        this.ex = layout.getBounds().getHeight();
        this.ch = this.fm.charWidth('0');
    }

    public int getFontHeight() {
        return this.fm.getHeight();
    }

    public int getBaselineOffset() {
        return this.fm.getAscent();
    }

    public double ptLength(TermLengthOrPercent spec, double whole) {
        float nval = ((Float)spec.getValue()).floatValue();
        if (spec.isPercentage()) {
            return whole * (double)nval / 100.0;
        }
        if (spec instanceof TermCalc) {
            CalcArgs args = ((TermCalc)spec).getArgs();
            return (Double)args.evaluate((CalcArgs.Evaluator)this.getPtEval().setWhole(whole));
        }
        TermNumeric.Unit unit = spec.getUnit();
        if (unit == null) {
            return 0.0;
        }
        switch (unit) {
            case pt: {
                return nval;
            }
            case in: {
                return nval * 72.0f;
            }
            case cm: {
                return (double)(nval * 72.0f) / 2.54;
            }
            case mm: {
                return (double)(nval * 72.0f) / 25.4;
            }
            case q: {
                return (double)(nval * 72.0f) / 101.6;
            }
            case pc: {
                return nval * 12.0f;
            }
            case px: {
                return (double)(nval * 72.0f) / this.dpi;
            }
            case em: {
                return this.em * (double)nval * 72.0 / this.dpi;
            }
            case rem: {
                return this.rem * (double)nval * 72.0 / this.dpi;
            }
            case ex: {
                return this.ex * (double)nval * 72.0 / this.dpi;
            }
            case ch: {
                return this.ch * (double)nval * 72.0 / this.dpi;
            }
            case vw: {
                return this.viewport.getVisibleRect().getWidth() * (double)nval * 72.0 / (100.0 * this.dpi);
            }
            case vh: {
                return this.viewport.getVisibleRect().getHeight() * (double)nval * 72.0 / (100.0 * this.dpi);
            }
            case vmin: {
                return Math.min(this.viewport.getVisibleRect().getWidth(), this.viewport.getVisibleRect().getHeight()) * (double)nval * 72.0 / (100.0 * this.dpi);
            }
            case vmax: {
                return Math.max(this.viewport.getVisibleRect().getWidth(), this.viewport.getVisibleRect().getHeight()) * (double)nval * 72.0 / (100.0 * this.dpi);
            }
        }
        return 0.0;
    }

    public double ptLength(TermLengthOrPercent spec) {
        return this.ptLength(spec, 0.0);
    }

    public double pxLength(TermLengthOrPercent spec, double whole) {
        float nval = ((Float)spec.getValue()).floatValue();
        if (spec.isPercentage()) {
            return whole * (double)nval / 100.0;
        }
        if (spec instanceof TermCalc) {
            CalcArgs args = ((TermCalc)spec).getArgs();
            return (Double)args.evaluate((CalcArgs.Evaluator)this.getPxEval().setWhole(whole));
        }
        TermNumeric.Unit unit = spec.getUnit();
        if (unit == null) {
            return 0.0;
        }
        switch (unit) {
            case pt: {
                return (double)nval * this.dpi / 72.0;
            }
            case in: {
                return (double)nval * this.dpi;
            }
            case cm: {
                return (double)nval * this.dpi / 2.54;
            }
            case mm: {
                return (double)nval * this.dpi / 25.4;
            }
            case q: {
                return (double)nval * this.dpi / 101.6;
            }
            case pc: {
                return (double)(nval * 12.0f) * this.dpi / 72.0;
            }
            case px: {
                return nval;
            }
            case em: {
                return this.em * (double)nval;
            }
            case rem: {
                return this.rem * (double)nval;
            }
            case ex: {
                return this.ex * (double)nval;
            }
            case ch: {
                return this.ch * (double)nval;
            }
            case vw: {
                return this.viewport.getVisibleRect().getWidth() * (double)nval / 100.0;
            }
            case vh: {
                return this.viewport.getVisibleRect().getHeight() * (double)nval / 100.0;
            }
            case vmin: {
                return Math.min(this.viewport.getVisibleRect().getWidth(), this.viewport.getVisibleRect().getHeight()) * (double)nval / 100.0;
            }
            case vmax: {
                return Math.max(this.viewport.getVisibleRect().getWidth(), this.viewport.getVisibleRect().getHeight()) * (double)nval / 100.0;
            }
        }
        return 0.0;
    }

    public double pxLength(TermLengthOrPercent spec) {
        return this.pxLength(spec, 0.0);
    }

    public double degAngle(TermAngle spec) {
        float nval = ((Float)spec.getValue()).floatValue();
        TermNumeric.Unit unit = spec.getUnit();
        if (spec instanceof TermCalcAngleImpl) {
            CalcArgs args = ((TermCalc)spec).getArgs();
            return (Double)args.evaluate((CalcArgs.Evaluator)this.getDegEval());
        }
        if (unit == null) {
            return 0.0;
        }
        switch (unit) {
            case deg: {
                return nval;
            }
            case grad: {
                return (double)nval * 200.0 / Math.PI;
            }
            case rad: {
                return (double)nval * 180.0 / Math.PI;
            }
            case turn: {
                return (double)nval * 360.0;
            }
        }
        return 0.0;
    }

    public double radAngle(TermAngle spec) {
        float nval = ((Float)spec.getValue()).floatValue();
        TermNumeric.Unit unit = spec.getUnit();
        if (spec instanceof TermCalcAngleImpl) {
            CalcArgs args = ((TermCalc)spec).getArgs();
            return (Double)args.evaluate((CalcArgs.Evaluator)this.getRadEval());
        }
        if (unit == null) {
            return 0.0;
        }
        switch (unit) {
            case deg: {
                return (double)nval * Math.PI / 180.0;
            }
            case grad: {
                return (double)nval * Math.PI / 200.0;
            }
            case rad: {
                return nval;
            }
            case turn: {
                return (double)(nval * 2.0f) * Math.PI;
            }
        }
        return 0.0;
    }

    private String getFontName(TermList list, CSSProperty.FontWeight weight, CSSProperty.FontStyle style) {
        for (Term term : list) {
            Object value = term.getValue();
            if (value instanceof CSSProperty.FontFamily) {
                return ((CSSProperty.FontFamily)value).getAWTValue();
            }
            String name = this.lookupFont(value.toString(), weight, style);
            if (name == null) continue;
            return name;
        }
        return "Serif";
    }

    private String lookupFont(String family, CSSProperty.FontWeight weight, CSSProperty.FontStyle style) {
        String[] systemFontNames = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        String nameFound = null;
        FontSpec spec = new FontSpec(family, weight, style);
        List<RuleFontFace.Source> srcs = this.findMatchingFontSources(spec);
        if (srcs != null) {
            for (RuleFontFace.Source src : srcs) {
                if (src instanceof RuleFontFace.SourceLocal) {
                    String name = this.fontAvailable(((RuleFontFace.SourceLocal)src).getName(), systemFontNames);
                    if (name == null) continue;
                    nameFound = name;
                    break;
                }
                if (!(src instanceof RuleFontFace.SourceURL) || !this.viewport.getConfig().isLoadFonts()) continue;
                try {
                    TermURI urlstring = ((RuleFontFace.SourceURL)src).getURI();
                    String format = ((RuleFontFace.SourceURL)src).getFormat();
                    if (format != null && !FontDecoder.supportedFormats.contains(format)) continue;
                    URL url = DataURLHandler.createURL((URL)urlstring.getBase(), (String)((String)urlstring.getValue()));
                    String regName = FontDecoder.findRegisteredFont(url);
                    if (regName == null) {
                        DocumentSource imgsrc = this.viewport.getConfig().createDocumentSource(url);
                        Font newFont = FontDecoder.decodeFont(imgsrc, format);
                        if (LOG.isDebugEnabled()) {
                            if (GraphicsEnvironment.getLocalGraphicsEnvironment().registerFont(newFont)) {
                                LOG.debug("Registered font: {}", (Object)newFont.getFontName());
                            } else {
                                LOG.debug("Failed to register font: {} (not fatal, probably already existing)", (Object)newFont.getFontName());
                            }
                        }
                        regName = newFont.getFontName();
                        FontDecoder.registerFont(url, regName);
                    }
                    nameFound = regName;
                }
                catch (IOException e) {
                    LOG.error("Couldn't load font with URI {} ({})", (Object)((RuleFontFace.SourceURL)src).getURI(), (Object)e.getMessage());
                }
                catch (FontFormatException e) {
                    LOG.error("Couldn't decode font with URI {} ({})", (Object)((RuleFontFace.SourceURL)src).getURI(), (Object)e.getMessage());
                }
            }
        }
        if (nameFound == null) {
            nameFound = this.fontAvailable(family, systemFontNames);
        }
        return nameFound;
    }

    private List<RuleFontFace.Source> findMatchingFontSources(FontSpec spec) {
        if (this.factory != null) {
            return this.factory.getDecoder().getFontTable().findBestMatch(spec);
        }
        return null;
    }

    public Font createFont(String family, int size, CSSProperty.FontWeight weight, CSSProperty.FontStyle style) {
        int fs = 0;
        if (FontSpec.representsBold(weight)) {
            fs = 1;
        }
        if (style == CSSProperty.FontStyle.ITALIC || style == CSSProperty.FontStyle.OBLIQUE) {
            fs |= 2;
        }
        return new Font(family, fs, size);
    }

    public Font createFont(String family, int size, CSSProperty.FontWeight weight, CSSProperty.FontStyle style, double spacing) {
        Font base = this.createFont(family, size, weight, style);
        if (spacing < 1.0E-4) {
            return base;
        }
        double tracking = spacing / this.fontSize * 0.75;
        HashMap<TextAttribute, Double> attributes = new HashMap<TextAttribute, Double>();
        attributes.put(TextAttribute.TRACKING, tracking);
        return base.deriveFont(attributes);
    }

    private String fontAvailable(String family, String[] avail) {
        for (int i = 0; i < avail.length; ++i) {
            if (!avail[i].equalsIgnoreCase(family)) continue;
            return avail[i];
        }
        return null;
    }

    private PxEvaluator getPxEval() {
        if (this.pxEval == null) {
            this.pxEval = new PxEvaluator(this);
        }
        return this.pxEval;
    }

    private PtEvaluator getPtEval() {
        if (this.ptEval == null) {
            this.ptEval = new PtEvaluator(this);
        }
        return this.ptEval;
    }

    private DegEvaluator getDegEval() {
        if (this.degEval == null) {
            this.degEval = new DegEvaluator(this);
        }
        return this.degEval;
    }

    private RadEvaluator getRadEval() {
        if (this.radEval == null) {
            this.radEval = new RadEvaluator(this);
        }
        return this.radEval;
    }

    private class DegEvaluator
    extends UnitEvaluator {
        public DegEvaluator(VisualContext ctx) {
            super(ctx);
        }

        public double resolveValue(TermFloatValue val) {
            if (val instanceof TermLengthOrPercent) {
                return this.ctx.degAngle((TermAngle)val);
            }
            return 0.0;
        }
    }

    private class RadEvaluator
    extends UnitEvaluator {
        public RadEvaluator(VisualContext ctx) {
            super(ctx);
        }

        public double resolveValue(TermFloatValue val) {
            if (val instanceof TermLengthOrPercent) {
                return this.ctx.radAngle((TermAngle)val);
            }
            return 0.0;
        }
    }

    private class PtEvaluator
    extends UnitEvaluator {
        public PtEvaluator(VisualContext ctx) {
            super(ctx);
        }

        public double resolveValue(TermFloatValue val) {
            if (val instanceof TermLengthOrPercent) {
                return this.ctx.ptLength((TermLengthOrPercent)val, this.whole);
            }
            return 0.0;
        }
    }

    private class PxEvaluator
    extends UnitEvaluator {
        public PxEvaluator(VisualContext ctx) {
            super(ctx);
        }

        public double resolveValue(TermFloatValue val) {
            if (val instanceof TermLengthOrPercent) {
                return this.ctx.pxLength((TermLengthOrPercent)val, this.whole);
            }
            return 0.0;
        }
    }

    private abstract class UnitEvaluator
    extends CalcArgs.DoubleEvaluator {
        protected VisualContext ctx;
        protected double whole;

        public UnitEvaluator(VisualContext ctx) {
            this.ctx = ctx;
        }

        public UnitEvaluator setWhole(double whole) {
            this.whole = whole;
            return this;
        }
    }
}

