/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.render;

import cz.vutbr.web.css.CSSProperty;
import cz.vutbr.web.css.Term;
import cz.vutbr.web.css.TermFunction;
import cz.vutbr.web.css.TermLengthOrPercent;
import cz.vutbr.web.css.TermList;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import org.fit.cssbox.layout.CSSDecoder;
import org.fit.cssbox.layout.ElementBox;

public class Transform {
    public static AffineTransform createTransform(ElementBox elem) {
        if (elem.isBlock() || elem.isReplaced()) {
            int oy;
            int ox;
            CSSDecoder dec = new CSSDecoder(elem.getVisualContext());
            Rectangle bounds = elem.getAbsoluteBorderBounds();
            CSSProperty.TransformOrigin origin = (CSSProperty.TransformOrigin)elem.getStyle().getProperty("transform-origin");
            if (origin == CSSProperty.TransformOrigin.list_values) {
                TermList values = (TermList)elem.getStyle().getValue(TermList.class, "transform-origin");
                ox = dec.getLength((TermLengthOrPercent)values.get(0), false, bounds.width / 2, 0, bounds.width);
                oy = dec.getLength((TermLengthOrPercent)values.get(1), false, bounds.height / 2, 0, bounds.height);
            } else {
                ox = bounds.width / 2;
                oy = bounds.height / 2;
            }
            ox += bounds.x;
            oy += bounds.y;
            AffineTransform ret = null;
            CSSProperty.Transform trans = (CSSProperty.Transform)elem.getStyle().getProperty("transform");
            if (trans == CSSProperty.Transform.list_values) {
                ret = new AffineTransform();
                ret.translate(ox, oy);
                TermList values = (TermList)elem.getStyle().getValue(TermList.class, "transform");
                for (Term term : values) {
                    if (term instanceof TermFunction.Rotate) {
                        double theta = dec.getAngle(((TermFunction.Rotate)term).getAngle());
                        ret.rotate(theta);
                        continue;
                    }
                    if (term instanceof TermFunction.Translate) {
                        int tx = dec.getLength(((TermFunction.Translate)term).getTranslateX(), false, 0, 0, bounds.width);
                        int ty = dec.getLength(((TermFunction.Translate)term).getTranslateY(), false, 0, 0, bounds.height);
                        ret.translate(tx, ty);
                        continue;
                    }
                    if (term instanceof TermFunction.TranslateX) {
                        int tx = dec.getLength(((TermFunction.TranslateX)term).getTranslate(), false, 0, 0, bounds.width);
                        ret.translate(tx, 0.0);
                        continue;
                    }
                    if (term instanceof TermFunction.TranslateY) {
                        int ty = dec.getLength(((TermFunction.TranslateY)term).getTranslate(), false, 0, 0, bounds.height);
                        ret.translate(0.0, ty);
                        continue;
                    }
                    if (term instanceof TermFunction.Scale) {
                        float sx = ((TermFunction.Scale)term).getScaleX();
                        float sy = ((TermFunction.Scale)term).getScaleY();
                        ret.scale(sx, sy);
                        continue;
                    }
                    if (term instanceof TermFunction.ScaleX) {
                        float sx = ((TermFunction.ScaleX)term).getScale();
                        ret.scale(sx, 1.0);
                        continue;
                    }
                    if (term instanceof TermFunction.ScaleY) {
                        float sy = ((TermFunction.ScaleY)term).getScale();
                        ret.scale(1.0, sy);
                        continue;
                    }
                    if (term instanceof TermFunction.Skew) {
                        double ax = dec.getAngle(((TermFunction.Skew)term).getSkewX());
                        double ay = dec.getAngle(((TermFunction.Skew)term).getSkewY());
                        ret.shear(Math.tan(ax), Math.tan(ay));
                        continue;
                    }
                    if (term instanceof TermFunction.SkewX) {
                        double ax = dec.getAngle(((TermFunction.SkewX)term).getSkew());
                        ret.shear(Math.tan(ax), 0.0);
                        continue;
                    }
                    if (term instanceof TermFunction.SkewY) {
                        double ay = dec.getAngle(((TermFunction.SkewY)term).getSkew());
                        ret.shear(0.0, Math.tan(ay));
                        continue;
                    }
                    if (!(term instanceof TermFunction.Matrix)) continue;
                    float[] vals = ((TermFunction.Matrix)term).getValues();
                    ret.concatenate(new AffineTransform(vals));
                }
                ret.translate(-ox, -oy);
            }
            return ret;
        }
        return null;
    }
}

