/*
 * Decompiled with CFR 0.152.
 */
package tools.aqua.bgw.components.uicomponents;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tools.aqua.bgw.components.uicomponents.SelectionMode;
import tools.aqua.bgw.components.uicomponents.UIComponent;
import tools.aqua.bgw.observable.lists.ObservableArrayList;
import tools.aqua.bgw.observable.lists.ObservableList;
import tools.aqua.bgw.observable.lists.ReadonlyObservableList;
import tools.aqua.bgw.observable.properties.Property;
import tools.aqua.bgw.util.Font;
import tools.aqua.bgw.visual.ColorVisual;
import tools.aqua.bgw.visual.Visual;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002BU\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\b\u0010H\u001a\u00020\u0018H\u0002J\u0006\u0010I\u001a\u00020\u0018J\u0013\u0010J\u001a\u00020\u00182\u0006\u0010K\u001a\u00028\u0000\u00a2\u0006\u0002\u0010LJ\u000e\u0010J\u001a\u00020\u00182\u0006\u0010M\u001a\u00020\"J\u0006\u0010N\u001a\u00020\u0018J\u0006\u0010O\u001a\u00020\u0018J\u0006\u0010P\u001a\u00020\u0018J\u0006\u0010Q\u001a\u00020\u0018J\u0006\u0010R\u001a\u00020\u0018R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\"\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u0017X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\"\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u0017X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001a\"\u0004\b\u001f\u0010\u001cR(\u0010 \u001a\u0010\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u0018\u0018\u00010!X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u0017\u0010'\u001a\b\u0012\u0004\u0012\u00020\"0(8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u001a\u0010+\u001a\b\u0012\u0004\u0012\u00020\"0\u0013X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\u0015R\u0017\u0010-\u001a\b\u0012\u0004\u0012\u00028\u00000(8F\u00a2\u0006\u0006\u001a\u0004\b.\u0010*R\u001a\u0010/\u001a\b\u0012\u0004\u0012\u00028\u00000\u0013X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010\u0015R$\u0010\u0010\u001a\u00020\u00112\u0006\u00101\u001a\u00020\u00118F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u0017\u00106\u001a\b\u0012\u0004\u0012\u00020\u001107\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00109R$\u0010\u000e\u001a\u00020\u000f2\u0006\u00101\u001a\u00020\u000f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=R\u0017\u0010>\u001a\b\u0012\u0004\u0012\u00020\u000f07\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u00109R$\u0010A\u001a\u00020@2\u0006\u00101\u001a\u00020@8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bB\u0010C\"\u0004\bD\u0010ER\u0017\u0010F\u001a\b\u0012\u0004\u0012\u00020@07\u00a2\u0006\b\n\u0000\u001a\u0004\bG\u00109\u0082\u0001\u0002ST\u00a8\u0006U"}, d2={"Ltools/aqua/bgw/components/uicomponents/StructuredDataView;", "T", "Ltools/aqua/bgw/components/uicomponents/UIComponent;", "posX", "", "posY", "width", "height", "items", "", "font", "Ltools/aqua/bgw/util/Font;", "visual", "Ltools/aqua/bgw/visual/Visual;", "selectionMode", "Ltools/aqua/bgw/components/uicomponents/SelectionMode;", "selectionBackground", "Ltools/aqua/bgw/visual/ColorVisual;", "(Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;Ljava/util/List;Ltools/aqua/bgw/util/Font;Ltools/aqua/bgw/visual/Visual;Ltools/aqua/bgw/components/uicomponents/SelectionMode;Ltools/aqua/bgw/visual/ColorVisual;)V", "Ltools/aqua/bgw/observable/lists/ObservableList;", "getItems", "()Ltools/aqua/bgw/observable/lists/ObservableList;", "onSelectAllEvent", "Lkotlin/Function0;", "", "getOnSelectAllEvent$bgw_gui", "()Lkotlin/jvm/functions/Function0;", "setOnSelectAllEvent$bgw_gui", "(Lkotlin/jvm/functions/Function0;)V", "onSelectNoneEvent", "getOnSelectNoneEvent$bgw_gui", "setOnSelectNoneEvent$bgw_gui", "onSelectionEvent", "Lkotlin/Function1;", "", "getOnSelectionEvent$bgw_gui", "()Lkotlin/jvm/functions/Function1;", "setOnSelectionEvent$bgw_gui", "(Lkotlin/jvm/functions/Function1;)V", "selectedIndices", "Ltools/aqua/bgw/observable/lists/ReadonlyObservableList;", "getSelectedIndices", "()Ltools/aqua/bgw/observable/lists/ReadonlyObservableList;", "selectedIndicesList", "getSelectedIndicesList$bgw_gui", "selectedItems", "getSelectedItems", "selectedItemsList", "getSelectedItemsList$bgw_gui", "value", "getSelectionBackground", "()Ltools/aqua/bgw/visual/ColorVisual;", "setSelectionBackground", "(Ltools/aqua/bgw/visual/ColorVisual;)V", "selectionBackgroundProperty", "Ltools/aqua/bgw/observable/properties/Property;", "getSelectionBackgroundProperty", "()Ltools/aqua/bgw/observable/properties/Property;", "getSelectionMode", "()Ltools/aqua/bgw/components/uicomponents/SelectionMode;", "setSelectionMode", "(Ltools/aqua/bgw/components/uicomponents/SelectionMode;)V", "selectionModeProperty", "getSelectionModeProperty", "", "selectionStyle", "getSelectionStyle", "()Ljava/lang/String;", "setSelectionStyle", "(Ljava/lang/String;)V", "selectionStyleProperty", "getSelectionStyleProperty", "checkSelectionEnabled", "clearSelection", "select", "element", "(Ljava/lang/Object;)V", "index", "selectAll", "selectFirst", "selectLast", "selectNext", "selectPrevious", "Ltools/aqua/bgw/components/uicomponents/ListView;", "Ltools/aqua/bgw/components/uicomponents/TableView;", "bgw-gui"})
public abstract class StructuredDataView<T>
extends UIComponent {
    @NotNull
    private final ObservableList<T> items;
    @NotNull
    private final Property<SelectionMode> selectionModeProperty;
    @NotNull
    private final Property<ColorVisual> selectionBackgroundProperty;
    @NotNull
    private final Property<String> selectionStyleProperty;
    @NotNull
    private final ObservableList<T> selectedItemsList;
    @NotNull
    private final ObservableList<Integer> selectedIndicesList;
    @Nullable
    private Function1<? super Integer, Unit> onSelectionEvent;
    @Nullable
    private Function0<Unit> onSelectAllEvent;
    @Nullable
    private Function0<Unit> onSelectNoneEvent;

    private StructuredDataView(Number posX, Number posY, Number width, Number height, List<? extends T> items, Font font, Visual visual, SelectionMode selectionMode, ColorVisual selectionBackground) {
        super(posX, posY, width, height, font, visual, null);
        this.items = new ObservableArrayList((Collection)items);
        this.selectionModeProperty = new Property<SelectionMode>(selectionMode);
        this.selectionBackgroundProperty = new Property<ColorVisual>(selectionBackground);
        this.selectionStyleProperty = new Property<String>("");
        this.selectedItemsList = new ObservableArrayList(null, 1, null);
        this.selectedIndicesList = new ObservableArrayList(null, 1, null);
    }

    @NotNull
    public final ObservableList<T> getItems() {
        return this.items;
    }

    @NotNull
    public final Property<SelectionMode> getSelectionModeProperty() {
        return this.selectionModeProperty;
    }

    @NotNull
    public final SelectionMode getSelectionMode() {
        return this.selectionModeProperty.getValue();
    }

    public final void setSelectionMode(@NotNull SelectionMode value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this.selectionModeProperty.setValue(value);
    }

    @NotNull
    public final Property<ColorVisual> getSelectionBackgroundProperty() {
        return this.selectionBackgroundProperty;
    }

    @NotNull
    public final ColorVisual getSelectionBackground() {
        return this.selectionBackgroundProperty.getValue();
    }

    public final void setSelectionBackground(@NotNull ColorVisual value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.selectionBackgroundProperty.setValue(value);
    }

    @NotNull
    public final Property<String> getSelectionStyleProperty() {
        return this.selectionStyleProperty;
    }

    @NotNull
    public final String getSelectionStyle() {
        return this.selectionStyleProperty.getValue();
    }

    public final void setSelectionStyle(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.selectionStyleProperty.setValue(value);
    }

    @NotNull
    public final ObservableList<T> getSelectedItemsList$bgw_gui() {
        return this.selectedItemsList;
    }

    @NotNull
    public final ReadonlyObservableList<T> getSelectedItems() {
        return this.selectedItemsList;
    }

    @NotNull
    public final ObservableList<Integer> getSelectedIndicesList$bgw_gui() {
        return this.selectedIndicesList;
    }

    @NotNull
    public final ReadonlyObservableList<Integer> getSelectedIndices() {
        return this.selectedIndicesList;
    }

    @Nullable
    public final Function1<Integer, Unit> getOnSelectionEvent$bgw_gui() {
        return this.onSelectionEvent;
    }

    public final void setOnSelectionEvent$bgw_gui(@Nullable Function1<? super Integer, Unit> function1) {
        this.onSelectionEvent = function1;
    }

    @Nullable
    public final Function0<Unit> getOnSelectAllEvent$bgw_gui() {
        return this.onSelectAllEvent;
    }

    public final void setOnSelectAllEvent$bgw_gui(@Nullable Function0<Unit> function0) {
        this.onSelectAllEvent = function0;
    }

    @Nullable
    public final Function0<Unit> getOnSelectNoneEvent$bgw_gui() {
        return this.onSelectNoneEvent;
    }

    public final void setOnSelectNoneEvent$bgw_gui(@Nullable Function0<Unit> function0) {
        this.onSelectNoneEvent = function0;
    }

    public final void select(int index) {
        block2: {
            this.checkSelectionEnabled();
            IntRange intRange = this.items.getIndices();
            int n = intRange.getFirst();
            if (!(index <= intRange.getLast() ? n <= index : false)) {
                boolean bl = false;
                String string = "Index is out of bounds.";
                throw new IllegalArgumentException(string.toString());
            }
            if (this.getSelectedIndices().getSize() == 1 && ((Number)this.getSelectedIndices().get(0)).intValue() == index) {
                return;
            }
            Function1<? super Integer, Unit> function1 = this.onSelectionEvent;
            if (function1 == null) break block2;
            function1.invoke((Object)index);
        }
    }

    public final void select(T element2) {
        if (!this.items.contains(element2)) {
            boolean bl = false;
            String string = "Cannot select element because it is not contained in this UIComponent.";
            throw new IllegalArgumentException(string.toString());
        }
        this.select(this.items.indexOf(element2));
    }

    public final void selectFirst() {
        this.select(0);
    }

    public final void selectLast() {
        this.select(this.items.getSize() - 1);
    }

    public final void selectNext() {
        if (!(this.getSelectionMode() == SelectionMode.SINGLE)) {
            boolean bl = false;
            String string = "Cannot select next item in selection mode '" + this.getSelectionMode() + "'.";
            throw new IllegalStateException(string.toString());
        }
        if (this.getSelectedIndices().isEmpty()) {
            this.select(0);
        } else if (((Number)this.getSelectedIndices().get(0)).intValue() < this.items.getSize() - 1) {
            this.select(((Number)this.getSelectedIndices().get(0)).intValue() + 1);
        }
    }

    public final void selectPrevious() {
        if (!(this.getSelectionMode() == SelectionMode.SINGLE)) {
            boolean bl = false;
            String string = "Cannot select previous item in selection mode '" + this.getSelectionMode() + "'.";
            throw new IllegalStateException(string.toString());
        }
        if (this.getSelectedIndices().isEmpty()) {
            this.select(this.items.getSize() - 1);
        } else if (((Number)this.getSelectedIndices().get(0)).intValue() > 0) {
            this.select(((Number)this.getSelectedIndices().get(0)).intValue() - 1);
        }
    }

    public final void selectAll() {
        block2: {
            if (!(this.getSelectionMode() == SelectionMode.MULTIPLE)) {
                boolean $i$a$-check-StructuredDataView$selectAll$22 = false;
                String $i$a$-check-StructuredDataView$selectAll$22 = "Cannot select all items in selection mode '" + this.getSelectionMode() + "'.";
                throw new IllegalStateException($i$a$-check-StructuredDataView$selectAll$22.toString());
            }
            if (!this.items.isNotEmpty()) {
                boolean bl = false;
                String string = "Cannot select all items because items list is empty.";
                throw new IllegalArgumentException(string.toString());
            }
            Function0<Unit> function0 = this.onSelectAllEvent;
            if (function0 == null) break block2;
            function0.invoke();
        }
    }

    public final void clearSelection() {
        block1: {
            this.checkSelectionEnabled();
            if (this.getSelectedIndices().getSize() <= 0) break block1;
            Function0<Unit> function0 = this.onSelectNoneEvent;
            if (function0 != null) {
                function0.invoke();
            }
        }
    }

    private final void checkSelectionEnabled() {
        if (!(this.getSelectionMode() != SelectionMode.NONE)) {
            boolean bl = false;
            String string = "Cannot select items in selection mode 'NONE'.";
            throw new IllegalStateException(string.toString());
        }
    }

    public /* synthetic */ StructuredDataView(Number posX, Number posY, Number width, Number height, List items, Font font, Visual visual, SelectionMode selectionMode, ColorVisual selectionBackground, DefaultConstructorMarker $constructor_marker) {
        this(posX, posY, width, height, items, font, visual, selectionMode, selectionBackground);
    }
}

