/*
 * Decompiled with CFR 0.152.
 */
package tools.aqua.bgw.visual;

import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tools.aqua.bgw.observable.properties.Property;
import tools.aqua.bgw.visual.SingleLayerVisual;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB7\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tB7\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\fB5\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0019\u001a\u00020\u0000H\u0016R$\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001b"}, d2={"Ltools/aqua/bgw/visual/ImageVisual;", "Ltools/aqua/bgw/visual/SingleLayerVisual;", "path", "", "width", "", "height", "offsetX", "offsetY", "(Ljava/lang/String;IIII)V", "file", "Ljava/io/File;", "(Ljava/io/File;IIII)V", "image", "Ljava/awt/image/BufferedImage;", "(Ljava/awt/image/BufferedImage;IIII)V", "value", "getImage", "()Ljava/awt/image/BufferedImage;", "setImage", "(Ljava/awt/image/BufferedImage;)V", "imageProperty", "Ltools/aqua/bgw/observable/properties/Property;", "getImageProperty", "()Ltools/aqua/bgw/observable/properties/Property;", "copy", "Companion", "bgw-gui"})
public class ImageVisual
extends SingleLayerVisual {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Property<BufferedImage> imageProperty;

    public ImageVisual(@NotNull BufferedImage image, int width, int height, int offsetX, int offsetY) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        super(null);
        if (!(offsetX < image.getWidth())) {
            boolean $i$a$-require-ImageVisual$92 = false;
            String $i$a$-require-ImageVisual$92 = "OffsetX is larger than image width.";
            throw new IllegalArgumentException($i$a$-require-ImageVisual$92.toString());
        }
        if (!(offsetY < image.getHeight())) {
            boolean $i$a$-require-ImageVisual$102 = false;
            String $i$a$-require-ImageVisual$102 = "OffsetY is larger than image height.";
            throw new IllegalArgumentException($i$a$-require-ImageVisual$102.toString());
        }
        if (!(width > 0 || width == -1)) {
            boolean $i$a$-require-ImageVisual$112 = false;
            String $i$a$-require-ImageVisual$112 = "Width must be positive or -1.";
            throw new IllegalArgumentException($i$a$-require-ImageVisual$112.toString());
        }
        if (!(height > 0 || height == -1)) {
            boolean $i$a$-require-ImageVisual$122 = false;
            String $i$a$-require-ImageVisual$122 = "Height must be positive or -1.";
            throw new IllegalArgumentException($i$a$-require-ImageVisual$122.toString());
        }
        int subWidth = width != -1 ? width : image.getWidth() - offsetX;
        int subHeight = height != -1 ? height : image.getHeight() - offsetY;
        if (!(subWidth > 0)) {
            boolean $i$a$-require-ImageVisual$132 = false;
            String $i$a$-require-ImageVisual$132 = "Width exceeds image width.";
            throw new IllegalArgumentException($i$a$-require-ImageVisual$132.toString());
        }
        if (!(subHeight > 0)) {
            boolean $i$a$-require-ImageVisual$142 = false;
            String $i$a$-require-ImageVisual$142 = "Height exceeds image height.";
            throw new IllegalArgumentException($i$a$-require-ImageVisual$142.toString());
        }
        if (!(offsetX + subWidth <= image.getWidth())) {
            boolean $i$a$-require-ImageVisual$152 = false;
            String $i$a$-require-ImageVisual$152 = "Width of SubImage exceeds image bounds.";
            throw new IllegalArgumentException($i$a$-require-ImageVisual$152.toString());
        }
        if (!(offsetY + subHeight <= image.getHeight())) {
            boolean bl = false;
            String string = "Height of SubImage exceeds image bounds.";
            throw new IllegalArgumentException(string.toString());
        }
        BufferedImage img = image.getSubimage(offsetX, offsetY, subWidth, subHeight);
        Intrinsics.checkNotNullExpressionValue((Object)img, (String)"img");
        this.imageProperty = new Property<BufferedImage>(img);
    }

    public /* synthetic */ ImageVisual(BufferedImage bufferedImage, int n, int n2, int n3, int n4, int n5, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n5 & 2) != 0) {
            n = -1;
        }
        if ((n5 & 4) != 0) {
            n2 = -1;
        }
        if ((n5 & 8) != 0) {
            n3 = 0;
        }
        if ((n5 & 0x10) != 0) {
            n4 = 0;
        }
        this(bufferedImage, n, n2, n3, n4);
    }

    @NotNull
    public final Property<BufferedImage> getImageProperty() {
        return this.imageProperty;
    }

    @NotNull
    public final BufferedImage getImage() {
        return this.imageProperty.getValue();
    }

    public final void setImage(@NotNull BufferedImage value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.imageProperty.setValue(value);
    }

    public ImageVisual(@NotNull String path, int width, int height, int offsetX, int offsetY) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this(ImageVisual.Companion.load(path), width, height, offsetX, offsetY);
    }

    public /* synthetic */ ImageVisual(String string, int n, int n2, int n3, int n4, int n5, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n5 & 2) != 0) {
            n = -1;
        }
        if ((n5 & 4) != 0) {
            n2 = -1;
        }
        if ((n5 & 8) != 0) {
            n3 = 0;
        }
        if ((n5 & 0x10) != 0) {
            n4 = 0;
        }
        this(string, n, n2, n3, n4);
    }

    public ImageVisual(@NotNull File file, int width, int height, int offsetX, int offsetY) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = file.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.absolutePath");
        this(string, width, height, offsetX, offsetY);
    }

    public /* synthetic */ ImageVisual(File file, int n, int n2, int n3, int n4, int n5, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n5 & 2) != 0) {
            n = -1;
        }
        if ((n5 & 4) != 0) {
            n2 = -1;
        }
        if ((n5 & 8) != 0) {
            n3 = 0;
        }
        if ((n5 & 0x10) != 0) {
            n4 = 0;
        }
        this(file, n, n2, n3, n4);
    }

    @Override
    @NotNull
    public ImageVisual copy() {
        ImageVisual imageVisual;
        ImageVisual $this$copy_u24lambda_u2d8 = imageVisual = new ImageVisual(this.getImage(), 0, 0, 0, 0, 30, null);
        boolean bl = false;
        $this$copy_u24lambda_u2d8.setTransparency(this.getTransparency());
        return imageVisual;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0007"}, d2={"Ltools/aqua/bgw/visual/ImageVisual$Companion;", "", "()V", "load", "Ljava/awt/image/BufferedImage;", "file", "", "bgw-gui"})
    public static final class Companion {
        private Companion() {
        }

        private final BufferedImage load(String file) {
            BufferedImage bufferedImage = ImageIO.read(this.getClass().getClassLoader().getResource(file));
            Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"read(this::class.java.cl\u2026Loader.getResource(file))");
            return bufferedImage;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

