/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.base.key;

import com.alexbarter.ciphertool.lib.ListUtil;
import com.alexbarter.ciphertool.lib.matrix.Matrix;
import com.alexbarter.lib.Triple;
import com.alexbarter.lib.util.ArrayUtil;
import com.alexbarter.lib.util.RandomUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class KeyGeneration {
    public static String createRepeatingShortKey26(int length) {
        return KeyGeneration.createRepeatingShortKeyUniversal("ABCDEFGHIJKLMNOPQRSTUVWXYZ", length);
    }

    public static String createShortKey26(int length) {
        return KeyGeneration.createDistinctKeyUniversal("ABCDEFGHIJKLMNOPQRSTUVWXYZ", length);
    }

    public static String createRepeatingShortKeyUniversal(CharSequence charList, int length) {
        char[] key = new char[length];
        for (int i = 0; i < length; ++i) {
            key[i] = RandomUtil.pickRandomChar((CharSequence)charList);
        }
        return new String(key);
    }

    public static String createDistinctKeyUniversal(CharSequence charList, int length) {
        List indices = ListUtil.range((int)0, (int)(charList.length() - 1));
        char[] key = new char[length];
        for (int i = 0; i < length; ++i) {
            int index = (Integer)RandomUtil.removeRandomElement((List)indices);
            key[i] = charList.charAt(index);
        }
        return new String(key);
    }

    public static String createLongKeyUniversal(CharSequence charList) {
        return KeyGeneration.createDistinctKeyUniversal(charList, charList.length());
    }

    public static String createLongKey25() {
        return KeyGeneration.createLongKeyUniversal("ABCDEFGHIKLMNOPQRSTUVWXYZ");
    }

    public static String createLongKey26() {
        return KeyGeneration.createLongKeyUniversal("ABCDEFGHIJKLMNOPQRSTUVWXYZ");
    }

    public static String createLongKey27() {
        return KeyGeneration.createLongKeyUniversal("ABCDEFGHIJKLMNOPQRSTUVWXYZ#");
    }

    public static String createLongKey36() {
        return KeyGeneration.createLongKeyUniversal("ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789");
    }

    public static Integer[] createRepeatingShortOrderKey(int entryRange, int length) {
        Integer[] key = new Integer[length];
        for (int i = 0; i < length; ++i) {
            key[i] = RandomUtil.pickRandomInt((int)0, (int)(entryRange - 1));
        }
        return key;
    }

    public static Integer[] createShortOrderKey(int entryRange, int length) {
        List integers = ListUtil.range((int)0, (int)(entryRange - 1));
        Integer[] key = new Integer[length];
        for (int i = 0; i < length; ++i) {
            key[i] = (Integer)RandomUtil.pickRandomElement((List)integers);
            integers.remove(key[i]);
        }
        return key;
    }

    public static Integer[] createOrder(int length) {
        return (Integer[])ArrayUtil.shuffle((Object[])ArrayUtil.createRangeInteger((int)length));
    }

    public static List<Integer> createOrderList(int length) {
        return ListUtil.toList((Object[])KeyGeneration.createOrder(length));
    }

    public static Character[] createKeyGuaranteed(CharSequence alphabet, int length) {
        int i;
        if (length < alphabet.length()) {
            throw new IllegalArgumentException("Length of key must be greater or equal to the number of characters in the alphabet");
        }
        List indices = ListUtil.range((int)0, (int)(alphabet.length() - 1));
        Object[] key = new Character[length];
        for (i = 0; i < alphabet.length(); ++i) {
            int index = (Integer)RandomUtil.removeRandomElement((List)indices);
            key[i] = Character.valueOf(alphabet.charAt(index));
        }
        while (i < key.length) {
            key[i] = Character.valueOf(RandomUtil.pickRandomChar((CharSequence)alphabet));
            ++i;
        }
        return (Character[])ArrayUtil.shuffle((Object[])key);
    }

    public static int[] createSwagmanKey(int size) {
        int[] key = new int[size * size];
        Arrays.fill(key, -1);
        ArrayList<Triple> options = new ArrayList<Triple>(size);
        int ite = 0;
        block0: while (ite < size) {
            options.clear();
            for (int col = 0; col < ite; ++col) {
                options.add(new Triple((Object)(ite * size + col), (Object)true, KeyGeneration.getOptionsForCell(key, size, ite, col)));
            }
            for (int row = 0; row < ite; ++row) {
                options.add(new Triple((Object)(row * size + ite), (Object)false, KeyGeneration.getOptionsForCell(key, size, row, ite)));
            }
            List<Integer> corner = KeyGeneration.getOptionsForCell(key, size, ite, ite);
            while (options.size() > 0) {
                Integer test;
                Triple pair = (Triple)options.remove(0);
                Integer random = null;
                while (true) {
                    if (((List)pair.getRight()).isEmpty()) {
                        boolean resetAll = true;
                        if (!resetAll) {
                            for (int r = 0; r < size / 2; ++r) {
                                if (ite <= 0) continue;
                                for (int col = 0; col < ite; ++col) {
                                    key[ite * size + col] = -1;
                                }
                                for (int row = 0; row < ite; ++row) {
                                    key[row * size + ite] = -1;
                                }
                                key[ite * size + ite] = -1;
                                --ite;
                            }
                            continue block0;
                        }
                        ite = 0;
                        Arrays.fill(key, -1);
                        continue block0;
                    }
                    test = random = (Integer)RandomUtil.pickRandomElement((List)((List)pair.getRight()));
                    if (options.stream().filter(arg_0 -> ((Triple)pair).middleEquals(arg_0)).filter(t -> ((List)t.getRight()).contains(test)).anyMatch(t -> ((List)t.getRight()).size() <= 1)) {
                        ((List)pair.getRight()).remove(test);
                        continue;
                    }
                    options.stream().filter(arg_0 -> ((Triple)pair).middleEquals(arg_0)).forEach(t -> ((List)t.getRight()).remove(test));
                    if (!corner.contains(test) || corner.size() > 1) break;
                    ((List)pair.getRight()).remove(test);
                }
                corner.remove(test);
                Integer sucess = random;
                key[((Integer)pair.getLeft()).intValue()] = random;
            }
            key[ite * size + ite] = (Integer)RandomUtil.pickRandomElement(corner);
            ++ite;
        }
        return key;
    }

    public static int[] createSwagmanKey3(int size) {
        while (true) {
            try {
                int[] key = new int[size * size];
                Arrays.fill(key, -1);
                block3: while (!KeyGeneration.isFilled(key, size)) {
                    for (int row = 0; row < size; ++row) {
                        for (int col = 0; col < size; ++col) {
                            boolean change = KeyGeneration.autoFill(key, size);
                            if (change) continue block3;
                            if (key[row * size + col] != -1) continue;
                            List<Integer> options = KeyGeneration.getOptionsForCell(key, size, row, col);
                            Integer option = (Integer)RandomUtil.pickRandomElement(options);
                            key[row * size + col] = option;
                            options.remove(option);
                        }
                    }
                }
                return key;
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }

    private static boolean isFilled(int[] key, int size) {
        for (int row = 0; row < size; ++row) {
            for (int col = 0; col < size; ++col) {
                if (key[row * size + col] != -1) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean autoFill(int[] key, int size) {
        boolean finished;
        boolean change = false;
        block0: do {
            finished = true;
            for (int row = 0; row < size; ++row) {
                for (int col = 0; col < size; ++col) {
                    List<Integer> options;
                    if (key[row * size + col] != -1 || (options = KeyGeneration.getOptionsForCell(key, size, row, col)).size() != 1) continue;
                    key[row * size + col] = options.get(0);
                    finished = false;
                    change = true;
                    continue block0;
                }
            }
        } while (!finished);
        return change;
    }

    private static List<Integer> getOptionsForCell(int[] key, int size, int row, int column) {
        List validOptions = ListUtil.range((int)0, (int)(size - 1));
        for (int nC = 0; nC < size; ++nC) {
            validOptions.remove((Object)key[row * size + nC]);
        }
        for (int nR = 0; nR < size; ++nR) {
            validOptions.remove((Object)key[nR * size + column]);
        }
        return validOptions;
    }

    private static Integer[] createGenericGrilleKey(int size) {
        double half = (double)size / 2.0;
        int rows = (int)Math.ceil(half);
        int cols = (int)Math.floor(half);
        int keyLength = rows * cols;
        Integer[] key = new Integer[keyLength];
        int count = 0;
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < cols; ++c) {
                key[count++] = r * size + c;
            }
        }
        return key;
    }

    public static Integer[] createGrilleKey(int size) {
        Integer[] key = KeyGeneration.createGenericGrilleKey(size);
        for (int i = 0; i < key.length; ++i) {
            int quadrant = RandomUtil.pickRandomInt((int)4);
            int value = key[i];
            for (int rot = 0; rot < quadrant; ++rot) {
                int row = value / size;
                int col = value % size;
                value = col * size + (size - row - 1);
            }
            key[i] = value;
        }
        return key;
    }

    public static String createShortKey26(int minLength, int maxLength) {
        int length = RandomUtil.pickRandomInt((int)minLength, (int)maxLength);
        return KeyGeneration.createShortKey26(length);
    }

    public static String createRepeatingShortKey26(int minLength, int maxLength) {
        int length = RandomUtil.pickRandomInt((int)minLength, (int)maxLength);
        return KeyGeneration.createRepeatingShortKey26(length);
    }

    public static Integer[] createOrder(int minLength, int maxLength) {
        int length = RandomUtil.pickRandomInt((int)minLength, (int)maxLength);
        return KeyGeneration.createOrder(length);
    }

    public static Integer[] createGrilleKey(int minLength, int maxLength) {
        int length = RandomUtil.pickRandomInt((int)minLength, (int)maxLength);
        return KeyGeneration.createGrilleKey(length);
    }

    public static Matrix createMatrix(int size, int range) {
        return KeyGeneration.createMatrix(size, size, range);
    }

    public static Matrix createMatrix(int rows, int columns, int range) {
        Matrix matrix = new Matrix(rows, columns);
        for (int i = 0; i < matrix.data.length; ++i) {
            matrix.data[i] = RandomUtil.pickRandomInt((int)range);
        }
        return matrix;
    }
}

