/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.base.settings;

import com.alexbarter.ciphertool.base.interfaces.ISettings;
import com.alexbarter.ciphertool.lib.Cache;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;

public class SettingCache<T>
extends Cache<T> {
    private final ISettings settings;
    private final String key;
    private final Function<T, ?> reverse;

    private SettingCache(ISettings settings, String key, Supplier<T> loadIn) {
        this(settings, key, null, loadIn);
    }

    private SettingCache(ISettings settings, String key, Function<T, ?> reverse, Supplier<T> loadIn) {
        super(loadIn);
        this.settings = settings;
        this.key = key;
        this.reverse = reverse;
    }

    public void update(T value) {
        this.value = value;
        this.settings.put(this.key, this.reverse != null ? this.reverse.apply(value) : value);
        this.settings.markDirty();
    }

    public static <T> SettingCache<T> create(ISettings settings, String key, T default_) {
        return new SettingCache<Object>(settings, key, () -> settings.get(key, default_));
    }

    public static <T> SettingCache<List<T>> create(ISettings settings, String key, List<T> default_) {
        return new SettingCache<List<T>>(settings, key, () -> settings.getList(key, default_));
    }

    public static <T> SettingCache<Map<String, T>> create(ISettings settings, String key, Map<String, T> default_) {
        return new SettingCache<Map<String, T>>(settings, key, () -> settings.getMap(key, default_));
    }

    public static <I, T> SettingCache<T> create(ISettings settings, String key, Function<I, T> function, Function<T, I> reverse, Class<I> type, T default_) {
        return new SettingCache<Object>(settings, key, reverse, () -> settings.get(key, function, type, default_));
    }
}

