/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.base.solve;

import com.alexbarter.ciphertool.base.interfaces.IAttackMethod;
import com.alexbarter.ciphertool.base.interfaces.IDecryptionTracker;
import com.alexbarter.ciphertool.base.settings.SettingsCache;
import com.alexbarter.ciphertool.lib.CipherUtils;
import com.alexbarter.ciphertool.lib.parallel.MasterThread;
import java.io.PrintStream;
import java.math.BigInteger;

public interface IBruteForceAttack<K>
extends IAttackMethod<K> {
    default public IDecryptionTracker tryBruteForce(IDecryptionTracker tracker) {
        BigInteger totalKeys = this.getCipher().getNumOfKeys();
        this.output(tracker, CipherUtils.formatBigInteger((BigInteger)totalKeys) + " Keys to search", new Object[0]);
        tracker.getProgress().addMax(totalKeys);
        if (((Boolean)SettingsCache.useParallel.get()).booleanValue()) {
            MasterThread thread = new MasterThread(control -> this.getCipher().iterateKeys(key -> {
                Runnable job = () -> {
                    this.decryptAndUpdate(tracker, key);
                    tracker.getProgress().increment();
                };
                return !control.tryAddJob(job, 20L).end();
            })).setErrorHandler(MasterThread.defaultErrorHandler((PrintStream)tracker.out()));
            thread.start();
            thread.waitTillCompleted(tracker::shouldStop);
        } else {
            this.getCipher().iterateKeys(key -> {
                if (tracker.shouldStop()) {
                    return false;
                }
                this.decryptAndUpdate(tracker, key);
                tracker.getProgress().increment();
                return true;
            });
        }
        tracker.getProgress().finish();
        return tracker;
    }
}

